/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.agent;

import com.sun.swup.client.agent.SwupAgentData;
import com.sun.swup.client.agent.SwupCommand;
import com.sun.swup.client.common.ExecuteCommand;
import java.text.MessageFormat;

public class SwupSetPrefCommand
extends SwupCommand {
    private static boolean debug = false;
    private static SwupAgentData sad = null;
    private String checkinVal = "";
    private int checkinValInt = -1;
    private String propName = "";
    private String propValue = "";

    public SwupSetPrefCommand() {
        sad = SwupAgentData.getInstance();
        debug = sad.getDebug();
    }

    public void setPropValue(String val) {
        this.propValue = val;
    }

    public void setPropName(String nm) {
        this.propName = nm;
    }

    public void setCheckinIntervalPref(String checkInt) {
        this.checkinVal = checkInt;
        try {
            this.checkinValInt = Integer.parseInt(checkInt);
            if (this.checkinValInt < 2 || this.checkinValInt > 48) {
                this.checkinValInt = -1;
            }
        }
        catch (NumberFormatException nfe) {
            this.checkinValInt = -1;
        }
    }

    public boolean needFreshAnalysis() {
        return false;
    }

    public String getRespMsg() {
        StringBuffer resMsg = new StringBuffer();
        MessageFormat msgFmt = new MessageFormat("<swup:Response swup:id=\"{0}\" swup:locale=\"{1}\" swup:status=\"{2}\" xmlns:swup=\"http://www.sun.com/swup/command\">\n");
        String lang = sad.getLocale().toString();
        Object[] msgArgs = new Object[]{this.getRefID(), lang, "SUCCESS"};
        resMsg.append(msgFmt.format(msgArgs));
        resMsg.append("    <swup:PreferenceChange>\n");
        int errCode = this.getCmdErrorCode();
        String status = errCode != 0 ? "FAILED" : "SUCCESS";
        msgFmt = new MessageFormat("        <swup:Preference swup:name=\"SwupCheckinInterval\" swup:value=\"{0}\" swup:status=\"{1}\">\n");
        Object[] msgArgs2 = new Object[]{this.checkinVal, status};
        resMsg.append(msgFmt.format(msgArgs2));
        if (errCode != 0) {
            msgFmt = new MessageFormat("            <swup:Detail swup:code=\"{0}\" >\n");
            Object[] msgArgs4 = new Object[]{"ccr." + errCode};
            resMsg.append(msgFmt.format(msgArgs4));
            resMsg.append("                <swup:Message>\n");
            msgFmt = new MessageFormat("                    {0}");
            Object[] msgArgs5 = new Object[]{this.getCmdErrorMsg()};
            resMsg.append(msgFmt.format(msgArgs5));
            resMsg.append("                </swup:Message>\n");
            resMsg.append("            </swup:Detail >\n");
        }
        msgFmt = new MessageFormat("            <swup:Property swup:name=\"{0}\" swup:value=\"{1}\"/>\n");
        Object[] msgArgs6 = new Object[]{this.propName, this.propValue};
        resMsg.append(msgFmt.format(msgArgs6));
        resMsg.append("        </swup:Preference>\n");
        resMsg.append("    </swup:PreferenceChange>\n");
        resMsg.append("</swup:Response>");
        return resMsg.toString();
    }

    public int executeCommand() {
        int retstatus = 0;
        if (this.checkinValInt != -1) {
            String ccrCmd = "/usr/lib/cc-ccr/bin/ccr -p cns.swup.checkinInterval -v " + this.checkinValInt;
            ExecuteCommand ec = new ExecuteCommand(ccrCmd);
            if (debug) {
                System.out.println("in executeInstall(), install cmd:" + ccrCmd);
            }
            ec.setCollectOutput(true);
            try {
                if (debug) {
                    System.out.println("starting to execute set pref cmd....");
                }
                ec.execute();
            }
            catch (InterruptedException ie) {
                retstatus = -1;
                return retstatus;
            }
            String cmdOutput = ec.getAllOutput();
            if (debug) {
                System.out.println("collected output: \n" + cmdOutput);
            }
            retstatus = ec.getResult();
            if (debug) {
                System.out.println("cmd ret status: " + retstatus);
            }
            this.setCmdErrorCode(retstatus);
            this.setCmdErrorMsg(cmdOutput);
        } else {
            retstatus = -1;
        }
        return retstatus;
    }

    public void dumpIt() {
        System.out.println("\nSWUP Command:");
        System.out.println("cmd type: set pref");
        System.out.println("Transport RefID: " + this.getTransportRefID());
        System.out.println("Swup Serv RefID: " + this.getRefID());
    }

    public void dumpResp() {
        System.out.println("\nSWUP Command Response:");
        System.out.println("resp type: set pref");
        System.out.println("Response xml: \n" + this.getRespMsg());
    }
}

