/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.util.IncompatibleVersionException;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.NumberOutOfRangeException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Version
implements Serializable {
    private int[] versions = new int[LEVELS];
    private int numVersions;
    private static int LEVELS = 4;
    private NumberOutOfRangeException lnkNumberOutOfRangeException;
    private InvalidVersionException lnkInvalidVersionException;
    private IncompatibleVersionException lnkIncompatibleVersionException;

    public Version(String string) throws InvalidVersionException {
        this.parseString(string);
    }

    public int compareTo(Version version) {
        if (version == null) {
            return 1;
        }
        for (int i = 0; i < LEVELS; ++i) {
            if (this.numVersions == i && version.numVersions > i) {
                return -1;
            }
            if (version.numVersions == i && this.numVersions > i) {
                return 1;
            }
            if (this.versions[i] > version.versions[i]) {
                return 1;
            }
            if (this.versions[i] >= version.versions[i]) continue;
            return -1;
        }
        return 0;
    }

    public String getVersion() {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(this.versions[0]));
        for (int i = 1; i < this.numVersions; ++i) {
            stringBuffer.append("." + this.versions[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getVersion();
    }

    private void parseString(String string) throws InvalidVersionException {
        if (string == null) {
            throw new InvalidVersionException("Null version string.");
        }
        if (string.indexOf(".") == -1) {
            throw new InvalidVersionException("Too few dots in version string: \"" + string + "\"");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() > 4) {
            throw new InvalidVersionException("Too many dots in version string: \"" + string + "\"");
        }
        this.numVersions = stringTokenizer.countTokens();
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            try {
                this.versions[n] = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidVersionException("Parse error on version. \"" + string + "\"" + " on substring \"" + string2 + "\"");
            }
            ++n;
        }
    }
}

