/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.util.ConfigException;
import com.sun.patchpro.util.Percentage;
import java.io.File;

public interface PatchServiceProvider {
    public static final String DOWNLOAD_SUMMARY_FILE_PREFIX = "patchpro_dnld_";
    public static final String DOWNLOAD_SUMMARY_FILE_SUFFIX = "txt";
    public static final String DEFAULT_DOWNLOAD_SUMMARY_FILE_DIR = "/var/tmp/";

    public void configure(PatchProProperties var1);

    public File downloadPatchDB(String var1) throws DownloadPatchDBException, NotSupportedException, PatchProException;

    public File downloadOldPatchDB(String var1) throws DownloadPatchDBException, NotSupportedException, PatchProException;

    public File downloadRealizationDetectors(String var1) throws DownloadRealizationException, NotSupportedException, PatchProException;

    public File downloadCategoryFile(String var1) throws DownloadRealizationException, NotSupportedException, PatchProException;

    public File downloadEntitlementFile(String var1) throws DownloadRealizationException, NotSupportedException, PatchProException;

    public File downloadCollectionFile(String var1) throws DownloadRealizationException, NotSupportedException, PatchProException;

    public File downloadDatabaseFile(String var1) throws DownloadRealizationException, NotSupportedException, PatchProException;

    public File getDetectorCacheFile(String var1) throws ConfigException;

    public File getEntitlementCacheFile(String var1) throws ConfigException;

    public File getReadMeCacheFile(String var1) throws ConfigException;

    public File getCollectionCacheFile(String var1) throws ConfigException;

    public File getCategoryCacheFile(String var1) throws ConfigException;

    public void downloadPatches(PatchList var1, Object var2) throws DownloadPatchException, NotSupportedException, PatchProException;

    public void downloadPatches(PatchList var1, Object var2, SessionData var3) throws DownloadPatchException, NotSupportedException, PatchProException;

    public File downloadReadMeFile(String var1) throws DownloadRealizationException, NotSupportedException, PatchProException;

    public void addDownloadPatchListener(DownloadPatchListener var1);

    public void removeDownloadPatchListener(DownloadPatchListener var1);

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList var1) throws PatchProException;

    public Object getDownloadDestination();

    public boolean isCertificateRevoked(String var1) throws NotSupportedException;

    public Percentage getProgress();
}

