/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.log;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.Log;
import com.sun.patchpro.log.LogEverything;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InstallationParameters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ApplicationLog
implements Log {
    private static ApplicationLog logInstance = null;
    private static Log delegate = null;
    private static boolean isSystemLogger = false;
    private static PatchProProperties properties;
    private static int logSize;
    private static int logLevel;
    private static boolean wrap;
    private static boolean writeToStdOut;
    private static File file;
    private static RandomAccessFile raFile;
    private static InstallationParameters instParms;
    private static final String DEFAULTLOGSIZE = "50000";
    private static final String TRACEOFF = "0";
    private static final String TRACEON = "1";
    private static final int LINES_PER_RECORD = 5;

    private ApplicationLog() {
    }

    public static synchronized ApplicationLog getInstance() {
        if (logInstance != null) {
            return logInstance;
        }
        logInstance = new ApplicationLog();
        String string = null;
        try {
            properties = PatchProProperties.getInstance();
            string = properties.getProperty("patchpro.log.file", "system");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string == null) {
            System.err.println("Error creating log: patchpro.log.file not set\nUsing default system logger");
            string = "system";
        }
        file = new File(string);
        if (!string.equals("system") && (file.getParentFile() == null || file.getPath().equals(""))) {
            System.out.println("WARNING: Specified log: [" + string + "] has no parent directory. Using system logger.");
            file = new File("system");
        }
        try {
            if (file.getPath().equals("system")) {
                ApplicationLog.createSystemLogger();
            } else {
                ApplicationLog.createFileLogger();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                ApplicationLog.createFileLogger();
                ((PatchProLog)((Object)delegate)).printStackTrace(delegate, 3, fileNotFoundException);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (IOException iOException) {
            try {
                ApplicationLog.createFailSafeLogger();
                ((PatchProLog)((Object)delegate)).printStackTrace(delegate, 3, iOException);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            try {
                ApplicationLog.createFailSafeLogger();
                ((PatchProLog)((Object)delegate)).printStackTrace(delegate, 3, exception);
            }
            catch (Exception exception2) {
                System.err.println("ERROR: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
        return logInstance;
    }

    private static synchronized void createSystemLogger() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = Host.getOSName() + "SystemLogger";
        String string2 = "com.sun.patchpro.log." + string;
        Class<?> clazz = Class.forName(string2);
        delegate = (Log)clazz.newInstance();
        isSystemLogger = true;
    }

    private static synchronized void createFileLogger() throws IOException, FileNotFoundException {
        properties = PatchProProperties.getInstance();
        File file = ApplicationLog.file.getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        ApplicationLog.file.createNewFile();
        if (ApplicationLog.file.canWrite()) {
            raFile = new RandomAccessFile(ApplicationLog.file, "rw");
            logSize = new Integer(properties.getProperty("patchpro.log.size", DEFAULTLOGSIZE));
            wrap = false;
            writeToStdOut = false;
        } else {
            System.out.println("WARNING: Cannot access patchpro log facilities. Messages shall be redirected to stdout.");
            writeToStdOut = true;
        }
        logLevel = new Integer(properties.getProperty("patchpro.log.level", TRACEOFF));
    }

    private static synchronized void createFailSafeLogger() {
        delegate = (Log)((Object)PatchProLog.getInstance());
        ((PatchProLog)((Object)delegate)).setLogger(new LogEverything(System.out));
    }

    private String[] breakUp(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n2 = stringTokenizer.countTokens();
        if (n <= 0 || n2 <= n) {
            return new String[]{string};
        }
        int n3 = n2 % n == 0 ? n2 / n : n2 / n + 1;
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            if (n2 >= n) {
                stringArray[i] = "";
                n4 = 0;
                while (n4 < n) {
                    int n5 = i;
                    stringArray[n5] = stringArray[n5] + (String)stringTokenizer.nextElement() + "\n";
                    ++n4;
                    --n2;
                }
                continue;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                int n6 = i;
                stringArray[n6] = stringArray[n6] + (String)stringTokenizer.nextElement() + "\n";
            }
        }
        return stringArray;
    }

    public synchronized void print(Object object, int n, String string) {
        block27: {
            String[] stringArray;
            block26: {
                stringArray = this.breakUp(string, 5);
                if (isSystemLogger) break block26;
                String string2 = "<unknown>";
                switch (n) {
                    case 0: {
                        string2 = "EMERGENCY";
                        break;
                    }
                    case 1: {
                        string2 = "ALERT";
                        break;
                    }
                    case 2: {
                        string2 = "CRITICAL";
                        break;
                    }
                    case 3: {
                        string2 = "ERROR";
                        break;
                    }
                    case 4: {
                        string2 = "WARNING";
                        break;
                    }
                    case 5: {
                        string2 = "NOTICE";
                        break;
                    }
                    case 6: {
                        string2 = "INFO";
                        break;
                    }
                    case 7: {
                        string2 = "DEBUG";
                    }
                }
                if (n > logLevel) break block27;
                if (writeToStdOut) {
                    String string3 = new Date().toString() + "(" + string2 + ")=> " + object.toString() + " <=" + string;
                    System.out.println(string3);
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4 = new Date().toString() + "(" + string2 + ")=> " + object.toString() + " <=" + stringArray[i];
                        try {
                            long l = raFile.length();
                            if (!wrap && l + (long)string4.length() > (long)logSize) {
                                wrap = true;
                            }
                            if (wrap) {
                                File file = null;
                                RandomAccessFile randomAccessFile = null;
                                String string5 = null;
                                String string6 = ApplicationLog.file.getAbsolutePath();
                                StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
                                int n2 = 0;
                                int n3 = 0;
                                try {
                                    while (stringTokenizer.hasMoreElements()) {
                                        stringTokenizer.nextElement();
                                        ++n2;
                                    }
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    System.err.println("ERROR: " + noSuchElementException.getMessage());
                                    noSuchElementException.printStackTrace();
                                }
                                raFile.seek(0L);
                                for (int j = 0; j < n2; ++j) {
                                    string5 = raFile.readLine();
                                    if (string5 != null) {
                                        n3 += string5.length() + 1;
                                    }
                                    raFile.seek(n3);
                                    byte[] byArray = new byte[(int)l - n3];
                                    file = new File(string6 + ".tmp");
                                    file.createNewFile();
                                    randomAccessFile = new RandomAccessFile(file, "rw");
                                    raFile.readFully(byArray);
                                    randomAccessFile.write(byArray, 0, byArray.length);
                                    randomAccessFile.writeBytes(string4);
                                    randomAccessFile.close();
                                    raFile.close();
                                    file.renameTo(new File(string6));
                                    ApplicationLog.file = new File(string6);
                                    if (!ApplicationLog.file.exists()) {
                                        ApplicationLog.file.createNewFile();
                                    }
                                    raFile = new RandomAccessFile(ApplicationLog.file, "rw");
                                    file = null;
                                    randomAccessFile = null;
                                }
                                continue;
                            }
                            raFile.seek(raFile.length());
                            raFile.writeBytes(string4);
                            continue;
                        }
                        catch (IOException iOException) {
                            try {
                                PatchProLog patchProLog = PatchProLog.getInstance();
                                patchProLog.setLogger(new LogEverything(System.out));
                                patchProLog.printStackTrace(this, 3, iOException);
                                continue;
                            }
                            catch (Exception exception) {
                                System.err.println("ERROR: " + exception.getMessage());
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                break block27;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                delegate.print(object, n, stringArray[i]);
            }
        }
    }

    static {
        instParms = null;
    }
}

