/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.interpreter;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.host.UnknownRealizationException;
import com.sun.patchpro.interpreter.ASTAWord;
import com.sun.patchpro.interpreter.ASTAndOr;
import com.sun.patchpro.interpreter.ASTCaseItem;
import com.sun.patchpro.interpreter.ASTCompoundList;
import com.sun.patchpro.interpreter.ASTEcho;
import com.sun.patchpro.interpreter.ASTElifBlock;
import com.sun.patchpro.interpreter.ASTElseBlock;
import com.sun.patchpro.interpreter.ASTExit;
import com.sun.patchpro.interpreter.ASTFalse;
import com.sun.patchpro.interpreter.ASTGetPackageVersion;
import com.sun.patchpro.interpreter.ASTGetPatchVersion;
import com.sun.patchpro.interpreter.ASTGetRealizationVersion;
import com.sun.patchpro.interpreter.ASTHasExactPatch;
import com.sun.patchpro.interpreter.ASTHasExactRealization;
import com.sun.patchpro.interpreter.ASTHasPackage;
import com.sun.patchpro.interpreter.ASTHasPatch;
import com.sun.patchpro.interpreter.ASTHasPatchBaseCode;
import com.sun.patchpro.interpreter.ASTHasRealization;
import com.sun.patchpro.interpreter.ASTHasRealizationName;
import com.sun.patchpro.interpreter.ASTIfClause;
import com.sun.patchpro.interpreter.ASTIsArchitecture;
import com.sun.patchpro.interpreter.ASTIsOsName;
import com.sun.patchpro.interpreter.ASTIsOsVersion;
import com.sun.patchpro.interpreter.ASTIsPlatform;
import com.sun.patchpro.interpreter.ASTNot;
import com.sun.patchpro.interpreter.ASTOsName;
import com.sun.patchpro.interpreter.ASTOsVersion;
import com.sun.patchpro.interpreter.ASTPattern;
import com.sun.patchpro.interpreter.ASTPlatform;
import com.sun.patchpro.interpreter.ASTStart;
import com.sun.patchpro.interpreter.ASTSwitch;
import com.sun.patchpro.interpreter.ASTTrue;
import com.sun.patchpro.interpreter.EnvState;
import com.sun.patchpro.interpreter.ExitCondition;
import com.sun.patchpro.interpreter.InterpretError;
import com.sun.patchpro.interpreter.Node;
import com.sun.patchpro.interpreter.PatchListExpressionTreeVisitor;
import com.sun.patchpro.interpreter.SimpleNode;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.patch.PatchID;

class InterpretPatchListExpression
implements PatchListExpressionTreeVisitor {
    private static int trueExit = 0;
    private PatchProLog log = PatchProLog.getInstance();

    public Object visit(SimpleNode simpleNode, Object object) {
        this.log.println(this, 6, "Interpreter: Visit called with SimpleNode. (not a failure, but not expected)");
        return simpleNode.childrenAccept(this, object);
    }

    public Object visit(ASTCaseItem aSTCaseItem, Object object) {
        this.log.println(this, 6, "Interpreter: Visit called with CaseItem.(Not Yet Implemented) (not a failure, but not expected)");
        return aSTCaseItem.childrenAccept(this, object);
    }

    public Object visit(ASTSwitch aSTSwitch, Object object) {
        this.log.println(this, 6, "Interpreter: Visit called with Switch.(Not Yet Implemented) (not a failure, but not expected)");
        return aSTSwitch.childrenAccept(this, object);
    }

    public Object visit(ASTIfClause aSTIfClause, Object object) {
        int n = aSTIfClause.jjtGetNumChildren();
        try {
            EnvState envState = new EnvState(((EnvState)object).getHost());
            ASTCompoundList aSTCompoundList = (ASTCompoundList)aSTIfClause.jjtGetChild(0);
            envState = (EnvState)aSTCompoundList.jjtAccept(this, envState);
            if (envState.getExitCode() == trueExit) {
                return aSTIfClause.jjtGetChild(1).jjtAccept(this, object);
            }
            if (n < 3) {
                ((EnvState)object).exitCode(trueExit);
                return object;
            }
            if (n == 3) {
                aSTIfClause.jjtGetChild(2).jjtAccept(this, object);
                return object;
            }
            for (int i = 2; i < n; ++i) {
                envState = (EnvState)aSTIfClause.jjtGetChild(i).jjtAccept(this, object);
                if (envState.getExitCode() != trueExit) continue;
                return object;
            }
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in IfClause: " + exception.getMessage());
        }
        return object;
    }

    public Object visit(ASTElifBlock aSTElifBlock, Object object) {
        int n = aSTElifBlock.jjtGetNumChildren();
        EnvState envState = null;
        try {
            envState = new EnvState(((EnvState)object).getHost());
            aSTElifBlock.jjtGetChild(0).jjtAccept(this, envState);
            if (envState.getExitCode() == trueExit && n > 1) {
                aSTElifBlock.jjtGetChild(1).jjtAccept(this, object);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in ElifBlock: " + exception.getMessage());
        }
    }

    public Object visit(ASTElseBlock aSTElseBlock, Object object) {
        try {
            aSTElseBlock.jjtGetChild(0).jjtAccept(this, object);
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in ElseBlock: " + exception.getMessage());
        }
        return object;
    }

    public Object visit(ASTAndOr aSTAndOr, Object object) {
        boolean bl = false;
        int n = 0;
        int n2 = aSTAndOr.jjtGetNumChildren();
        try {
            Node node = aSTAndOr.jjtGetChild(n);
            if (node instanceof ASTNot) {
                --n2;
                bl = true;
            }
            int n3 = ++n;
            ++n;
            object = aSTAndOr.jjtGetChild(n3).jjtAccept(this, object);
            if (n2 > 1) {
                if (aSTAndOr.isAnd() && ((EnvState)object).getExitCode() == trueExit) {
                    object = aSTAndOr.jjtGetChild(n++).jjtAccept(this, object);
                } else if (aSTAndOr.isOr() && ((EnvState)object).getExitCode() != trueExit) {
                    object = aSTAndOr.jjtGetChild(n++).jjtAccept(this, object);
                }
            }
            if (bl) {
                this.bang(object);
            }
            return object;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in AndOr: " + exception.getMessage());
        }
    }

    public Object visit(ASTEcho aSTEcho, Object object) {
        try {
            EnvState envState = (EnvState)object;
            int n = aSTEcho.jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                try {
                    ASTAWord aSTAWord = (ASTAWord)aSTEcho.jjtGetChild(i);
                    envState.echo(aSTAWord.getName());
                    envState.echo(" ");
                    envState.exitCode(trueExit);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new InterpretError("Internal Echo command failure: " + classCastException.getMessage());
                }
            }
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in Echo command: " + exception.getMessage());
        }
        return object;
    }

    public Object visit(ASTGetPackageVersion aSTGetPackageVersion, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTGetPackageVersion.jjtGetChild(0)).getName();
            ReadOnlyHost readOnlyHost = envState.getHost();
            String string2 = readOnlyHost.getSoftwarePackageRev(string);
            if (string2 != null) {
                envState.echo(string2);
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in GetPackageVersion: " + exception.getMessage());
        }
    }

    public Object visit(ASTGetPatchVersion aSTGetPatchVersion, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTGetPatchVersion.jjtGetChild(0)).getName();
            ReadOnlyHost readOnlyHost = envState.getHost();
            String string2 = readOnlyHost.getPatchRev(string);
            if (string2 != null) {
                envState.echo(string2);
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in GetPatchVersion: " + exception.getMessage());
        }
    }

    public Object visit(ASTGetRealizationVersion aSTGetRealizationVersion, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTGetRealizationVersion.jjtGetChild(0)).getName();
            ReadOnlyHost readOnlyHost = envState.getHost();
            Realization realization = readOnlyHost.getRealizationByName(string);
            if (realization != null) {
                envState.echo(realization.getVersion().getVersion());
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in GetRealizationVersion: " + exception.getMessage());
        }
    }

    public Object visit(ASTOsName aSTOsName, Object object) {
        try {
            EnvState envState = (EnvState)object;
            envState.echo(envState.getHost().getOperatingSystem());
            envState.exitCode(trueExit);
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in OsName: " + exception.getMessage());
        }
    }

    public Object visit(ASTOsVersion aSTOsVersion, Object object) {
        try {
            EnvState envState = (EnvState)object;
            envState.echo(envState.getHost().getOSRelease());
            envState.exitCode(trueExit);
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in OsVersion: " + exception.getMessage());
        }
    }

    public Object visit(ASTPlatform aSTPlatform, Object object) {
        try {
            EnvState envState = (EnvState)object;
            envState.echo(envState.getHost().getPlatform());
            envState.exitCode(trueExit);
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in Platform: " + exception.getMessage());
        }
    }

    public Object visit(ASTHasPackage aSTHasPackage, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTHasPackage.jjtGetChild(0)).getName();
            String string2 = ((ASTAWord)aSTHasPackage.jjtGetChild(1)).getName();
            ReadOnlyHost readOnlyHost = envState.getHost();
            if (readOnlyHost.hasExactSoftwarePackage(new SoftwarePackage(string, string2))) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasPackage: " + exception.getMessage());
        }
    }

    public Object visit(ASTHasPatch aSTHasPatch, Object object) {
        try {
            EnvState envState = (EnvState)object;
            PatchID patchID = new PatchID(((ASTAWord)aSTHasPatch.jjtGetChild(0)).getName());
            ReadOnlyHost readOnlyHost = envState.getHost();
            String string = patchID.getRevision();
            String string2 = readOnlyHost.getPatchRev(patchID.getBasecode());
            if (string2 != null) {
                if (Integer.parseInt(string2) >= Integer.parseInt(string)) {
                    envState.exitCode(trueExit);
                } else {
                    envState.exitCode(trueExit + 1);
                }
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasPatch: " + exception.getMessage());
        }
    }

    public Object visit(ASTHasExactPatch aSTHasExactPatch, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTHasExactPatch.jjtGetChild(0)).getName();
            ReadOnlyHost readOnlyHost = envState.getHost();
            if (readOnlyHost.hasExactPatchID(new PatchID(string))) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasExactPatch: " + exception.getMessage());
        }
    }

    public Object visit(ASTHasPatchBaseCode aSTHasPatchBaseCode, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTHasPatchBaseCode.jjtGetChild(0)).getName();
            ReadOnlyHost readOnlyHost = envState.getHost();
            if (readOnlyHost.hasPatchID(string)) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasPatchBaseCode: " + exception.getMessage());
        }
    }

    public Object visit(ASTIsOsName aSTIsOsName, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = envState.getHost().getOperatingSystem();
            if (string == null) {
                throw new InterpretError("Host does not have OS name set.");
            }
            String string2 = ((ASTAWord)aSTIsOsName.jjtGetChild(0)).getName();
            if (string.toLowerCase().compareTo(string2.toLowerCase()) == 0) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in IsOsName: " + exception.getMessage());
        }
    }

    public Object visit(ASTIsOsVersion aSTIsOsVersion, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = envState.getHost().getOSRelease();
            if (string == null) {
                throw new InterpretError("Host does not have OS version set.");
            }
            String string2 = ((ASTAWord)aSTIsOsVersion.jjtGetChild(0)).getName();
            if (string.toLowerCase().compareTo(string2.toLowerCase()) == 0) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in IsOsVersion: " + exception.getMessage());
        }
    }

    public Object visit(ASTIsPlatform aSTIsPlatform, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = envState.getHost().getPlatform();
            if (string == null) {
                throw new InterpretError("Host does not have platform set.");
            }
            String string2 = ((ASTAWord)aSTIsPlatform.jjtGetChild(0)).getName();
            if (string.toLowerCase().compareTo(string2.toLowerCase()) == 0) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in IsPlatform: " + exception.getMessage());
        }
    }

    public Object visit(ASTIsArchitecture aSTIsArchitecture, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = envState.getHost().getArchitecture();
            if (string == null) {
                throw new InterpretError("Host does not have architecture set.");
            }
            String string2 = ((ASTAWord)aSTIsArchitecture.jjtGetChild(0)).getName();
            if (string.toLowerCase().compareTo(string2.toLowerCase()) == 0) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in IsArchitecture: " + exception.getMessage());
        }
    }

    public Object visit(ASTHasRealization aSTHasRealization, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTHasRealization.jjtGetChild(0)).getName();
            Realization realization = new Realization(string);
            try {
                if (envState.getHost().hasRealization(realization)) {
                    envState.exitCode(trueExit);
                } else {
                    envState.exitCode(trueExit + 1);
                }
            }
            catch (UnknownRealizationException unknownRealizationException) {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasRealization: " + exception.getMessage());
        }
    }

    public Object visit(ASTHasExactRealization aSTHasExactRealization, Object object) {
        EnvState envState = (EnvState)object;
        try {
            String string = ((ASTAWord)aSTHasExactRealization.jjtGetChild(0)).getName();
            Realization realization = new Realization(string);
            if (envState.getHost().hasExactRealization(realization)) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
        }
        catch (UnknownRealizationException unknownRealizationException) {
            envState.exitCode(trueExit + 1);
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasExactRealization: " + exception.getMessage());
        }
        return envState;
    }

    public Object visit(ASTHasRealizationName aSTHasRealizationName, Object object) {
        try {
            EnvState envState = (EnvState)object;
            String string = ((ASTAWord)aSTHasRealizationName.jjtGetChild(0)).getName();
            if (envState.getHost().getRealizationByName(string) != null) {
                envState.exitCode(trueExit);
            } else {
                envState.exitCode(trueExit + 1);
            }
            return envState;
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in HasRealizationName: " + exception.getMessage());
        }
    }

    public Object visit(ASTExit aSTExit, Object object) {
        int n = 0;
        if (aSTExit.jjtGetNumChildren() != 0) {
            try {
                ASTAWord aSTAWord = (ASTAWord)aSTExit.jjtGetChild(0);
                n = Integer.parseInt(aSTAWord.getName());
            }
            catch (Exception exception) {
                n = 1;
            }
        }
        throw new ExitCondition(n);
    }

    public Object visit(ASTTrue aSTTrue, Object object) {
        try {
            EnvState envState = (EnvState)object;
            envState.exitCode(trueExit);
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in True: " + exception.getMessage());
        }
        return object;
    }

    public Object visit(ASTFalse aSTFalse, Object object) {
        try {
            EnvState envState = (EnvState)object;
            envState.exitCode(trueExit + 1);
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in False: " + exception.getMessage());
        }
        return object;
    }

    public Object visit(ASTStart aSTStart, Object object) {
        return aSTStart.childrenAccept(this, object);
    }

    public Object visit(ASTCompoundList aSTCompoundList, Object object) {
        return aSTCompoundList.childrenAccept(this, object);
    }

    public Object visit(ASTPattern aSTPattern, Object object) {
        this.log.println(this, 6, "Interpreter: Visit called with Pattern. (not a failure, but not expected)");
        return object;
    }

    public Object visit(ASTAWord aSTAWord, Object object) {
        this.log.println(this, 6, "Interpreter: Visit called with AWord. (not a failure, but not expected)");
        return object;
    }

    public Object visit(ASTNot aSTNot, Object object) {
        this.log.println(this, 6, "Interpreter: Visit called with Not. (not a failure, but not expected)");
        return object;
    }

    private void bang(Object object) {
        try {
            EnvState envState = (EnvState)object;
            int n = envState.getExitCode();
            if (n != 0) {
                envState.exitCode(0);
            } else {
                envState.exitCode(1);
            }
        }
        catch (Exception exception) {
            throw new InterpretError("Failure in '!' operator: " + exception.getMessage());
        }
    }
}

