/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.log.PatchProLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class ConfigurationReader {
    private File configFile;
    private PatchProLog log = PatchProLog.getInstance();

    public ConfigurationReader(String string) {
        this.configFile = new File(string);
    }

    public void readConfig(Host host) {
        if (this.configFile.exists() && this.configFile.canRead()) {
            try {
                boolean bl = false;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configFile));
                String string = bufferedReader.readLine();
                while (string != null && (string.indexOf("#") == 0 || string.trim().length() == 0)) {
                    if (string.indexOf("VERSION") != -1 && string.indexOf("1.0") != -1) {
                        bl = true;
                    }
                    string = bufferedReader.readLine();
                }
                while (string != null && bl) {
                    if (string.trim().length() != 0) {
                        Realization realization = new Realization(string);
                        host.addRealization(realization, true);
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.println(this, 4, "File not found.");
            }
            catch (IOException iOException) {
                this.log.println(this, 4, "Reading file exception.");
            }
            catch (NoSuchRealizationException noSuchRealizationException) {
                this.log.println(this, 4, "Not a valid Realization.");
            }
        }
    }
}

