/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.ApplicationSession;
import com.sun.web.core.Container;
import com.sun.web.core.DefaultLogModule;
import com.sun.web.core.DefaultSecurityModule;
import com.sun.web.core.LogModule;
import com.sun.web.core.LookupResult;
import com.sun.web.core.Request;
import com.sun.web.core.Response;
import com.sun.web.core.SecurityModule;
import com.sun.web.core.Server;
import com.sun.web.core.ServerSession;
import com.sun.web.core.ServerSessionManager;
import com.sun.web.core.ServletContextFacade;
import com.sun.web.util.MimeMap;
import com.sun.web.util.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Context {
    private StringManager sm = StringManager.getManager("com.sun.web.core");
    private boolean initialized = false;
    private Server server;
    private String name;
    private Container container = new Container(this);
    private ServerSessionManager sessionManager = ServerSessionManager.getManager();
    private ServletContextFacade contextFacade;
    private SecurityModule secMod;
    private LogModule logMod;
    private Hashtable attributes = new Hashtable();
    private MimeMap mimeTypes = new MimeMap();
    private Vector welcomeFiles = new Vector();
    private URL docBase;
    private String path = "";
    private File tempDir;
    private String engineHeader = "Tomcat/2.1 (Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "; java.vendor=" + System.getProperty("java.vendor") + ")";

    public Context(Server server, String string) {
        this.server = server;
        this.name = string;
        this.contextFacade = new ServletContextFacade(server, this);
        this.secMod = new DefaultSecurityModule(this);
        this.logMod = new DefaultLogModule();
        this.mimeTypes.addContentType("txt", "text/plain");
        this.mimeTypes.addContentType("html", "text/html");
        this.mimeTypes.addContentType("htm", "text/html");
        this.mimeTypes.addContentType("gif", "image/gif");
        this.mimeTypes.addContentType("jpeg", "image/jpeg");
        this.mimeTypes.addContentType("jpe", "image/jpeg");
    }

    public String getName() {
        return this.name;
    }

    public String getEngineHeader() {
        return this.engineHeader;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setTempDir(File file) {
        String string = this.toString();
        if (!(file = new File(file, string = string.substring(string.indexOf("@") + 1, string.length()))).exists()) {
            file.mkdirs();
        } else {
            this.clearDir(file);
        }
        this.tempDir = file;
    }

    private void clearDir(File file) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.clearDir(file2);
            }
            file2.delete();
        }
    }

    public synchronized void init() {
        if (this.initialized) {
            String string = this.sm.getString("context.init.alreadyinit");
            throw new IllegalStateException(string);
        }
        this.initialized = true;
        if (this.docBase == null) {
            // empty if block
        }
        if (this.tempDir != null) {
            this.setAttribute("sun.servlet.tmpdir", this.tempDir);
        }
        this.container.addServlet("default", "com.sun.web.core.DefaultServlet");
        String[] stringArray = new String[]{"webapp.properties", "mime.properties", "servlets.properties", "mappings.properties"};
        URL uRL = null;
        Properties properties = null;
        boolean bl = false;
        Object var5_6 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            bl = false;
            String string = null;
            try {
                uRL = new URL(this.docBase, "WEB-INF/" + stringArray[i]);
                properties = new Properties();
                properties.load(uRL.openStream());
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    string = this.sm.getString("context.init.propfile.url.error", stringArray[i], this.docBase);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            catch (IOException iOException) {
                try {
                    string = this.sm.getString("context.init.propfile.file.error", stringArray[i], this.docBase);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if ((bl || !bl) && stringArray[i].equals("webapp.properties")) {
                this.processWebAppProps(properties);
            }
            if (bl && stringArray[i].equals("mime.properties")) {
                this.processMIMEProps(properties);
            }
            if (bl && stringArray[i].equals("servlets.properties")) {
                this.processServletsProps(properties);
            }
            if (!bl || !stringArray[i].equals("mappings.properties")) continue;
            this.processMappingsProps(properties);
        }
        try {
            URL uRL2 = new URL(this.docBase, "WEB-INF/servlets");
            this.container.setServletBase(uRL2);
        }
        catch (Exception exception) {
            System.out.println("ARGH: " + exception);
        }
    }

    public void shutdown() {
        this.container.shutdown();
        this.sessionManager.removeApplicationSessions(this);
        this.clearDir(this.tempDir);
        this.tempDir.delete();
        System.out.println("Context: " + this + " down");
    }

    public Enumeration getWelcomeFiles() {
        return this.welcomeFiles.elements();
    }

    public SecurityModule getSecurityModule() {
        return this.secMod;
    }

    public void setSecurityModule(SecurityModule securityModule) {
        this.secMod = securityModule;
    }

    public LogModule getLogModule() {
        return this.logMod;
    }

    public void setLogModule(LogModule logModule) {
        this.logMod = logModule;
    }

    public Object getAttribute(String string) {
        Object v = this.attributes.get(string);
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setDocumentBase(URL uRL) {
        String string = uRL.getFile();
        if (!string.endsWith("/")) {
            try {
                uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string + "/");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("SHOULD NEVER HAPPEN: " + malformedURLException);
            }
        }
        this.docBase = uRL;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public MimeMap getMimeMap() {
        return this.mimeTypes;
    }

    public Container getContainer() {
        return this.container;
    }

    ServletContextFacade getFacade() {
        return this.contextFacade;
    }

    public void handleRequest(Request request, Response response) throws IOException {
        Object object;
        response.setHeader("Servlet-Engine", this.engineHeader);
        request.setContext(this);
        request.setResponse(response);
        ServerSession serverSession = this.sessionManager.getServerSession(request, response, false);
        if (serverSession != null) {
            serverSession.accessed();
            object = serverSession.getApplicationSession(this, false);
            if (object != null) {
                ((ApplicationSession)object).accessed();
            }
        }
        request.setServerSession(serverSession);
        if (this.secMod.authenticateRequest(request.getFacade(), response.getFacade()) && this.secMod.authorizeRequest(request.getFacade(), response.getFacade())) {
            object = this.container.lookupServlet(request.getLookupPath());
            request.setPathInfo(((LookupResult)object).getPathInfo());
            request.setServletPath(((LookupResult)object).getServletPath());
            ((LookupResult)object).getWrapper().handleRequest(request.getFacade(), response.getFacade());
        }
        this.logMod.logRequest(request.getFacade(), response.getFacade());
    }

    private void processWebAppProps(Properties properties) {
        String string = properties.getProperty("invoker");
        Vector<String> vector = new Vector<String>();
        vector.addElement("true");
        vector.addElement("yes");
        vector.addElement("on");
        if (string == null || string != null && vector.contains(string.toLowerCase())) {
            this.container.addServlet("invoker", "com.sun.web.core.InvokerServlet");
            this.container.addMapping("invoker", "/servlet");
        } else {
            this.container.addServlet("invoker", "com.sun.web.core.NoInvokerServlet");
            this.container.addMapping("invoker", "/servlet");
        }
        string = properties.getProperty("welcomefiles");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.welcomeFiles.addElement(stringTokenizer.nextToken().trim());
            }
        }
    }

    private void processMIMEProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string).trim();
            this.mimeTypes.addContentType(string, string2);
        }
    }

    private void processServletsProps(Properties properties) {
        String string;
        String string2;
        String string3;
        Vector<String> vector = new Vector<String>();
        Enumeration<Object> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            try {
                string2 = string3.substring(0, string3.indexOf("."));
                if (vector.contains(string2)) continue;
                vector.addElement(string2);
            }
            catch (Exception exception) {
                string = this.sm.getString("context.init.propfile.servlet.format", string3);
                System.out.println(string);
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            string2 = properties.getProperty(string3 + ".code");
            string = properties.getProperty(string3 + ".initparams");
            if (string2 == null) {
                throw new IllegalArgumentException("no class for servlet name " + string3);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    int n = string4.indexOf("=");
                    if (n <= 0) continue;
                    String string5 = string4.substring(0, n).trim();
                    String string6 = string4.substring(n + 1, string4.length()).trim();
                    hashtable.put(string5, string6);
                }
            }
            this.container.addServlet(string3, string2);
            this.container.setServletInitParams(string3, hashtable);
        }
    }

    private void processMappingsProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string).trim();
            this.container.addMapping(string2, string);
        }
    }
}

