/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;

public class SectionedProperties
extends TreeMap {
    static final long serialVersionUID = -200555434270383795L;
    protected static final String specialSaveChars = "=: \t\r\n\f#!";
    protected static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties getBlock(String name) {
        Object o = this.get(name);
        if (o instanceof Properties) {
            return (Properties)o;
        }
        return null;
    }

    public Properties setBlock(String name, Properties block) {
        Properties o = this.put(name, block);
        if (o instanceof Properties) {
            return o;
        }
        return null;
    }

    public String getProperty(String block, String name) {
        Properties p = this.getBlock(block);
        if (p != null) {
            return p.getProperty(name);
        }
        return null;
    }

    public Object setProperty(String block, String name, String value) {
        Properties p = this.getBlock(block);
        if (p != null) {
            return p.setProperty(name, value);
        }
        p = new Properties();
        p.setProperty(name, value);
        return this.put(block, p);
    }

    public Iterator blockNames() {
        return this.keySet().iterator();
    }

    public Iterator propertyNames(String block) {
        Properties p = this.getBlock(block);
        if (p != null) {
            return p.keySet().iterator();
        }
        return null;
    }

    public void load(InputStream in) throws IOException {
        byte[] buf = new byte[in.available()];
        in.read(buf);
        Object[] o = null;
        int epos = 0;
        int spos = 0;
        while ((o = this.findNextBlock(buf, epos)) != null) {
            String name = (String)o[0];
            spos = (Integer)o[1];
            epos = (Integer)o[2];
            Properties p = this.getBlock(name);
            if (p == null) {
                p = new Properties();
            }
            p.load(new ByteArrayInputStream(buf, spos, epos - spos));
            this.setBlock(name, p);
        }
    }

    protected Object[] findNextBlock(byte[] buf, int startPos) {
        int nameStart = this.findNextBlockTagOffset(buf, startPos);
        if (nameStart == -1) {
            return null;
        }
        int i = ++nameStart;
        while (buf[i] != 93) {
            ++i;
        }
        int bufEnd = this.findNextBlockTagOffset(buf, i);
        if (bufEnd == -1) {
            bufEnd = buf.length;
        }
        return new Object[]{new String(buf, nameStart, i - nameStart), new Integer(i + 1), new Integer(bufEnd)};
    }

    protected int findNextBlockTagOffset(byte[] buf, int startPos) {
        try {
            int i = startPos;
            while (i < buf.length) {
                if (buf[i] != 91) {
                    while (buf[i] != 10) {
                        if (buf[i] == 35) {
                            if (i > 0 && buf[i - 1] == 32) {
                                buf[i - 1] = 10;
                            }
                            while (buf[i] != 10) {
                                buf[i] = 10;
                                ++i;
                            }
                            continue;
                        }
                        ++i;
                    }
                    ++i;
                }
                while (buf[i] == 32 || buf[i] == 9) {
                    ++i;
                }
                if (buf[i] != 91) continue;
                int ret = i++;
                while (buf[i] != 93 && buf[i] != 10) {
                    ++i;
                }
                if (buf[i] != 93) continue;
                return ret;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    public void store(OutputStream out, String header) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            SectionedProperties.writeln(bw, "# " + header);
        }
        SectionedProperties.writeln(bw, "# " + new Date().toString());
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            String block = (String)it.next();
            Properties p = this.getBlock(block);
            if (p != null) {
                SectionedProperties.writeBlock(bw, block, p);
            }
            if (!it.hasNext()) continue;
            SectionedProperties.writeln(bw, "");
        }
        bw.flush();
    }

    protected static void writeBlock(BufferedWriter bw, String block, Properties p) throws IOException {
        SectionedProperties.writeln(bw, '[' + block + ']');
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)p.get(key);
            key = SectionedProperties.saveConvert(key);
            val = SectionedProperties.saveConvert(val);
            SectionedProperties.writeln(bw, key + "=" + val);
        }
    }

    protected static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    protected static String saveConvert(String s) {
        int len = s.length();
        StringBuffer ret = new StringBuffer(2 * len);
        int i = 0;
        block7: while (i < len) {
            char c = s.charAt(i++);
            switch (c) {
                case '\\': {
                    ret.append("\\\\");
                    continue block7;
                }
                case '\t': {
                    ret.append("\\t");
                    continue block7;
                }
                case '\n': {
                    ret.append("\\n");
                    continue block7;
                }
                case '\r': {
                    ret.append("\\r");
                    continue block7;
                }
                case '\f': {
                    ret.append("\\f");
                    continue block7;
                }
            }
            if (c < '\u0014' || c > '\u007f') {
                ret.append("\\u");
                ret.append(SectionedProperties.toHex(c >> 12 & 0xF));
                ret.append(SectionedProperties.toHex(c >> 8 & 0xF));
                ret.append(SectionedProperties.toHex(c >> 4 & 0xF));
                ret.append(SectionedProperties.toHex(c >> 0 & 0xF));
                continue;
            }
            if (specialSaveChars.indexOf(c) != -1) {
                ret.append('\\');
            }
            ret.append(c);
        }
        return ret.toString();
    }

    protected static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static void main(String[] args) {
        SectionedProperties bp = new SectionedProperties();
        bp.setProperty("block1", "val1", "key1\u00f6newed");
        bp.setProperty("block1", "val2", "key2");
        bp.setProperty("block2", "val3", "key3");
        bp.setProperty("block2", "val4", "key4");
        try {
            System.out.println("================================");
            bp.store(System.out, "Set in the program");
            System.out.println("================================");
            bp.clear();
            bp.store(System.out, "Cleared");
            System.out.println("================================");
            bp.load(new FileInputStream("props"));
            bp.store(System.out, "Read in from props");
            System.out.println("================================");
            System.out.println(bp.getProperty("block1", "val3"));
            System.out.println("================================");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

