/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.VIdentity;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class RoleChooser
extends VOptionPane
implements Serializable {
    public static final int OK_OPTION = 0;
    public static final int SKIP_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int PREF_WIDTH = 500;
    public static final int PREF_HEIGHT = 300;
    protected JPasswordField passField = null;
    protected JLabel serverLabel = null;
    protected JLabel userLabel = null;
    protected JLabel roleLabel = null;
    protected JLabel passLabel = null;
    protected JTextField serverField = null;
    protected JTextField nameField = null;
    protected JComboBox roleField = null;
    protected JButton okButton = null;
    protected JButton ignoreButton = null;
    protected JButton cancelButton = null;
    protected JDialog dialog = null;
    protected int returnValue = 2;
    protected transient String normalHelp = null;
    protected transient String failedHelp = null;
    protected transient String baseTitle = null;
    protected transient String normalTitle = null;
    protected transient String failedTitle = null;
    protected transient String noRole = null;
    protected transient Dimension prefSize = new Dimension(500, 300);
    protected VIdentity[] roleSet = null;

    public RoleChooser() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(30, 15, 15, 15));
        this.toggleContentTitle(false);
        this.serverLabel = new JLabel();
        this.userLabel = new JLabel();
        this.roleLabel = new JLabel();
        this.passLabel = new JLabel();
        this.serverField = new JTextField(15){

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.serverField.setEditable(false);
        this.serverLabel.setLabelFor(this.serverField);
        this.nameField = new JTextField(15){

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.nameField.setEditable(false);
        this.userLabel.setLabelFor(this.nameField);
        try {
            this.nameField.setText(System.getProperty("user.name"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.roleField = new JComboBox(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.roleField.setEditable(false);
        this.roleLabel.setLabelFor(this.roleField);
        this.passField = new JPasswordField(15){

            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getMinimumSize().height);
            }

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
            }
        };
        this.passField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleChooser.this.returnValue = 0;
                if (RoleChooser.this.dialog != null) {
                    RoleChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.passLabel.setLabelFor(this.passField);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleChooser.this.returnValue = 0;
                if (RoleChooser.this.dialog != null) {
                    RoleChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.ignoreButton = new JButton();
        this.ignoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleChooser.this.returnValue = 1;
                if (RoleChooser.this.dialog != null) {
                    RoleChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoleChooser.this.returnValue = 2;
                if (RoleChooser.this.dialog != null) {
                    RoleChooser.this.dialog.setVisible(false);
                }
            }
        });
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(this.serverLabel);
        labelPanel.add(Box.createVerticalStrut(12));
        labelPanel.add(this.userLabel);
        labelPanel.add(Box.createVerticalStrut(36));
        labelPanel.add(this.roleLabel);
        labelPanel.add(Box.createVerticalStrut(20));
        labelPanel.add(this.passLabel);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        fieldPanel.add(this.serverField);
        fieldPanel.add(Box.createVerticalStrut(10));
        fieldPanel.add(this.nameField);
        fieldPanel.add(Box.createVerticalStrut(30));
        fieldPanel.add(this.roleField);
        fieldPanel.add(Box.createVerticalStrut(10));
        fieldPanel.add(this.passField);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(labelPanel);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(fieldPanel);
        JPanel bodyPanel = new JPanel();
        bodyPanel.setLayout(new BoxLayout(bodyPanel, 1));
        bodyPanel.add(topPanel);
        bodyPanel.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)bodyPanel, "North");
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.ignoreButton);
        this.getButtonPane().add(this.cancelButton);
        this.passField.requestDefaultFocus();
        this.init();
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    public String getRoleName() {
        try {
            int selIndex = this.roleField.getSelectedIndex();
            if (selIndex < 0 || selIndex > this.roleSet.length) {
                return null;
            }
            return this.roleSet[selIndex].getName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getRolePassword() {
        return new String(this.passField.getPassword());
    }

    public int showRoleDialog(Component parent, String serverName, String userName, VIdentity[] roleNames, boolean previouslyFailed) {
        this.returnValue = 2;
        this.roleSet = roleNames;
        try {
            Frame frame;
            if (serverName != null) {
                this.serverField.setText(serverName);
            }
            if (userName != null) {
                this.nameField.setText(userName);
            }
            if (this.roleField.getItemCount() > 0) {
                this.roleField.removeAllItems();
            }
            if (roleNames != null && roleNames.length > 0) {
                for (int x = 0; x < roleNames.length; ++x) {
                    String d = roleNames[x].getName();
                    this.roleField.addItem(d);
                }
            } else {
                this.roleField.setEnabled(false);
            }
            this.passField.setText("");
            this.passField.setCaretPosition(0);
            Frame frame2 = frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
            if (previouslyFailed) {
                this.dialog = new VDialog(frame, null, true);
                this.setHelpHTML(this.failedHelp);
                this.setTitle(this.baseTitle + " " + this.failedTitle);
            } else {
                this.dialog = new VDialog(frame, null, true);
                this.setHelpHTML(this.normalHelp);
                this.setTitle(this.baseTitle + " " + this.normalTitle);
            }
            super.setContainer((Component)this.dialog);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(parent);
            this.roleField.requestFocus();
            this.dialog.show();
        }
        catch (Throwable t) {
            // empty catch block
        }
        return this.returnValue;
    }

    protected void installStrings() {
        this.serverLabel.setText(ImplResourceManager.getString("SMC Server:"));
        this.serverLabel.setDisplayedMnemonic(ImplResourceManager.getString("SMC Server:_mnemonic").charAt(0));
        this.serverLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("SMC Server:_access_name"));
        this.userLabel.setText(ImplResourceManager.getString("User Name:"));
        this.userLabel.setDisplayedMnemonic(ImplResourceManager.getString("User Name:_mnemonic").charAt(0));
        this.userLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("User Name:_accessible_name"));
        this.roleLabel.setText(ImplResourceManager.getString("Role Name:"));
        this.roleLabel.setDisplayedMnemonic(ImplResourceManager.getString("Role Name:_mnemonic").charAt(0));
        this.roleLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Role Name:_access_name"));
        this.passLabel.setText(ImplResourceManager.getString("Role Password:"));
        this.passLabel.setDisplayedMnemonic(ImplResourceManager.getString("Role Password:_mnemonic").charAt(0));
        this.passLabel.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Role Password:_access_name"));
        this.cancelButton.setText(ResourceManager.getString((String)"CANCEL_BUTTON"));
        this.cancelButton.setMnemonic(ResourceManager.getString((String)"CANCEL_BUTTON_mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.okButton.setText(ImplResourceManager.getString("Login with Role"));
        this.okButton.setMnemonic(ImplResourceManager.getString("Login with Role_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Login with Role_BUTTON_access_name"));
        this.ignoreButton.setText(ImplResourceManager.getString("Login without Role"));
        this.ignoreButton.setMnemonic(ImplResourceManager.getString("Login without Role_mnemonic").charAt(0));
        this.ignoreButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("Login without Role_BUTTON_access_name"));
        this.normalHelp = ImplResourceManager.getString("RoleChooserHelp");
        this.normalHelp = ContextHelpLoader.getContextHelp((String)this.normalHelp, null);
        this.failedHelp = ImplResourceManager.getString("RoleFailedChooserHelp");
        this.failedHelp = ContextHelpLoader.getContextHelp((String)this.failedHelp, null);
        this.baseTitle = ImplResourceManager.getString("Log In:");
        this.normalTitle = ImplResourceManager.getString("Role Name");
        this.failedTitle = ImplResourceManager.getString("Login Failed");
        this.setTitle(this.normalTitle);
        this.setHelpHTML(this.normalHelp);
    }

    protected void updateFontAndColor() {
        this.serverLabel.setFont(ResourceManager.labelFont);
        this.serverLabel.setForeground(ResourceManager.labelColor);
        this.serverField.setFont(ResourceManager.bodyFont);
        this.serverField.setForeground(ResourceManager.bodyColor);
        this.userLabel.setFont(ResourceManager.labelFont);
        this.userLabel.setForeground(ResourceManager.labelColor);
        this.nameField.setFont(ResourceManager.bodyFont);
        this.nameField.setForeground(ResourceManager.bodyColor);
        this.passLabel.setFont(ResourceManager.labelFont);
        this.passLabel.setForeground(ResourceManager.labelColor);
        this.passField.setFont(ResourceManager.bodyFont);
        this.passField.setForeground(ResourceManager.bodyColor);
        this.roleLabel.setFont(ResourceManager.labelFont);
        this.roleLabel.setForeground(ResourceManager.labelColor);
        this.roleField.setFont(ResourceManager.bodyFont);
        this.roleField.setForeground(ResourceManager.bodyColor);
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.ignoreButton.setFont(ResourceManager.menuFont);
        this.ignoreButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected Dimension calculatePreferredSize() {
        Dimension d1 = super.calculatePreferredSize();
        Dimension prefSize = this.prefSize;
        if (!this.infoOn) {
            prefSize = new Dimension(500 - this.prefInfoWidth, 300);
        }
        if (d1.width > prefSize.width && d1.height > prefSize.height) {
            return d1;
        }
        if (d1.width < prefSize.width && d1.height < prefSize.height) {
            return prefSize;
        }
        int w = Math.max(d1.width, prefSize.width);
        int h = Math.max(d1.height, prefSize.height);
        return new Dimension(w, h);
    }

    public static void main(String[] args) {
        ResourceManager.seed((boolean)true);
        RoleChooser chooser = new RoleChooser();
        int r = chooser.showRoleDialog(null, "dodgeviper", "testuser", null, args.length > 0);
        if (r == 0) {
            System.err.println("Role: " + chooser.getRoleName());
            System.err.println("Password: " + chooser.getRolePassword());
        }
        System.exit(0);
    }
}

