/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class PrivilegeDialog
extends VOptionPane
implements Serializable {
    public static final int GRANT_PRIVILEGE = 0;
    public static final int GRANT_CODEBASE = 1;
    public static final int DENY_PRIVILEGE = 2;
    public static final int DENY_CODEBASE = 3;
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int DELETE = 2;
    public static final int EXECUTE = 3;
    public static final int LINK = 4;
    public static final int PREF_WIDTH = 500;
    public static final int PREF_HEIGHT = 300;
    protected static ImageIcon secIcon = null;
    protected JLabel title = null;
    protected JCheckBox trustBox = new JCheckBox();
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JDialog dialog = null;
    protected int returnValue = 2;
    protected static transient MessageFormat readDesc = null;
    protected static transient MessageFormat readFDDesc = null;
    protected static transient MessageFormat writeDesc = null;
    protected static transient MessageFormat writeFDDesc = null;
    protected static transient MessageFormat deleteDesc = null;
    protected static transient MessageFormat execDesc = null;
    protected static transient MessageFormat linkDesc = null;
    protected static transient String unknownLoc = null;
    protected static transient String readHelp = null;
    protected static transient String writeHelp = null;
    protected static transient String deleteHelp = null;
    protected static transient String execHelp = null;
    protected static transient String linkHelp = null;
    protected transient String baseTitle = null;
    protected transient String normalTitle = null;
    protected transient Dimension prefSize = null;

    public PrivilegeDialog() {
        if (secIcon == null) {
            secIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Warn32.gif", this.getClass());
        }
        this.prefSize = new Dimension(500, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(5, 15, 15, 15));
        JPanel bodyPanel = new JPanel(new BorderLayout());
        bodyPanel.add((Component)new JLabel(secIcon), "West");
        this.title = new JLabel();
        bodyPanel.add((Component)this.title, "Center");
        bodyPanel.add((Component)new JLabel(secIcon), "East");
        this.getContentPane().add((Component)bodyPanel, "North");
        this.toggleContentTitle(false);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrivilegeDialog.this.returnValue = PrivilegeDialog.this.trustBox.isSelected() ? 1 : 0;
                if (PrivilegeDialog.this.dialog != null) {
                    PrivilegeDialog.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrivilegeDialog.this.returnValue = PrivilegeDialog.this.trustBox.isSelected() ? 3 : 2;
                if (PrivilegeDialog.this.dialog != null) {
                    PrivilegeDialog.this.dialog.setVisible(false);
                }
            }
        });
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.cancelButton);
        this.init();
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    public int showDialog(Component parentComp, CodeSource codeSource, int privilegeType, Object[] parameters) {
        this.trustBox.setSelected(false);
        this.updateContent(privilegeType, codeSource, parameters);
        Frame frame = parentComp instanceof Frame ? (Frame)parentComp : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parentComp);
        this.dialog = new VDialog(frame, null, true);
        this.updateFontAndColor();
        super.setContainer((Component)this.dialog);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parentComp);
        this.dialog.invalidate();
        this.dialog.validate();
        this.dialog.repaint();
        this.dialog.show();
        return this.returnValue;
    }

    protected void updateContent(int accessType, CodeSource codeSource, Object[] parameters) {
        switch (accessType) {
            case 0: {
                this.setHelpHTML(readHelp);
                this.getContentPane().add((Component)this.createReadPanel(codeSource, parameters), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 1: {
                this.setHelpHTML(writeHelp);
                this.getContentPane().add((Component)this.createWritePanel(codeSource, parameters), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 2: {
                this.setHelpHTML(deleteHelp);
                this.getContentPane().add((Component)this.createDeletePanel(codeSource, parameters), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 3: {
                this.setHelpHTML(execHelp);
                this.getContentPane().add((Component)this.createExecPanel(codeSource, parameters), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 4: {
                this.setHelpHTML(linkHelp);
                this.getContentPane().add((Component)this.createLinkPanel(codeSource, parameters), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
            }
        }
    }

    protected String getCodeLocation(CodeSource codeSource) {
        URL u = null;
        if (codeSource != null) {
            u = codeSource.getLocation();
        }
        if (u == null) {
            return unknownLoc;
        }
        String host = u.getHost();
        if (host == null) {
            return u.toString();
        }
        try {
            InetAddress ia = InetAddress.getByName(host);
            host = ia.getHostName();
        }
        catch (Throwable t) {
            // empty catch block
        }
        int port = u.getPort();
        if (port != -1) {
            return host + ":" + port;
        }
        return host;
    }

    protected JPanel createReadPanel(CodeSource codeSource, Object[] parameters) {
        String codeLocation = this.getCodeLocation(codeSource);
        JPanel readPanel = new JPanel(new BorderLayout());
        JTextArea description = new JTextArea();
        description.setBorder(new EmptyBorder(10, 0, 0, 0));
        description.setOpaque(false);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        if (parameters[0] instanceof String) {
            String file = (String)parameters[0];
            description.setText(readDesc.format(new Object[]{codeLocation, file}));
        } else {
            description.setText(readFDDesc.format(new Object[]{codeLocation}));
        }
        readPanel.add((Component)description, "North");
        return readPanel;
    }

    protected JPanel createWritePanel(CodeSource codeSource, Object[] parameters) {
        String codeLocation = this.getCodeLocation(codeSource);
        JPanel writePanel = new JPanel(new BorderLayout());
        JTextArea description = new JTextArea();
        description.setBorder(new EmptyBorder(10, 0, 0, 0));
        description.setOpaque(false);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        if (parameters[0] instanceof String) {
            String file = (String)parameters[0];
            description.setText(writeDesc.format(new Object[]{codeLocation, file}));
        } else {
            description.setText(writeFDDesc.format(new Object[]{codeLocation}));
        }
        writePanel.add((Component)description, "North");
        return writePanel;
    }

    protected JPanel createDeletePanel(CodeSource codeSource, Object[] parameters) {
        String codeLocation = this.getCodeLocation(codeSource);
        JPanel delPanel = new JPanel(new BorderLayout());
        JTextArea description = new JTextArea();
        description.setBorder(new EmptyBorder(10, 0, 0, 0));
        description.setOpaque(false);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        String file = null;
        if (parameters != null && parameters.length > 0) {
            try {
                file = (String)parameters[0];
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        description.setText(deleteDesc.format(new Object[]{codeLocation, file}));
        delPanel.add((Component)description, "North");
        return delPanel;
    }

    protected JPanel createExecPanel(CodeSource codeSource, Object[] parameters) {
        String codeLocation = this.getCodeLocation(codeSource);
        JPanel execPanel = new JPanel(new BorderLayout());
        JTextArea description = new JTextArea();
        description.setBorder(new EmptyBorder(10, 0, 0, 0));
        description.setOpaque(false);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        String cmd = null;
        if (parameters != null && parameters.length > 0) {
            try {
                cmd = (String)parameters[0];
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        description.setText(execDesc.format(new Object[]{codeLocation, cmd}));
        execPanel.add((Component)description, "North");
        return execPanel;
    }

    protected JPanel createLinkPanel(CodeSource codeSource, Object[] parameters) {
        String codeLocation = this.getCodeLocation(codeSource);
        JPanel linkPanel = new JPanel(new BorderLayout());
        JTextArea description = new JTextArea();
        description.setBorder(new EmptyBorder(10, 0, 0, 0));
        description.setOpaque(false);
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        String library = null;
        if (parameters != null && parameters.length > 0) {
            try {
                library = (String)parameters[0];
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        description.setText(linkDesc.format(new Object[]{codeLocation, library}));
        linkPanel.add((Component)description, "North");
        return linkPanel;
    }

    protected void installStrings() {
        unknownLoc = ImplResourceManager.getString("an unkown location");
        try {
            readDesc = new MessageFormat(ImplResourceManager.getString("ReadDescription"));
            readFDDesc = new MessageFormat(ImplResourceManager.getString("ReadFDDescription"));
            writeDesc = new MessageFormat(ImplResourceManager.getString("WriteDescription"));
            writeFDDesc = new MessageFormat(ImplResourceManager.getString("WriteFDDescription"));
            deleteDesc = new MessageFormat(ImplResourceManager.getString("DeleteDescription"));
            execDesc = new MessageFormat(ImplResourceManager.getString("ExecDescription"));
            linkDesc = new MessageFormat(ImplResourceManager.getString("LinkDescription"));
            this.trustBox.setText(ImplResourceManager.getString("Don't ask me again about tools from this location."));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.title.setText(ImplResourceManager.getString("Security Manager Alert"));
        this.title.setHorizontalAlignment(0);
        this.cancelButton.setText(ImplResourceManager.getString("DENY_BUTTON"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("DENY_BUTTON__mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("DENY_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ImplResourceManager.getString("DENY_BUTTON_accessible_desc"));
        this.okButton.setText(ImplResourceManager.getString("GRANT_BUTTON"));
        this.okButton.setMnemonic(ImplResourceManager.getString("GRANT_BUTTON_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("GRANT_BUTTON_accessible_name"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ImplResourceManager.getString("GRANT_BUTTON_accessible_name"));
        readHelp = ImplResourceManager.getString("ReadPrivilegeHelp");
        readHelp = ContextHelpLoader.getContextHelp((String)readHelp, null);
        writeHelp = ImplResourceManager.getString("WritePrivilegeHelp");
        writeHelp = ContextHelpLoader.getContextHelp((String)writeHelp, null);
        deleteHelp = ImplResourceManager.getString("DeletePrivilegeHelp");
        deleteHelp = ContextHelpLoader.getContextHelp((String)deleteHelp, null);
        execHelp = ImplResourceManager.getString("ExecPrivilegeHelp");
        execHelp = ContextHelpLoader.getContextHelp((String)execHelp, null);
        linkHelp = ImplResourceManager.getString("LinkPrivilegeHelp");
        linkHelp = ContextHelpLoader.getContextHelp((String)linkHelp, null);
        this.baseTitle = ImplResourceManager.getString("Security Check:");
        this.setTitle(this.normalTitle);
    }

    protected void updateFontAndColor() {
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected Dimension calculatePreferredSize() {
        Dimension d1 = super.calculatePreferredSize();
        Dimension prefSize = this.prefSize;
        if (!this.infoOn) {
            prefSize = new Dimension(500 - this.prefInfoWidth, 300);
        }
        if (d1.width > prefSize.width && d1.height > prefSize.height) {
            return d1;
        }
        if (d1.width < prefSize.width && d1.height < prefSize.height) {
            return prefSize;
        }
        int w = Math.max(d1.width, prefSize.width);
        int h = Math.max(d1.height, prefSize.height);
        return new Dimension(w, h);
    }

    public static void main(String[] args) {
        ResourceManager.seed((boolean)true);
        PrivilegeDialog pd = new PrivilegeDialog();
        System.exit(pd.showDialog(null, null, 0, null));
    }
}

