/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.deck.VCard;
import com.sun.management.viper.console.gui.propsheet.VPropertySheet;
import com.sun.management.viper.console.gui.propsheet.VPropertySheetEditor;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.gui.ComboToolBoxChooser;
import com.sun.management.viperimpl.console.gui.FontChooser;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PreferencesPane
extends VPropertySheetEditor {
    protected static Class imageClass = null;
    protected boolean notify = true;
    protected ActionListener actionL = null;
    protected DocumentListener documentL = null;
    protected VConsoleProperties properties = null;
    protected ConsoleSheet consoleSheet = null;
    protected GeneralSheet generalSheet = null;
    protected ToolBarSheet toolBarSheet = null;
    protected FontsSheet fontsSheet = null;
    protected ToolLoadSheet toolLoadSheet = null;
    protected AuthSheet authSheet = null;

    public PreferencesPane() {
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viper.console.gui.VFilter");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.title = ImplResourceManager.getString("Preferences");
        this.installSheets();
        this.deckProperties.setProperty("vpsp.okenabled", (Object)"vwp.false");
        this.deckProperties.setProperty("vpsp.applyenabled", (Object)"vwp.false");
        this.actionL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PreferencesPane.this.notify) {
                    return;
                }
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.okenabled", (Object)"vwp.true");
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.applyenabled", (Object)"vwp.true");
            }
        };
        this.documentL = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.notifyPropSheet();
            }

            public void insertUpdate(DocumentEvent e) {
                this.notifyPropSheet();
            }

            public void removeUpdate(DocumentEvent e) {
                this.notifyPropSheet();
            }

            protected void notifyPropSheet() {
                if (!PreferencesPane.this.notify) {
                    return;
                }
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.okenabled", (Object)"vwp.true");
                PreferencesPane.this.getDeckProperties().setProperty("vpsp.applyenabled", (Object)"vwp.true");
            }
        };
    }

    public void setProperties(VConsoleProperties properties) {
        if (this.properties != null) {
            this.properties.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.consoleSheet);
            this.consoleSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.generalSheet);
            this.generalSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.toolBarSheet);
            this.toolBarSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.fontsSheet);
            this.fontsSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.toolLoadSheet);
            this.toolLoadSheet.init = false;
            this.properties.removePropertyChangeListener((PropertyChangeListener)this.authSheet);
            this.authSheet.init = false;
        }
        this.properties = properties;
        super.setProperties(properties);
    }

    protected Component getContaner() {
        return this.container;
    }

    protected void installSheets() {
        this.consoleSheet = new ConsoleSheet();
        this.addCard("console", (VCard)this.consoleSheet);
        this.generalSheet = new GeneralSheet();
        this.addCard("appearance", (VCard)this.generalSheet);
        this.toolBarSheet = new ToolBarSheet();
        this.addCard("toolbar", (VCard)this.toolBarSheet);
        this.fontsSheet = new FontsSheet();
        this.addCard("fonts", (VCard)this.fontsSheet);
        this.toolLoadSheet = new ToolLoadSheet();
        this.addCard("toolload", (VCard)this.toolLoadSheet);
        this.authSheet = new AuthSheet();
        this.addCard("auth", (VCard)this.authSheet);
    }

    public static void main(String[] args) {
        ResourceManager.seed((boolean)true);
        PreferencesPane p = new PreferencesPane();
        p.setProperties(VConsoleProperties.newInstance());
        VDialog d = new VDialog((Frame)new VFrame(), "Preferences", true);
        p.setContainer((Component)d);
        d.pack();
        d.setLocationRelativeTo(null);
        d.show();
        System.exit(0);
    }

    class AuthSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JCheckBox cb = null;
        protected JCheckBox cb2 = null;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JLabel loadLabel = null;
        protected JLabel advLabel = null;
        protected boolean init = false;

        public AuthSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            this.add(Box.createVerticalStrut(20));
            this.loadLabel = new JLabel(ImplResourceManager.getString("When loading tools from multiple servers:"));
            this.advLabel = new JLabel(ImplResourceManager.getString("Advanced login allows user and role login in a single step:"));
            this.rb1 = new JRadioButton(ImplResourceManager.getString("Prompt for initial credentials and use them for all servers"));
            this.rb2 = new JRadioButton(ImplResourceManager.getString("Prompt for credentials for every server"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rb1);
            bg.add(this.rb2);
            this.cb = new JCheckBox(ImplResourceManager.getString("Prompt if credentials fail"));
            this.cb2 = new JCheckBox(ImplResourceManager.getString("Enable advanced login"));
            this.add(this.loadLabel);
            this.add(Box.createVerticalStrut(10));
            this.add(this.rb1);
            this.add(Box.createVerticalStrut(10));
            this.add(this.rb2);
            this.add(Box.createVerticalStrut(20));
            this.add(this.cb);
            this.add(Box.createVerticalStrut(40));
            this.add(this.advLabel);
            this.add(Box.createVerticalStrut(10));
            this.add(this.cb2);
            this.add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Authentication"));
            String help = ImplResourceManager.getString("AuthenticationHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.updateFontAndColor();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String value = PreferencesPane.this.properties.getProperty("vconsole.authpreference");
            this.reflectValue1(value);
            value = PreferencesPane.this.properties.getProperty("vconsole.promptonfailure");
            this.reflectValue2(value);
            value = PreferencesPane.this.properties.getProperty("vconsole.loginmode");
            this.reflectValue3(value);
            PreferencesPane.this.notify = true;
        }

        protected void updateFontAndColor() {
            this.cb.setFont(ResourceManager.menuFont);
            this.cb.setForeground(ResourceManager.menuColor);
            this.cb2.setFont(ResourceManager.menuFont);
            this.cb2.setForeground(ResourceManager.menuColor);
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.loadLabel.setFont(ResourceManager.labelFont);
            this.loadLabel.setForeground(ResourceManager.labelColor);
            this.advLabel.setFont(ResourceManager.labelFont);
            this.advLabel.setForeground(ResourceManager.labelColor);
        }

        protected void reflectValue1(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("vconsole.alwaysuseinitial")) {
                this.rb1.setSelected(true);
            } else if (value.equals("vconsole.alwaysprompt")) {
                this.rb2.setSelected(true);
            }
        }

        protected void reflectValue2(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("true")) {
                this.cb.setSelected(true);
            } else if (value.equals("false")) {
                this.cb.setSelected(false);
            }
        }

        protected void reflectValue3(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("vconsole.advanced")) {
                this.cb2.setSelected(true);
            } else if (value.equals("vconsole.basic")) {
                this.cb2.setSelected(false);
            }
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String value = PreferencesPane.this.properties.getProperty("vconsole.authpreference");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.authpreference", "vconsole.alwaysuseinitial");
                    value = "vconsole.alwaysuseinitial";
                }
                this.reflectValue1(value);
                value = PreferencesPane.this.properties.getProperty("vconsole.promptonfailure");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.promptonfailure", "true");
                    value = "true";
                }
                this.reflectValue2(value);
                value = PreferencesPane.this.properties.getProperty("vconsole.loginmode");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.loginmode", "vconsole.basic");
                    value = "vconsole.basic";
                }
                this.reflectValue3(value);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.cb.addActionListener(PreferencesPane.this.actionL);
                this.cb2.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.authpreference", "vconsole.alwaysuseinitial");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.authpreference", "vconsole.alwaysprompt");
            }
            if (this.cb.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.promptonfailure", "true");
            } else {
                PreferencesPane.this.properties.setProperty("vconsole.promptonfailure", "false");
            }
            if (this.cb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loginmode", "vconsole.advanced");
            } else {
                PreferencesPane.this.properties.setProperty("vconsole.loginmode", "vconsole.basic");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce == null) {
                return;
            }
            try {
                String key = pce.getPropertyName();
                String newValue = (String)pce.getNewValue();
                if (key == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (key.equals("vconsole.authpreference")) {
                    this.reflectValue1(newValue);
                } else if (key.equals("vconsole.promptonfailure")) {
                    this.reflectValue2(newValue);
                } else if (key.equals("vconsole.loginmode")) {
                    this.reflectValue3(newValue);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ToolBarSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JLabel displayLabel = null;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JRadioButton rb3 = null;
        protected JButton b1 = null;
        protected JButton b2 = null;
        protected JButton b3 = null;
        protected boolean init = false;

        public ToolBarSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            this.displayLabel = new JLabel(ImplResourceManager.getString("Display As:"));
            this.add(Box.createVerticalStrut(20));
            JPanel p1 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p1.setLayout(new FlowLayout(0));
            p1.add(this.displayLabel);
            this.add(p1);
            this.rb1 = new JRadioButton();
            this.rb2 = new JRadioButton();
            this.rb3 = new JRadioButton();
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.rb1);
            bg1.add(this.rb2);
            bg1.add(this.rb3);
            JPanel p2 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p2.setLayout(new FlowLayout(0));
            p2.add(this.rb1);
            ImageIcon i1 = ConsoleUtility.loadImageIcon((String)"images/delete16.gif", (Class)imageClass);
            this.b1 = new JButton(i1);
            Insets nogap = new Insets(0, 0, 0, 0);
            this.b1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ToolBarSheet.this.rb1.setSelected(true);
                }
            });
            this.b1.setMargin(nogap);
            p2.add(this.b1);
            this.add(Box.createVerticalStrut(10));
            this.add(p2);
            this.add(Box.createVerticalStrut(10));
            JPanel p3 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p3.setLayout(new FlowLayout(0));
            p3.add(this.rb2);
            String title = ImplResourceManager.getString("Delete");
            this.b2 = new JButton(title, i1);
            this.b2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ToolBarSheet.this.rb2.setSelected(true);
                }
            });
            this.b2.setMargin(nogap);
            p3.add(this.b2);
            this.add(p3);
            this.add(Box.createVerticalStrut(10));
            JPanel p4 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p4.setLayout(new FlowLayout(0));
            p4.add(this.rb3);
            this.b3 = new JButton(title);
            this.b3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ToolBarSheet.this.rb3.setSelected(true);
                }
            });
            this.b3.setMargin(nogap);
            p4.add(this.b3);
            this.add(p4);
            this.setTitle(ImplResourceManager.getString("Toolbar"));
            String help = ImplResourceManager.getString("ToolbarHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.updateFontAndColor();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String value = PreferencesPane.this.properties.getProperty("vconsole.buttondisplay");
            this.reflectValue(value);
            PreferencesPane.this.notify = true;
        }

        protected void updateFontAndColor() {
            this.displayLabel.setFont(ResourceManager.labelFont);
            this.displayLabel.setForeground(ResourceManager.labelColor);
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.b1.setFont(ResourceManager.menuFont);
            this.b1.setForeground(ResourceManager.menuColor);
            this.b2.setFont(ResourceManager.menuFont);
            this.b2.setForeground(ResourceManager.menuColor);
            this.b3.setFont(ResourceManager.menuFont);
            this.b3.setForeground(ResourceManager.menuColor);
        }

        protected void reflectValue(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("vconsole.icononly")) {
                this.rb1.setSelected(true);
            } else if (value.equals("vconsole.textandicon")) {
                this.rb2.setSelected(true);
            } else if (value.equals("vconsole.textonly")) {
                this.rb3.setSelected(true);
            }
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String value = PreferencesPane.this.properties.getProperty("vconsole.buttondisplay");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.icononly");
                    value = "vconsole.icononly";
                }
                this.reflectValue(value);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.b1.addActionListener(PreferencesPane.this.actionL);
                this.b2.addActionListener(PreferencesPane.this.actionL);
                this.b3.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.icononly");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.textandicon");
            } else if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.buttondisplay", "vconsole.textonly");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce == null) {
                return;
            }
            try {
                String key = pce.getPropertyName();
                String newValue = (String)pce.getNewValue();
                if (key == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (key.equals("vconsole.buttondisplay")) {
                    this.reflectValue(newValue);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class FontsSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JLabel menuLabel = null;
        protected JLabel labelLabel = null;
        protected JLabel bodyLabel = null;
        protected JLabel menuFont = null;
        protected JButton changeMenu = null;
        protected JLabel labelFont = null;
        protected JButton changeLabel = null;
        protected JLabel bodyFont = null;
        protected JButton changeBody = null;
        protected boolean init = false;
        protected FontChooser fontChooser = null;

        public FontsSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            ActionListener changeListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == FontsSheet.this.changeMenu) {
                        FontsSheet.this.promptUserForFont(FontsSheet.this.menuFont);
                    } else if (e.getSource() == FontsSheet.this.changeLabel) {
                        FontsSheet.this.promptUserForFont(FontsSheet.this.labelFont);
                    } else {
                        FontsSheet.this.promptUserForFont(FontsSheet.this.bodyFont);
                    }
                }
            };
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, 0));
            this.menuLabel = new JLabel();
            p1.add(this.menuLabel);
            p1.add(Box.createHorizontalGlue());
            this.add(p1);
            this.add(Box.createVerticalStrut(10));
            JPanel p2 = new JPanel(new GridLayout(1, 2));
            JPanel p21 = new JPanel();
            p21.setLayout(new BoxLayout(p21, 0));
            this.menuFont = new JLabel();
            p21.add(this.menuFont);
            p21.add(Box.createHorizontalGlue());
            p2.add(p21);
            JPanel p22 = new JPanel();
            p22.setLayout(new BoxLayout(p22, 0));
            this.changeMenu = new JButton();
            p22.add(this.changeMenu);
            p22.add(Box.createHorizontalGlue());
            p2.add(p22);
            this.changeMenu.addActionListener(changeListener);
            this.add(p2);
            this.add(Box.createVerticalStrut(10));
            JPanel p3 = new JPanel();
            p3.setLayout(new BoxLayout(p3, 0));
            this.labelLabel = new JLabel();
            p3.add(this.labelLabel);
            p3.add(Box.createHorizontalGlue());
            this.add(p3);
            this.add(Box.createVerticalStrut(10));
            JPanel p4 = new JPanel(new GridLayout(1, 2));
            JPanel p41 = new JPanel();
            p41.setLayout(new BoxLayout(p41, 0));
            this.labelFont = new JLabel();
            p41.add(this.labelFont);
            p41.add(Box.createHorizontalGlue());
            p4.add(p41);
            JPanel p42 = new JPanel();
            p42.setLayout(new BoxLayout(p42, 0));
            this.changeLabel = new JButton();
            p42.add(this.changeLabel);
            p42.add(Box.createHorizontalGlue());
            p4.add(p42);
            this.changeLabel.addActionListener(changeListener);
            this.add(p4);
            this.add(Box.createVerticalStrut(10));
            JPanel p5 = new JPanel();
            p5.setLayout(new BoxLayout(p5, 0));
            this.bodyLabel = new JLabel();
            p5.add(this.bodyLabel);
            p5.add(Box.createHorizontalGlue());
            this.add(p5);
            this.add(Box.createVerticalStrut(10));
            JPanel p6 = new JPanel(new GridLayout(1, 2));
            JPanel p61 = new JPanel();
            p61.setLayout(new BoxLayout(p61, 0));
            this.bodyFont = new JLabel();
            p61.add(this.bodyFont);
            p61.add(Box.createHorizontalGlue());
            p6.add(p61);
            JPanel p62 = new JPanel();
            p62.setLayout(new BoxLayout(p62, 0));
            this.changeBody = new JButton();
            p62.add(this.changeBody);
            p62.add(Box.createHorizontalGlue());
            p6.add(p62);
            this.changeBody.addActionListener(changeListener);
            this.add(p6);
            this.add(Box.createVerticalStrut(10));
            this.setTitle(ImplResourceManager.getString("Fonts"));
            String help = ImplResourceManager.getString("FontsHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.installStrings();
        }

        public void reset() {
        }

        protected void promptUserForFont(JLabel label) {
            if (this.fontChooser == null) {
                this.fontChooser = new FontChooser();
            }
            String contextHelp = null;
            contextHelp = label == this.labelFont ? "FontChooserLabelHelp" : (label == this.menuFont ? "FontChooserMenuHelp" : "FontChooserHelp");
            this.fontChooser.setContextHelp(ImplResourceManager.getString(contextHelp));
            try {
                int result = this.fontChooser.showFontDialog(label.getFont(), label.getForeground(), PreferencesPane.this.getContainer());
                if (result != 1) {
                    if (label == this.menuFont) {
                        this.reflectFontAndColor(this.menuFont, this.fontChooser.getFont(), this.fontChooser.getColor());
                    } else if (label == this.labelFont) {
                        this.reflectFontAndColor(this.labelFont, this.fontChooser.getFont(), this.fontChooser.getColor());
                    } else {
                        this.reflectFontAndColor(this.bodyFont, this.fontChooser.getFont(), this.fontChooser.getColor());
                    }
                    PreferencesPane.this.actionL.actionPerformed(null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Debug.trace((String)"FontsSheet", (int)Debug.WARNING, (String)"Problem prompting for font", (Throwable)t);
            }
        }

        protected void installStrings() {
            this.menuLabel.setText(ImplResourceManager.getString("Menu:"));
            String changeIt = ImplResourceManager.getString("Change...");
            this.changeMenu.setText(changeIt);
            this.labelLabel.setText(ImplResourceManager.getString("Label:"));
            this.changeLabel.setText(changeIt);
            this.bodyLabel.setText(ImplResourceManager.getString("Body:"));
            this.changeBody.setText(changeIt);
        }

        protected void updateFontAndColor() {
            this.menuLabel.setFont(ResourceManager.labelFont);
            this.menuLabel.setForeground(ResourceManager.labelColor);
            this.labelLabel.setFont(ResourceManager.labelFont);
            this.labelLabel.setForeground(ResourceManager.labelColor);
            this.bodyLabel.setFont(ResourceManager.labelFont);
            this.bodyLabel.setForeground(ResourceManager.labelColor);
        }

        protected void reflectFontAndColor(JLabel label, Font f, Color c) {
            if (label == null && f == null && c == null) {
                return;
            }
            if (f == null) {
                f = label.getFont();
            }
            String fontName = f.getFontName(ResourceManager.currentLocale);
            int size = f.getSize();
            String style = "";
            style = f.isBold() ? ImplResourceManager.getString("Bold") : (f.isItalic() ? ImplResourceManager.getString("Italic") : ImplResourceManager.getString("Plain"));
            label.setText(fontName + ", " + size + ", " + style);
            label.setFont(f);
            label.setForeground(c);
            label.validate();
            label.repaint();
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                this.reflectFontAndColor(this.bodyFont, ResourceManager.bodyFont, ResourceManager.bodyColor);
                this.reflectFontAndColor(this.labelFont, ResourceManager.labelFont, ResourceManager.labelColor);
                this.reflectFontAndColor(this.menuFont, ResourceManager.menuFont, ResourceManager.menuColor);
                this.init = true;
            }
            catch (Throwable t) {
                Debug.trace((String)"FontsSheet", (int)Debug.WARNING, (String)"Problem in start()", (Throwable)t);
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.menuFont.getFont() != ResourceManager.menuFont) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.menufont", (Object)this.menuFont.getFont());
            }
            if (this.menuFont.getForeground() != ResourceManager.menuColor) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.menucolor", (Object)this.menuFont.getForeground());
            }
            if (this.labelFont.getFont() != ResourceManager.labelFont) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.labelfont", (Object)this.labelFont.getFont());
            }
            if (this.labelFont.getForeground() != ResourceManager.labelColor) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.labelcolor", (Object)this.labelFont.getForeground());
            }
            if (this.bodyFont.getFont() != ResourceManager.bodyFont) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.bodyfont", (Object)this.bodyFont.getFont());
            }
            if (this.bodyFont.getForeground() != ResourceManager.bodyColor) {
                PreferencesPane.this.properties.setPropertyObject("vconsole.bodycolor", (Object)this.bodyFont.getForeground());
            }
            return true;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void propertyChange(PropertyChangeEvent pce) {
        }
    }

    class GeneralSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JRadioButton rb3 = null;
        protected JRadioButton rb4 = null;
        protected JButton i1 = null;
        protected JButton i2 = null;
        protected JLabel layoutLabel = null;
        protected JLabel styleLabel = null;
        protected boolean init = false;

        public GeneralSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            this.add(Box.createVerticalStrut(20));
            this.layoutLabel = new JLabel(ImplResourceManager.getString("Console Layout:"));
            JPanel p3 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p3.setLayout(new FlowLayout(0));
            p3.add(this.layoutLabel);
            this.add(p3);
            this.add(Box.createVerticalStrut(10));
            this.rb1 = new JRadioButton();
            Insets nogap = new Insets(0, 0, 0, 0);
            this.i1 = new JButton(ConsoleUtility.loadImageIcon((String)"images/hlayout.gif", (Class)imageClass));
            this.i1.setBorderPainted(false);
            this.i1.setMargin(nogap);
            this.i1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GeneralSheet.this.rb1.setSelected(true);
                }
            });
            this.rb2 = new JRadioButton();
            this.i2 = new JButton(ConsoleUtility.loadImageIcon((String)"images/vlayout.gif", (Class)imageClass));
            this.i2.setBorderPainted(false);
            this.i2.setMargin(nogap);
            this.i2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GeneralSheet.this.rb2.setSelected(true);
                }
            });
            ButtonGroup bg1 = new ButtonGroup();
            JPanel p1 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p1.setLayout(new FlowLayout(0));
            p1.add(this.rb1);
            p1.add(this.i1);
            JPanel p2 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p2.setLayout(new FlowLayout(0));
            p2.add(this.rb2);
            p2.add(this.i2);
            bg1.add(this.rb1);
            bg1.add(this.rb2);
            this.add(p1);
            this.add(p2);
            this.add(Box.createVerticalStrut(20));
            JPanel p4 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p4.setLayout(new FlowLayout(0));
            this.styleLabel = new JLabel(ImplResourceManager.getString("Interaction Style:"));
            p4.add(this.styleLabel);
            this.add(p4);
            this.add(Box.createVerticalStrut(10));
            this.rb3 = new JRadioButton(ImplResourceManager.getString("Classic"));
            this.rb4 = new JRadioButton(ImplResourceManager.getString("Web"));
            ButtonGroup bg2 = new ButtonGroup();
            bg2.add(this.rb3);
            bg2.add(this.rb4);
            JPanel p5 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p5.setLayout(new FlowLayout(0));
            p5.add(this.rb3);
            JPanel p6 = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }
            };
            p6.setLayout(new FlowLayout(0));
            p6.add(this.rb4);
            this.add(Box.createVerticalStrut(10));
            this.add(p5);
            this.add(p6);
            this.add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Appearance"));
            String help = ImplResourceManager.getString("AppearanceHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.updateFontAndColor();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            this.reflectValue1(PreferencesPane.this.properties.getProperty("vconsole.layout"));
            this.reflectValue2(PreferencesPane.this.properties.getProperty("vconsole.clickstyle"));
            PreferencesPane.this.notify = true;
        }

        protected void updateFontAndColor() {
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.rb4.setFont(ResourceManager.menuFont);
            this.rb4.setForeground(ResourceManager.menuColor);
            this.layoutLabel.setFont(ResourceManager.labelFont);
            this.layoutLabel.setForeground(ResourceManager.labelColor);
            this.styleLabel.setFont(ResourceManager.labelFont);
            this.styleLabel.setForeground(ResourceManager.labelColor);
        }

        protected void reflectValue1(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("horizontal")) {
                this.rb1.setSelected(true);
            } else if (value.equals("vertical")) {
                this.rb2.setSelected(true);
            }
        }

        protected void reflectValue2(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("classic")) {
                this.rb3.setSelected(true);
            } else if (value.equals("web")) {
                this.rb4.setSelected(true);
            }
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String value = PreferencesPane.this.properties.getProperty("vconsole.layout");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.layout", "horizontal");
                    value = "horizontal";
                }
                this.reflectValue1(value);
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.i1.addActionListener(PreferencesPane.this.actionL);
                this.i2.addActionListener(PreferencesPane.this.actionL);
                value = PreferencesPane.this.properties.getProperty("vconsole.clickstyle");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.clickstyle", "classic");
                    value = "classic";
                }
                this.reflectValue2(value);
                this.init = true;
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.rb4.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.layout", "horizontal");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.layout", "vertical");
            }
            if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.clickstyle", "classic");
            } else if (this.rb4.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.clickstyle", "web");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce == null) {
                return;
            }
            try {
                String key = pce.getPropertyName();
                String newValue = (String)pce.getNewValue();
                if (key == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (key.equals("vconsole.layout")) {
                    this.reflectValue1(newValue);
                } else if (key.equals("vconsole.clickstyle")) {
                    this.reflectValue2(newValue);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ToolLoadSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected boolean init = false;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb3 = null;
        protected JLabel openLabel = null;
        protected JCheckBox override = null;

        public ToolLoadSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 1));
            this.openLabel = new JLabel(ImplResourceManager.getString("After opening a Toolbox:"));
            topPanel.add(this.openLabel);
            topPanel.add(Box.createVerticalStrut(10));
            this.rb1 = new JRadioButton(ImplResourceManager.getString("Display the console, then load tools when selected"));
            this.rb3 = new JRadioButton(ImplResourceManager.getString("Load all tools before displaying the console"));
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.rb1);
            bg1.add(this.rb3);
            topPanel.add(this.rb1);
            topPanel.add(Box.createVerticalStrut(10));
            topPanel.add(this.rb3);
            topPanel.add(Box.createVerticalStrut(10));
            JPanel lj1 = new JPanel();
            lj1.setLayout(new BorderLayout());
            lj1.add((Component)topPanel, "West");
            this.override = new JCheckBox(ImplResourceManager.getString("These settings always override any Toolbox settings"));
            topPanel.add(Box.createVerticalStrut(20));
            topPanel.add(this.override);
            this.add(Box.createVerticalStrut(20));
            this.add(topPanel);
            this.add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Tool Loading"));
            String help = ImplResourceManager.getString("ToolLoadingHelpHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.updateFontAndColor();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String value = PreferencesPane.this.properties.getProperty("vconsole.toolloading");
            this.reflectValue(value);
            value = PreferencesPane.this.properties.getProperty("vconsole.overridetoolbox");
            this.reflectSetting(value);
            PreferencesPane.this.notify = true;
        }

        protected void updateFontAndColor() {
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.openLabel.setFont(ResourceManager.labelFont);
            this.openLabel.setForeground(ResourceManager.labelColor);
            this.override.setFont(ResourceManager.menuFont);
            this.override.setForeground(ResourceManager.menuColor);
        }

        protected void reflectValue(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("vconsole.loadondemand")) {
                this.rb1.setSelected(true);
            } else if (value.equals("vconsole.loadbeforedisplay")) {
                this.rb3.setSelected(true);
            }
            this.validate();
            this.repaint();
        }

        protected void reflectSetting(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("true")) {
                this.override.setSelected(true);
            } else if (value.equals("false")) {
                this.override.setSelected(false);
            }
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String value = PreferencesPane.this.properties.getProperty("vconsole.toolloading");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.toolloading", "vconsole.loadbeforedisplay");
                    value = "vconsole.loadbeforedisplay";
                }
                this.reflectValue(value);
                value = PreferencesPane.this.properties.getProperty("vconsole.overridetoolbox");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.overridetoolbox", "false");
                    value = "false";
                }
                this.reflectSetting(value);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.override.addActionListener(PreferencesPane.this.actionL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.toolloading", "vconsole.loadondemand");
            } else if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.toolloading", "vconsole.loadbeforedisplay");
            }
            if (this.override.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.overridetoolbox", "true");
            } else {
                PreferencesPane.this.properties.setProperty("vconsole.overridetoolbox", "false");
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce == null) {
                return;
            }
            try {
                String key = pce.getPropertyName();
                String newValue = (String)pce.getNewValue();
                if (key == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (key.equals("vconsole.toolloading")) {
                    this.reflectValue(newValue);
                } else if (key.equals("vconsole.overridetoolbox")) {
                    this.reflectSetting(newValue);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class NetworkSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JTextField proxyField = null;
        protected JTextField portField = null;
        protected JRadioButton rb1 = null;
        protected JRadioButton rb2 = null;
        protected JLabel proxyLabel = null;
        protected JLabel httpLabel = null;
        protected JLabel portLabel = null;
        protected boolean init = false;

        public NetworkSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 1));
            this.proxyLabel = new JLabel(ImplResourceManager.getString("Network Proxy"));
            topPanel.add(Box.createVerticalStrut(20));
            topPanel.add(this.proxyLabel);
            topPanel.add(Box.createVerticalStrut(10));
            this.rb1 = new JRadioButton(ImplResourceManager.getString("Direct Connection"));
            this.rb1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NetworkSheet.this.proxyField.setEnabled(false);
                    NetworkSheet.this.portField.setEnabled(false);
                }
            });
            this.rb2 = new JRadioButton(ImplResourceManager.getString("Manual Proxy"));
            this.rb2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NetworkSheet.this.proxyField.setEnabled(true);
                    NetworkSheet.this.portField.setEnabled(true);
                }
            });
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.rb1);
            bg1.add(this.rb2);
            topPanel.add(this.rb1);
            topPanel.add(this.rb2);
            topPanel.add(Box.createVerticalStrut(25));
            JPanel bp1 = new JPanel();
            bp1.setLayout(new BorderLayout());
            bp1.add((Component)topPanel, "West");
            JPanel proxyP = new JPanel();
            proxyP.setLayout(new BoxLayout(proxyP, 0));
            this.httpLabel = new JLabel(ImplResourceManager.getString("Http Proxy:"));
            proxyP.add(this.httpLabel);
            proxyP.add(Box.createHorizontalStrut(10));
            this.proxyField = new JTextField(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            this.portField = new JTextField(5){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            proxyP.add(this.proxyField);
            proxyP.add(Box.createHorizontalStrut(10));
            this.portLabel = new JLabel(ImplResourceManager.getString("Port:"));
            proxyP.add(this.portLabel);
            proxyP.add(Box.createHorizontalStrut(10));
            proxyP.add(this.portField);
            JPanel botPanel = new JPanel();
            botPanel.setLayout(new BorderLayout());
            botPanel.add((Component)proxyP, "North");
            JPanel bodyPanel = new JPanel();
            bodyPanel.setLayout(new BorderLayout());
            bodyPanel.add((Component)bp1, "North");
            bodyPanel.add((Component)botPanel, "South");
            JPanel bodyPanel2 = new JPanel();
            bodyPanel2.setLayout(new BorderLayout());
            bodyPanel2.add((Component)bodyPanel, "North");
            this.add(bodyPanel2);
            this.add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Network"));
            String help = ImplResourceManager.getString("NetworkHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.updateFontAndColor();
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String value = PreferencesPane.this.properties.getProperty("vconsole.networkconnection");
            this.reflectValue1(value);
            value = PreferencesPane.this.properties.getProperty("vconsole.httpproxy");
            this.reflectValue2(value);
            PreferencesPane.this.notify = true;
        }

        protected void updateFontAndColor() {
            this.proxyField.setFont(ResourceManager.bodyFont);
            this.proxyField.setForeground(ResourceManager.bodyColor);
            this.portField.setFont(ResourceManager.bodyFont);
            this.portField.setForeground(ResourceManager.bodyColor);
            this.rb1.setFont(ResourceManager.menuFont);
            this.rb1.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.proxyLabel.setFont(ResourceManager.labelFont);
            this.proxyLabel.setForeground(ResourceManager.labelColor);
            this.httpLabel.setFont(ResourceManager.labelFont);
            this.httpLabel.setForeground(ResourceManager.labelColor);
            this.portLabel.setFont(ResourceManager.labelFont);
            this.portLabel.setForeground(ResourceManager.labelColor);
        }

        protected void reflectValue1(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("vconsole.directconnection")) {
                this.rb1.setSelected(true);
                this.proxyField.setEnabled(false);
                this.portField.setEnabled(false);
            } else if (value.equals("vconsole.proxyconnection")) {
                this.rb2.setSelected(true);
                this.proxyField.setEnabled(true);
                this.portField.setEnabled(true);
            }
            this.validate();
            this.repaint();
        }

        protected void reflectValue2(String value) {
            if (value == null) {
                return;
            }
            int index = value.indexOf(":");
            if (index != -1) {
                this.proxyField.setText(value.substring(0, index));
                this.portField.setText(value.substring(index + 1, value.length()));
            } else {
                this.proxyField.setText(value);
                this.portField.setText("");
            }
            this.validate();
            this.repaint();
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String value = PreferencesPane.this.properties.getProperty("vconsole.networkconnection");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.networkconnection", "vconsole.directconnection");
                    value = "vconsole.directconnection";
                }
                this.reflectValue1(value);
                value = PreferencesPane.this.properties.getProperty("vconsole.httpproxy");
                this.reflectValue2(value);
                this.init = true;
                this.rb1.addActionListener(PreferencesPane.this.actionL);
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.proxyField.getDocument().addDocumentListener(PreferencesPane.this.documentL);
                this.portField.getDocument().addDocumentListener(PreferencesPane.this.documentL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb1.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.networkconnection", "vconsole.directconnection");
            } else if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.networkconnection", "vconsole.proxyconnection");
                String value = this.proxyField.getText();
                int hdr = value.indexOf("://");
                if (hdr != -1) {
                    value = value.substring(hdr + 3, value.length());
                }
                String port = this.portField.getText();
                hdr = value.indexOf(":");
                if (hdr != -1) {
                    port = value.substring(hdr + 1, value.length());
                    value = value.substring(0, hdr);
                }
                PreferencesPane.this.properties.setProperty("vconsole.httpproxy", value + ":" + port);
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce == null) {
                return;
            }
            try {
                String key = pce.getPropertyName();
                String newValue = (String)pce.getNewValue();
                if (key == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (key.equals("vconsole.networkconnection")) {
                    this.reflectValue1(newValue);
                } else if (key.equals("vconsole.httpproxy")) {
                    this.reflectValue2(newValue);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ConsoleSheet
    extends VPropertySheet
    implements PropertyChangeListener {
        protected JTextField locField = null;
        protected JButton b1 = null;
        protected JButton b2 = null;
        protected JRadioButton rb2 = null;
        protected JRadioButton rb3 = null;
        protected JRadioButton rb4 = null;
        protected JLabel startsLabel = null;
        protected JLabel homeTBLabel = null;
        protected JLabel locLabel = null;
        protected ComboToolBoxChooser chooser = null;
        boolean init = false;

        public ConsoleSheet() {
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 1));
            topPanel.add(Box.createVerticalStrut(20));
            JPanel tPanel1 = new JPanel();
            tPanel1.setLayout(new BoxLayout(tPanel1, 0));
            this.startsLabel = new JLabel(ImplResourceManager.getString("Console starts with:"));
            tPanel1.add(this.startsLabel);
            tPanel1.add(Box.createHorizontalGlue());
            topPanel.add(tPanel1);
            this.rb2 = new JRadioButton(ImplResourceManager.getString("Home Toolbox"));
            this.rb3 = new JRadioButton(ImplResourceManager.getString("Last Toolbox Opened"));
            this.rb4 = new JRadioButton(ImplResourceManager.getString("Always Prompt"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rb2);
            bg.add(this.rb3);
            bg.add(this.rb4);
            topPanel.add(Box.createVerticalStrut(10));
            JPanel rbPanel = new JPanel();
            rbPanel.setLayout(new BoxLayout(rbPanel, 1));
            rbPanel.add(this.rb2);
            rbPanel.add(this.rb3);
            rbPanel.add(this.rb4);
            JPanel rbPanel2 = new JPanel();
            rbPanel2.setLayout(new BoxLayout(rbPanel2, 0));
            rbPanel2.add(rbPanel);
            rbPanel2.add(Box.createHorizontalGlue());
            topPanel.add(rbPanel2);
            topPanel.add(Box.createVerticalStrut(20));
            JPanel p = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, 4);
                }

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, 4);
                }
            };
            p.setBorder(new BevelBorder(0));
            topPanel.add(p);
            topPanel.add(Box.createVerticalStrut(20));
            JPanel tPanel2 = new JPanel();
            tPanel2.setLayout(new BoxLayout(tPanel2, 0));
            this.homeTBLabel = new JLabel(ImplResourceManager.getString("Home Toolbox:"));
            tPanel2.add(this.homeTBLabel);
            tPanel2.add(Box.createHorizontalGlue());
            topPanel.add(tPanel2);
            JPanel topPanel2 = new JPanel();
            topPanel2.setLayout(new BoxLayout(topPanel2, 0));
            topPanel2.add(topPanel);
            topPanel2.add(Box.createHorizontalGlue());
            this.add(topPanel2);
            this.add(Box.createVerticalStrut(10));
            JPanel hPanel1 = new JPanel();
            hPanel1.setLayout(new BoxLayout(hPanel1, 0));
            this.locLabel = new JLabel(ImplResourceManager.getString("Location:"));
            hPanel1.add(this.locLabel);
            hPanel1.add(Box.createHorizontalStrut(10));
            this.locField = new JTextField(){

                public Dimension getMaximumSize() {
                    return new Dimension(super.getMaximumSize().width, super.getMinimumSize().height);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, super.getMinimumSize().height);
                }
            };
            hPanel1.add(this.locField);
            JPanel hPanel2 = new JPanel();
            hPanel2.setLayout(new BoxLayout(hPanel2, 0));
            hPanel2.add(Box.createHorizontalGlue());
            this.b1 = new JButton(ImplResourceManager.getString("Use Current Toolbox"));
            this.b1.setEnabled(false);
            this.b1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PreferencesPane.this.properties == null) {
                        return;
                    }
                    String value = PreferencesPane.this.properties.getProperty("vconsole.currenttoolbox");
                    if (value == null) {
                        ConsoleSheet.this.locField.setText("");
                    } else {
                        ConsoleSheet.this.locField.setText(value);
                    }
                }
            });
            this.b2 = new JButton(ImplResourceManager.getString("Browse..."));
            this.b2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConsoleSheet.this.promptUserForToolbox();
                }
            });
            hPanel2.add(this.b1);
            hPanel2.add(Box.createHorizontalStrut(10));
            hPanel2.add(this.b2);
            JPanel botPanel = new JPanel();
            botPanel.setLayout(new BorderLayout());
            botPanel.add((Component)hPanel1, "North");
            botPanel.add(Box.createVerticalStrut(10), "Center");
            botPanel.add((Component)hPanel2, "South");
            JPanel botPanel2 = new JPanel();
            botPanel2.setLayout(new BorderLayout());
            botPanel2.add((Component)botPanel, "North");
            this.add(botPanel2);
            this.add(Box.createVerticalGlue());
            this.setTitle(ImplResourceManager.getString("Console"));
            String help = ImplResourceManager.getString("ConsoleHelp");
            help = ContextHelpLoader.getContextHelp((String)help, null);
            this.setHelpHTML(help);
            this.updateFontAndColor();
        }

        protected void promptUserForToolbox() {
            if (this.chooser == null) {
                this.chooser = new ComboToolBoxChooser();
                this.chooser.setProperties(PreferencesPane.this.properties);
            }
            int result = this.chooser.showOpenDialog(null);
            if (result != -1) {
                URL u = this.chooser.getToolBoxURL();
                u = ConfigManagement.aliasifyURL(u);
                this.locField.setText(u.toString());
            }
        }

        protected void reflectValue1(String value) {
            if (value == null) {
                return;
            }
            if (value.equals("vconsole.hometoolbox")) {
                this.rb2.setSelected(true);
            } else if (value.equals("vconsole.lasttoolbox")) {
                this.rb3.setSelected(true);
            } else if (value.equals("vconsole.promptfortoolbox")) {
                this.rb4.setSelected(true);
            }
            this.validate();
            this.repaint();
        }

        protected void reflectValue2(String value) {
            if (value == null || value.equals("null")) {
                this.locField.setText("");
            } else {
                this.locField.setText(value);
            }
        }

        protected void reflectValue3(String value) {
            if (value == null || value.equals("null")) {
                this.b1.setEnabled(false);
            } else {
                this.b1.setEnabled(true);
            }
        }

        protected void updateFontAndColor() {
            this.locField.setFont(ResourceManager.bodyFont);
            this.locField.setForeground(ResourceManager.bodyColor);
            this.b1.setFont(ResourceManager.menuFont);
            this.b1.setForeground(ResourceManager.menuColor);
            this.b2.setFont(ResourceManager.menuFont);
            this.b2.setForeground(ResourceManager.menuColor);
            this.rb2.setFont(ResourceManager.menuFont);
            this.rb2.setForeground(ResourceManager.menuColor);
            this.rb3.setFont(ResourceManager.menuFont);
            this.rb3.setForeground(ResourceManager.menuColor);
            this.rb4.setFont(ResourceManager.menuFont);
            this.rb4.setForeground(ResourceManager.menuColor);
            this.startsLabel.setFont(ResourceManager.labelFont);
            this.startsLabel.setForeground(ResourceManager.labelColor);
            this.homeTBLabel.setFont(ResourceManager.labelFont);
            this.homeTBLabel.setForeground(ResourceManager.labelColor);
            this.locLabel.setFont(ResourceManager.labelFont);
            this.locLabel.setForeground(ResourceManager.labelColor);
        }

        public void reset() {
            if (PreferencesPane.this.properties == null) {
                return;
            }
            PreferencesPane.this.notify = false;
            String value = PreferencesPane.this.properties.getProperty("vconsole.toolloading");
            this.reflectValue1(value);
            value = PreferencesPane.this.properties.getProperty("vconsole.hometoolbox");
            this.reflectValue2(value);
            value = PreferencesPane.this.properties.getProperty("vconsole.currenttoolbox");
            this.reflectValue3(value);
            PreferencesPane.this.notify = true;
        }

        public void start() {
            this.updateFontAndColor();
            if (this.init || PreferencesPane.this.properties == null) {
                return;
            }
            try {
                PreferencesPane.this.properties.addPropertyChangeListener((PropertyChangeListener)this);
                String value = PreferencesPane.this.properties.getProperty("vconsole.loadonstartup");
                if (value == null) {
                    PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.promptfortoolbox");
                    value = "vconsole.promptfortoolbox";
                }
                this.reflectValue1(value);
                value = PreferencesPane.this.properties.getProperty("vconsole.hometoolbox");
                this.reflectValue2(value);
                value = PreferencesPane.this.properties.getProperty("vconsole.currenttoolbox");
                this.reflectValue3(value);
                this.init = true;
                this.rb2.addActionListener(PreferencesPane.this.actionL);
                this.rb3.addActionListener(PreferencesPane.this.actionL);
                this.rb4.addActionListener(PreferencesPane.this.actionL);
                this.locField.getDocument().addDocumentListener(PreferencesPane.this.documentL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean stop() {
            return true;
        }

        public boolean apply() {
            if (PreferencesPane.this.properties == null) {
                return true;
            }
            if (!this.init) {
                return true;
            }
            if (this.rb2.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.hometoolbox");
            } else if (this.rb3.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.lasttoolbox");
            } else if (this.rb4.isSelected()) {
                PreferencesPane.this.properties.setProperty("vconsole.loadonstartup", "vconsole.promptfortoolbox");
            }
            PreferencesPane.this.properties.setProperty("vconsole.hometoolbox", this.locField.getText());
            return true;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce == null) {
                return;
            }
            try {
                String key = pce.getPropertyName();
                String newValue = (String)pce.getNewValue();
                if (key == null) {
                    return;
                }
                PreferencesPane.this.notify = false;
                if (key.equals("vconsole.loadonstartup")) {
                    this.reflectValue1(newValue);
                } else if (key.equals("vconsole.hometoolbox")) {
                    this.reflectValue2(newValue);
                } else if (key.equals("vconsole.currenttoolbox")) {
                    this.reflectValue3(newValue);
                }
                PreferencesPane.this.notify = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

