/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.ConfigurationException;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Locale;

public class ConfigManagement {
    protected static String configDir = "toolboxes/";
    protected static String configDirAbs;
    protected static String configDirRemote;
    protected static Hashtable defaultConfigNames;

    private ConfigManagement() {
    }

    public static void add(String config, String id, Locale locale) throws ConfigurationException {
        try {
            File file = new File(ConfigManagement.getConfigPath(id, locale));
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(config.getBytes());
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to create configuration " + id, e);
        }
    }

    public static void delete(String id, Locale locale) throws ConfigurationException {
        File file = new File(ConfigManagement.getConfigPath(id, locale));
        file.delete();
    }

    public static URL getURL(String id, Locale locale) throws ConfigurationException {
        try {
            return new URL(ConfigManagement.getConfigURL(id, locale));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Failed to construct configuration URL for " + id, e);
        }
    }

    public static VConfigurationInfo[] list(Locale locale, boolean remote) throws ConfigurationException {
        File dir = new File(configDirAbs);
        String[] names = dir.list(new ConfigFilenameFilter(locale));
        VConfigurationInfo[] ids = names == null ? new VConfigurationInfo[]{} : new VConfigurationInfo[names.length];
        int failures = 0;
        for (int i = 0; i < ids.length; ++i) {
            try {
                URL url = new File(ConfigManagement.getConfigPath(names[i], locale)).toURL();
                VConfigurationInfo info = VBaseConfiguration.createConfiguration(url, false).getInfo();
                if (remote) {
                    info.setURL(new URL(ConfigManagement.getConfigURL(names[i], null)));
                }
                info.setId(names[i]);
                ids[i] = info;
                continue;
            }
            catch (MalformedURLException e) {
                ++failures;
                Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)("Failed to list configuration " + names[i]), (Throwable)e);
                continue;
            }
            catch (ConfigurationException e) {
                ++failures;
                Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)("Failed to list configuration " + names[i]), (Throwable)((Object)e));
            }
        }
        if (failures == 0) {
            return ids;
        }
        VConfigurationInfo[] newids = new VConfigurationInfo[ids.length - failures];
        int j = 0;
        for (int i = 0; i < ids.length && j < newids.length; ++i) {
            if (ids[i] == null) continue;
            newids[j++] = ids[i];
        }
        return newids;
    }

    public static VConfigurationInfo list(String id, Locale locale, boolean remote) throws ConfigurationException {
        try {
            URL url = remote ? new URL(ConfigManagement.getConfigURL(id, locale)) : new File(ConfigManagement.getConfigPath(id, locale)).toURL();
            VConfigurationInfo info = VBaseConfiguration.createConfiguration(url, false).getInfo();
            info.setId(id);
            return info;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to list configuration \"" + id + "\"", e);
        }
        catch (Throwable e) {
            throw new ConfigurationException("Failed to list configuration \"" + id + "\"");
        }
    }

    public static String getDefaultId(String context) throws ConfigurationException {
        return (String)defaultConfigNames.get(context);
    }

    public static String getDTDLocation(URL url) {
        if (url == null) {
            return ConfigManagement.getFileURL("toolbox.dtd");
        }
        if (!url.getProtocol().equals("http")) {
            return "file:" + System.getProperty("viper.home") + "/lib/dtds/toolbox.dtd";
        }
        if (configDirRemote != null) {
            return ConfigManagement.getFileURL("toolbox.dtd");
        }
        return url.getProtocol() + "://" + url.getHost() + (url.getPort() != -1 ? ":" + url.getPort() : "") + "/toolboxes/toolbox.dtd";
    }

    public static String getConfigPath(String name, Locale locale) {
        return configDirAbs + ConfigManagement.getFilename(name, locale);
    }

    public static String getConfigURL(String name, Locale locale) {
        return configDirRemote + ConfigManagement.getFilename(name, locale);
    }

    public static String getFilePath(String name) {
        return configDirAbs + name;
    }

    public static String getFileURL(String name) {
        return configDirRemote + name;
    }

    public static URL aliasifyURL(URL url) {
        URL ret;
        if (url == null || !url.toString().startsWith("http")) {
            return url;
        }
        String path = url.getFile();
        path = ConfigManagement.aliasifyPath(path);
        try {
            ret = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        catch (MalformedURLException e) {
            ret = url;
        }
        return ret;
    }

    public static URL unaliasifyURL(URL url) {
        URL ret;
        if (url == null || !url.toString().startsWith("http")) {
            return url;
        }
        String path = url.getFile();
        if (!ConfigManagement.isAliasedPath(path)) {
            return url;
        }
        path = ConfigManagement.unaliasifyPath(path);
        try {
            ret = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        catch (MalformedURLException e) {
            ret = url;
        }
        return ret;
    }

    protected static boolean isAliasedPath(String path) {
        if (path == null) {
            return false;
        }
        int fileIndex = path.lastIndexOf("/");
        if (fileIndex == -1) {
            return false;
        }
        String tbName = path.substring(fileIndex + 1);
        String tbPath = path.substring(0, fileIndex);
        int ext = tbName.indexOf(".tbx");
        if (ext == -1) {
            return false;
        }
        tbName = tbName.substring(0, ext);
        return !tbPath.endsWith(tbName);
    }

    public static String aliasifyPath(String path) {
        if (!path.endsWith(".tbx")) {
            return path;
        }
        path = path.substring(0, path.lastIndexOf(".tbx"));
        int index1 = -1;
        int index2 = path.lastIndexOf(47);
        String match1 = "";
        String match2 = path.substring(index2 + 1);
        if (index2 != -1 && (match1 = path.substring((index1 = path.lastIndexOf(47, index2 - 1)) + 1, index2)).equals(match2)) {
            path = path.substring(0, index2);
        }
        path = path + ".tbx";
        return path;
    }

    public static String unaliasifyPath(String path) {
        if (!path.endsWith(".tbx")) {
            return path;
        }
        path = path.substring(0, path.lastIndexOf(".tbx"));
        int index = path.lastIndexOf(47);
        String id = path.substring(index + 1);
        path = path + "/" + id + ".tbx";
        return path;
    }

    protected static String getFilename(VBaseConfiguration config, Locale locale) {
        return ConfigManagement.getFilename(config.getID(), locale);
    }

    protected static String getFilename(String id, Locale locale) {
        String country;
        int index = id.lastIndexOf(47);
        String base = "";
        if (index != -1) {
            base = id.substring(0, index) + "/";
            id = id.substring(index + 1);
        }
        if (locale == null) {
            return base + id + "/" + id + ".tbx";
        }
        int startLevel = 0;
        String variant = locale.getVariant();
        if (variant == null || variant.length() == 0) {
            ++startLevel;
        }
        if ((country = locale.getCountry()) == null || country.length() == 0) {
            ++startLevel;
        }
        String path = "";
        for (int level = startLevel; level < 5; ++level) {
            path = base + id + "/" + id + ConfigManagement.getLocaleSuffix(locale, level) + ".tbx";
            File file = new File(configDirAbs + path);
            if (file.exists()) break;
        }
        return path;
    }

    protected static String getLocaleSuffix(Locale locale, int level) {
        switch (level) {
            case 0: {
                return "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
            }
            case 1: {
                return "_" + locale.getLanguage() + "_" + locale.getCountry();
            }
            case 2: {
                return "_" + locale.getLanguage();
            }
            case 3: {
                return "_C";
            }
        }
        return "";
    }

    static {
        try {
            String viperHome = System.getProperty("viper.rthome");
            File dir = new File(viperHome + "/" + configDir);
            configDirAbs = dir.getAbsolutePath() + "/";
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    dir.delete();
                    dir.mkdir();
                } else {
                    dir.mkdirs();
                }
            }
            if (System.getProperty("viper.server.url") != null) {
                configDirRemote = System.getProperty("viper.server.url") + configDir;
            }
        }
        catch (AccessControlException e) {
            configDirAbs = null;
            configDirRemote = null;
        }
        defaultConfigNames = new Hashtable(3);
        defaultConfigNames.put("TC_APPLICATION_GUI", "this_computer");
        defaultConfigNames.put("TC_APPLICATION_NONGUI", "default_cli");
        defaultConfigNames.put("TC_APPLET_GUI", "default_applet");
    }

    protected static class ConfigFilenameFilter
    implements FilenameFilter {
        private Locale locale;

        public ConfigFilenameFilter(Locale locale) {
            this.locale = locale;
        }

        public boolean accept(File dir, String name) {
            File f;
            File d = new File(dir + "/" + name);
            return d.isDirectory() && (f = new File(dir + "/" + ConfigManagement.getFilename(name, this.locale))).exists();
        }
    }
}

