/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viperimpl.VSecurityManager;
import com.sun.management.viperimpl.console.CodeSourcePolicy;
import com.sun.management.viperimpl.console.PrivilegeManager;
import java.io.FileDescriptor;
import java.security.CodeSource;
import java.security.Policy;

public class CSecurityManager
extends VSecurityManager {
    protected PrivilegeManager privilegeManager = null;
    protected CodeSourcePolicy policy = null;

    public CSecurityManager() {
        Policy p = Policy.getPolicy();
        if (p instanceof CodeSourcePolicy) {
            this.policy = (CodeSourcePolicy)p;
        }
    }

    void setPrivilegeManager(PrivilegeManager pm) {
        this.privilegeManager = pm;
    }

    public void checkAccess(Thread t) {
    }

    public void checkAccess(ThreadGroup t) {
    }

    public void checkRead(FileDescriptor fd) {
        try {
            super.checkRead(fd);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkReadPrivilege(fd, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkRead(String file) {
        try {
            super.checkRead(file);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkReadPrivilege(file, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkRead(String file, Object context) {
        try {
            super.checkRead(file, context);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkReadPrivilege(file, context, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkWrite(FileDescriptor fd) {
        try {
            super.checkWrite(fd);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkWritePrivilege(fd, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkWrite(String file) {
        try {
            super.checkWrite(file);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkWritePrivilege(file, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkDelete(String file) {
        try {
            super.checkDelete(file);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkDeletePrivilege(file, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkExec(String cmd) {
        try {
            super.checkExec(cmd);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkExecPrivilege(cmd, this.getOffendingCodeSource());
            return;
        }
    }

    public void checkLink(String lib) {
        try {
            super.checkLink(lib);
            return;
        }
        catch (SecurityException securityException) {
            if (this.privilegeManager == null) {
                return;
            }
            this.privilegeManager.checkLinkPrivilege(lib, this.getOffendingCodeSource());
            return;
        }
    }

    protected CodeSource getOffendingCodeSource() {
        return this.policy == null ? null : this.policy.getFailedCodeSource();
    }
}

