/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.console.VConsole;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleManager;
import com.sun.management.viper.console.VConsoleModel;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.ThreadPool;
import com.sun.management.viperimpl.ToolInfrastructureImpl;
import com.sun.management.viperimpl.VDefaultToolContext;
import com.sun.management.viperimpl.client.ViperClient;
import com.sun.management.viperimpl.console.CSecurityManager;
import com.sun.management.viperimpl.console.ManagedCredentials;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.PrivilegeManager;
import com.sun.management.viperimpl.console.ToolPayload;
import com.sun.management.viperimpl.console.config.ConfigManagement;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VConfigurationInfo;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.management.viperimpl.services.authentication.client.AuthenticationClient;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class BaseConsoleManager
implements VConsoleManager {
    protected VConsole console = null;
    protected PrivilegeManager privilegeMgr = null;
    protected VConsoleModel dataModel = null;
    protected URL dataModelURL = null;
    protected ToolInfrastructure toolInf = null;
    protected Vector listeners = null;
    protected VConsoleProperties properties = null;
    private static boolean authenClientInited = false;
    protected Hashtable clientSet = null;
    protected Hashtable identitySet = null;
    protected Vector ignoreClientSet = null;
    protected static final String viperRMIloc = "Viper";
    protected Vector toolList = null;
    protected VBaseConfiguration currentConfig = null;
    protected boolean configHasChanged = false;
    protected static ThreadPool threadPool = null;
    protected int numToolsToLoad = 0;
    protected int numToolsLoaded = 0;
    protected static String localHost = null;
    protected static String baseCommand = null;
    protected static String toolContext = "TC_APPLICATION_NONGUI";
    protected ManagedCredentials initialAuthInfo = null;
    protected String initialHostName = null;
    protected String initialUserName = null;
    protected String initialPassword = null;
    protected String initialRoleName = null;
    protected String initialRolePassword = null;
    protected String initialToolBox = null;
    protected String initialTool = null;
    protected AdminMgmtScope initialScope = null;
    protected String[] initialToolOptions = null;
    protected boolean trusted = false;
    protected boolean yesToAll = false;
    protected boolean silent = false;
    protected InputStream inputS = null;
    protected PrintStream outputS = null;
    protected PrintStream errorS = null;
    protected static MessageFormat loadingToolbox = null;
    protected static MessageFormat loadingTool = null;
    protected static MessageFormat loginOK = null;
    protected static MessageFormat roleLoginOK = null;
    protected static MessageFormat toolLoadOK = null;
    protected static MessageFormat tbLoadOK = null;
    protected static MessageFormat loadMessage = null;
    protected static MessageFormat unknownError = null;
    protected static MessageFormat hostNotFound = null;
    protected static MessageFormat serverNotRunning = null;
    protected static MessageFormat toolNotFound = null;
    protected static MessageFormat locInfoNotFound = null;
    protected static MessageFormat invalidScope = null;
    protected static MessageFormat unsupportedScope = null;
    protected static MessageFormat unsupportedContext = null;
    protected static MessageFormat failedAuthentication = null;
    protected static MessageFormat failedInitialization = null;
    protected static MessageFormat canceledAuthentication = null;
    protected static MessageFormat tbLoadFailed = null;
    protected static MessageFormat tbRecursion = null;
    protected VScopeNode selNode = null;

    public BaseConsoleManager() {
        if (localHost == null) {
            try {
                localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable t) {
                Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unable to determine local host", (Throwable)t);
            }
        }
        if (threadPool == null) {
            threadPool = new ThreadPool(10, 25);
            Debug.trace((String)"BaseConsoleManager", (int)Debug.INFORMATION, (String)"ThreadPool initialized: 10 initial, 25 max", null);
            try {
                loadingToolbox = new MessageFormat(ImplResourceManager.getString("Loading Toolbox: {0}"));
                loadingTool = new MessageFormat(ImplResourceManager.getString("Loading Tool: {0} from {1}"));
                loginOK = new MessageFormat(ImplResourceManager.getString("Login to {0} as user {1} was successful."));
                roleLoginOK = new MessageFormat(ImplResourceManager.getString("Login to {0} as user {1}, role {2} was successful."));
                toolLoadOK = new MessageFormat(ImplResourceManager.getString("Download of {0} from {1} was successful."));
                tbLoadOK = new MessageFormat(ImplResourceManager.getString("Toolbox: {0} successfully loaded."));
                tbRecursion = new MessageFormat(ImplResourceManager.getString("TBRecursion"));
                baseCommand = System.getProperty("viper.argv0");
                if (baseCommand == null) {
                    baseCommand = "smc";
                }
            }
            catch (Throwable t) {
                Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Error in MessageFormatters", (Throwable)t);
            }
        }
        if (!authenClientInited) {
            try {
                AuthenticationClient.init(null);
                authenClientInited = true;
            }
            catch (AuthenticationException ae) {
                Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Couldn't init auth client", (Throwable)ae);
            }
        }
    }

    public void setInitialOptions(String initialHostName, String initialUserName, String initialPassword, String initialRoleName, String initialRolePassword, String initialToolBox, String initialTool, AdminMgmtScope initialScope, String[] initialToolOptions, boolean trusted, boolean yesToAll, boolean silent, InputStream input, PrintStream output, PrintStream error) {
        this.initialHostName = initialHostName;
        this.initialUserName = initialUserName;
        this.initialPassword = initialPassword;
        this.initialRoleName = initialRoleName;
        this.initialRolePassword = initialRolePassword;
        this.initialToolBox = initialToolBox;
        this.initialTool = initialTool;
        this.initialScope = initialScope;
        this.initialToolOptions = initialToolOptions;
        this.trusted = trusted;
        this.yesToAll = yesToAll;
        this.silent = silent;
        this.inputS = input;
        this.outputS = output;
        this.errorS = error;
    }

    public void init(VConsole console, ToolInfrastructure tInf) {
        this.console = console;
        this.toolInf = tInf;
    }

    public void setProperties(VConsoleProperties properties) {
        this.properties = properties;
    }

    protected void notifyListeners(VConsoleEvent vce) {
        if (this.listeners == null || vce == null) {
            return;
        }
        for (int x = 0; x < this.listeners.size(); ++x) {
            try {
                VConsoleActionListener l = (VConsoleActionListener)this.listeners.elementAt(x);
                l.consoleAction(vce);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyLog(VLogEvent e) {
        VConsoleEvent vce = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)e);
        this.notifyListeners(vce);
    }

    protected void setPrivilegeManager() {
        if (this.privilegeMgr == null) {
            return;
        }
        try {
            SecurityManager sManager = System.getSecurityManager();
            if (sManager instanceof CSecurityManager) {
                CSecurityManager cManager = (CSecurityManager)sManager;
                cManager.setPrivilegeManager(this.privilegeMgr);
                Debug.trace((String)"ConsoleManager", (int)Debug.INFORMATION, (String)"PrivilegeManager established", null);
            }
        }
        catch (Throwable t) {
            Debug.trace((String)"ConsoleManager", (int)Debug.WARNING, (String)"No Privilege Manager set", (Throwable)t);
        }
    }

    public void consoleAction(VConsoleEvent vce) {
        if (vce == null) {
            return;
        }
        String eventID = vce.getID();
        try {
            VScopeNode viewNode;
            Object o;
            if (eventID.equals("vconsole.scopeselected")) {
                this.selNode = (VScopeNode)vce.getPayload();
                this.updateIdentity(this.selNode);
                if (this.selNode == null) {
                    return;
                }
                Object o2 = this.selNode.getPayload();
                if (o2 instanceof ToolPayload) {
                    this.loadToolForStub(this.selNode, true);
                }
            } else if (eventID.equals("vconsole.scopechildopened") && (o = (viewNode = (VScopeNode)vce.getPayload()).getPayload()) instanceof ToolPayload) {
                this.loadToolForStub(viewNode, true);
            }
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)t);
        }
    }

    protected void updateIdentity(VScopeNode node) {
        if (node == null) {
            this.setIdentity("");
            return;
        }
        try {
            while (node != null) {
                if (this.identitySet.containsKey(node)) {
                    this.setIdentity(this.identitySet.get(node));
                    return;
                }
                node = (VScopeNode)node.getParent();
            }
            this.setIdentity("");
        }
        catch (Throwable t) {
            this.setIdentity("");
        }
    }

    protected void setIdentity(Object identity) {
        this.properties.setPropertyObject("vconsole.useridentity", identity);
    }

    public void shutDown() {
        this.shutDownLoadedTools();
    }

    protected void shutDownLoadedTools() {
        if (this.toolList != null) {
            for (int x = 0; x < this.toolList.size(); ++x) {
                try {
                    Tool tool = (Tool)this.toolList.elementAt(x);
                    tool.destroy();
                    continue;
                }
                catch (Throwable e) {
                    Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Problem stopping or destroying tool", (Throwable)e);
                }
            }
        }
        this.toolList = new Vector();
    }

    public void destroy() {
        this.closeAuthenticatedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAuthenticatedSessions() {
        if (this.clientSet == null) {
            return;
        }
        Hashtable hashtable = this.clientSet;
        synchronized (hashtable) {
            Enumeration e = this.clientSet.keys();
            while (e.hasMoreElements()) {
                try {
                    String key = (String)e.nextElement();
                    ViperClient vc = (ViperClient)this.clientSet.get(key);
                    if (vc.getIdentity() == null) continue;
                    vc.logout();
                    this.clientSet.remove(key);
                }
                catch (Throwable t) {
                    Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Problem in ViperClient.logout()", (Throwable)t);
                }
            }
        }
    }

    protected void initializeClientSet() {
        if (this.clientSet == null) {
            this.clientSet = new Hashtable();
        }
    }

    protected void initializeIgnoreClientSet() {
        this.ignoreClientSet = new Vector();
    }

    protected void initializeIdentitySet() {
        this.identitySet = new Hashtable();
    }

    public void addConsoleActionListener(VConsoleActionListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (listener != null) {
            this.listeners.addElement(listener);
        }
    }

    public void openConsole() throws Exception {
        this.openConsole(null);
    }

    public void openConsole(String toolboxName) throws Exception {
        this.properties.setProperty("vconsole.working", "true");
        URL tbURL = null;
        boolean shouldWarn = false;
        if (toolboxName != null) {
            try {
                tbURL = new URL(toolboxName);
                shouldWarn = true;
            }
            catch (Exception e) {
                this.warnUserOfFailedToolbox(toolboxName, e);
                this.cancelOpenConsole(toolboxName, e);
            }
        } else {
            tbURL = this.promptUserForToolbox();
            if (tbURL == null) {
                this.cancelOpenConsole(null, null);
            }
        }
        this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)loadingToolbox.format(new Object[]{tbURL.toString()})));
        VBaseConfiguration toolbox = null;
        try {
            tbURL = ConfigManagement.unaliasifyURL(tbURL);
            toolbox = VBaseConfiguration.createConfiguration(tbURL, ResourceManager.currentLocale);
            tbURL = ConfigManagement.aliasifyURL(tbURL);
        }
        catch (Throwable t) {
            tbURL = ConfigManagement.aliasifyURL(tbURL);
            if (shouldWarn) {
                this.warnUserOfFailedToolbox(tbURL.toString(), t);
            }
            Debug.trace((String)"GUI Console Manager", (int)Debug.WARNING, (String)"Problem in open console", (Throwable)t);
            this.cancelOpenConsole(tbURL.toString(), t);
        }
        this.shutDown();
        this.destroy();
        this.initializeClientSet();
        this.initializeIgnoreClientSet();
        this.initializeIdentitySet();
        this.initialAuthInfo = null;
        this.dataModelURL = tbURL;
        this.numToolsLoaded = 0;
        this.numToolsToLoad = 0;
        this.dataModel = new VConsoleModel(this.buildConfiguration(toolbox, null));
        this.dataModel.setProperties(this.properties);
        this.properties.setProperty("vconsole.currenttoolbox", tbURL.toString());
        this.properties.setProperty("vconsole.lasttoolbox", tbURL.toString());
        this.notifyLog(new VLogEvent((Object)this, 10, new Date(), ImplResourceManager.getString("Toolbox Load Successful"), tbLoadOK.format(new Object[]{tbURL.toString()}), ImplResourceManager.getString("ToolboxSuccess"), null, null));
        if (this.numToolsToLoad == 0) {
            this.establishConsoleModel();
        }
        this.currentConfig = toolbox;
    }

    protected void establishConsoleModel() {
        if (baseCommand != null && this.dataModelURL != null) {
            this.establishWindowCommand(baseCommand + " -B " + this.dataModelURL.toString());
        }
        this.console.setModel(this.dataModel);
        this.ignoreClientSet = null;
        this.properties.setProperty("vconsole.working", "false");
        this.properties.setProperty("vconsole.saveconsoleenabled", "false");
        this.properties.setPropertyObject("vconsole.useridentity", new Object());
        this.configHasChanged = false;
    }

    protected void cancelOpenConsole(String failedBox, Throwable t) throws Exception {
        this.properties.setProperty("vconsole.working", "false");
        String currentTB = this.properties.getProperty("vconsole.currenttoolbox");
        if (currentTB == null || currentTB.equals("null")) {
            this.properties.setProperty("vconsole.currenttoolbox", "");
        } else {
            this.properties.setProperty("vconsole.currenttoolbox", currentTB);
        }
        if (failedBox != null) {
            this.warnUserOfFailedToolbox(failedBox, t);
        }
        throw new Exception("Could not load console.");
    }

    public Tool openTool() throws Exception {
        return this.openTool(null, null);
    }

    public Tool openTool(String toolClass, String host) throws Exception {
        ViperClient client;
        if (host == null) {
            host = this.initialHostName != null ? this.initialHostName : localHost;
        }
        if (toolClass == null) {
            toolClass = this.promptUserForTool(host);
        }
        if ((client = this.getAuthViperClient(host)) == null) {
            return null;
        }
        Tool tool = client.getToolByName(toolClass);
        return tool;
    }

    protected VScopeNode buildConfiguration(VBaseConfiguration config, String scopeOverride) {
        VScopeNode rootNode = null;
        try {
            VConfigurationInfo configInfo = config.getInfo();
            URL u = ConfigManagement.aliasifyURL(configInfo.getURL());
            VConfigurationNode rootConfig = config.getRootNode();
            if (rootConfig == null) {
                return null;
            }
            if (scopeOverride != null) {
                rootConfig.setScope(scopeOverride);
            }
            rootNode = ManagerUtility.createScopeNodeFor(rootConfig);
            rootNode.setPayload((Object)rootConfig);
            rootNode.setUserObject((Object)u);
            Enumeration e = rootConfig.children();
            while (e.hasMoreElements()) {
                VConfigurationNode child = (VConfigurationNode)e.nextElement();
                this.processChildNode(rootNode, child);
            }
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error building model", (Throwable)t);
            return null;
        }
        return rootNode;
    }

    protected void notifyOfRecursion(VScopeNode parent, URL tbURL) {
        if (parent == null || tbURL == null) {
            return;
        }
        this.notifyLog(new VLogEvent((Object)this, 20, new Date(), ImplResourceManager.getString("Toolbox Recursion"), ImplResourceManager.getString("Toolbox previously loaded"), tbRecursion.format(new Object[]{tbURL.toString(), parent.getText()}), null, null));
    }

    protected void processChildNode(VScopeNode parent, VConfigurationNode child) {
        if (parent == null || child == null) {
            return;
        }
        try {
            if (child instanceof ToolBoxURLNode) {
                URL u = ((ToolBoxURLNode)child).getURL();
                u = ConfigManagement.aliasifyURL(u);
                VScopeNode ancestor = parent;
                while (ancestor != null) {
                    Object o = ancestor.getUserObject();
                    if (o == null || !(o instanceof URL)) {
                        ancestor = (VScopeNode)ancestor.getParent();
                        continue;
                    }
                    URL ancestorURL = (URL)o;
                    if (u.sameFile(ancestorURL)) {
                        this.notifyOfRecursion(parent, u);
                        return;
                    }
                    ancestor = (VScopeNode)ancestor.getParent();
                }
                u = ConfigManagement.unaliasifyURL(u);
                VBaseConfiguration config = VBaseConfiguration.createConfiguration(u, ResourceManager.currentLocale);
                VScopeNode tbNode = this.buildConfiguration(config, child.getScope());
                if (child.getName() != null) {
                    tbNode.setText(child.getName());
                }
                if (child.getDescription() != null) {
                    tbNode.setDescription(child.getDescription());
                }
                if (child.getSmallIcon() != null) {
                    tbNode.setSmallIcon(new ImageIcon(child.getSmallIcon()));
                }
                if (child.getLargeIcon() != null) {
                    tbNode.setLargeIcon(new ImageIcon(child.getLargeIcon()));
                }
                ManagerUtility.setBackgroundImage(child, tbNode);
                ManagerUtility.addChildToParent(child, parent, tbNode);
            } else if (child instanceof ToolNode) {
                this.processToolNode((ToolNode)child, parent);
            } else {
                VScopeNode childNode = ManagerUtility.createScopeNodeFor(child);
                Enumeration e = child.children();
                ManagerUtility.addChildToParent(child, parent, childNode);
                while (e.hasMoreElements()) {
                    VConfigurationNode cNode = (VConfigurationNode)e.nextElement();
                    this.processChildNode(childNode, cNode);
                }
            }
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.WARNING, (String)"Unexpected error", (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ViperClient getAuthViperClient(String host) throws Exception {
        ViperClient stubClient;
        ViperClient viperClient = stubClient = this.getStubViperClient(host);
        synchronized (viperClient) {
            if (stubClient.getIdentity() != null) {
                return stubClient;
            }
            if (this.ignoreClientSet != null && this.ignoreClientSet.contains(stubClient)) {
                return null;
            }
            int port = ManagerUtility.parsePortFromString(host);
            host = ManagerUtility.parseHostFromString(host);
            ManagedCredentials authInfo = null;
            if (this.initialAuthInfo == null) {
                if (this.initialUserName != null && this.initialPassword != null) {
                    boolean shouldSu = this.initialRoleName != null && this.initialRolePassword != null;
                    authInfo = new ManagedCredentials(host, port, this.initialUserName, this.initialPassword, this.initialRoleName, this.initialRolePassword, shouldSu);
                } else {
                    authInfo = this.promptUserForAuthInfo(host, port, null, false);
                }
            } else {
                String authPreference = this.properties.getProperty("vconsole.authpreference");
                authInfo = authPreference.equals("vconsole.alwaysuseinitial") ? new ManagedCredentials(host, port, this.initialAuthInfo.getName(), this.initialAuthInfo.getCredential(), this.initialAuthInfo.getRoleName(), this.initialAuthInfo.getRoleCredential(), this.initialAuthInfo.shouldAssumeRole()) : this.promptUserForAuthInfo(host, port, null, false);
            }
            if (authInfo == null) {
                if (this.ignoreClientSet != null) {
                    this.ignoreClientSet.addElement(stubClient);
                }
                return null;
            }
            boolean loginSuccess = this.handleAuthentication(stubClient, authInfo);
            if (!loginSuccess) {
                if (this.ignoreClientSet != null) {
                    this.ignoreClientSet.addElement(stubClient);
                }
                return null;
            }
            if (this.initialAuthInfo == null && authInfo != null) {
                this.initialAuthInfo = authInfo;
            }
            VIdentity identity = stubClient.getIdentity();
            VLogEvent authLog = new VLogEvent((Object)this, 10, new Date(), ImplResourceManager.getString("Authentication Successful"), null, ImplResourceManager.getString("AuthSuccess"), null, null);
            if (!identity.isInRole()) {
                authLog.setMessage(loginOK.format(new Object[]{identity.getAuthenHost(), identity.getName()}));
            } else {
                authLog.setMessage(roleLoginOK.format(new Object[]{identity.getAuthenHost(), identity.getPrimaryName(), identity.getName()}));
            }
            this.notifyLog(authLog);
        }
        return stubClient;
    }

    protected boolean handleAuthentication(ViperClient client, ManagedCredentials authInfo) throws Exception {
        boolean primary = this.handlePrimaryLogin(client, authInfo);
        if (!primary) {
            return false;
        }
        return this.handleRoleLogin(client, authInfo);
    }

    protected boolean handlePrimaryLogin(ViperClient client, ManagedCredentials authInfo) throws Exception {
        boolean notifyUser = false;
        boolean retryLogin = true;
        String notify = this.properties.getProperty("vconsole.promptonfailure");
        notifyUser = notify.equals("true");
        int retryThreshold = 5;
        int numberOfTries = 0;
        while (retryLogin) {
            try {
                ++numberOfTries;
                client.login(authInfo);
                retryLogin = false;
            }
            catch (Exception e) {
                if (!notifyUser) {
                    throw e;
                }
                retryLogin = this.promptUserToRetryLogin(authInfo.getHostName(), numberOfTries == retryThreshold);
                if (numberOfTries == retryThreshold) {
                    throw e;
                }
                if (!retryLogin) {
                    return false;
                }
                if ((authInfo = this.promptUserForAuthInfo(authInfo.getHostName(), authInfo.getPort(), null, true)) != null) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean handleRoleLogin(ViperClient client, ManagedCredentials authInfo) throws Exception {
        if (authInfo.getRoleName() != null && authInfo.getRoleCredential() != null) {
            return true;
        }
        if (!authInfo.shouldAssumeRole()) {
            return true;
        }
        VIdentity[] roleList = client.getRoles();
        if (roleList == null || roleList.length == 0) {
            return true;
        }
        if ((authInfo = this.promptUserForRoleInfo(authInfo, null, roleList, false)) == null) {
            return false;
        }
        if (authInfo.getRoleName() == null) {
            authInfo.setShouldAssumeRole(false);
            return true;
        }
        boolean notifyUser = false;
        boolean retryLogin = true;
        String notify = this.properties.getProperty("vconsole.promptonfailure");
        notifyUser = notify.equals("true");
        int retryThreshold = 5;
        int numberOfTries = 0;
        while (retryLogin) {
            try {
                ++numberOfTries;
                client.assumeRole(authInfo);
                retryLogin = false;
            }
            catch (Exception e) {
                if (!notifyUser) {
                    throw e;
                }
                retryLogin = this.promptUserToRetryLogin(authInfo.getHostName(), numberOfTries == retryThreshold);
                if (numberOfTries == retryThreshold) {
                    throw e;
                }
                if (!retryLogin) {
                    return false;
                }
                if ((authInfo = this.promptUserForRoleInfo(authInfo, null, roleList, true)) == null) {
                    return false;
                }
                if (authInfo.shouldAssumeRole()) continue;
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ViperClient getStubViperClient(String host) throws UnknownHostException, RemoteException, VException {
        int port = ManagerUtility.parsePortFromString(host);
        host = ManagerUtility.parseHostFromString(host);
        if (port <= 0) {
            port = 898;
        }
        InetAddress iAddr = InetAddress.getByName(host);
        String hashKey = iAddr.getHostAddress() + ":" + port;
        Hashtable hashtable = this.clientSet;
        synchronized (hashtable) {
            if (this.clientSet.containsKey(hashKey)) {
                return (ViperClient)this.clientSet.get(hashKey);
            }
            ViperClient stubClient = new ViperClient(host, port);
            this.clientSet.put(hashKey, stubClient);
            return stubClient;
        }
    }

    protected void processToolNode(ToolNode child, VScopeNode parent) {
        try {
            boolean stubOnly = true;
            String toolLoading = this.properties.getProperty("vconsole.toolloading");
            boolean userWantsToLoad = toolLoading.equals("vconsole.loadbeforedisplay");
            boolean tbWantsToLoad = child.isAutoLoad();
            String override = this.properties.getProperty("vconsole.overridetoolbox");
            boolean userOverride = override.equals("true");
            stubOnly = userWantsToLoad == tbWantsToLoad ? !userWantsToLoad : (tbWantsToLoad ? (userOverride ? !userWantsToLoad : !tbWantsToLoad) : !userWantsToLoad);
            StubLoader sl = new StubLoader(child, parent, stubOnly);
            ++this.numToolsToLoad;
            threadPool.run((Runnable)sl);
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Unexpected error loading tool stub", (Throwable)t);
        }
    }

    protected void loadToolForStub(VScopeNode stubNode, boolean selectWhenDone) {
        try {
            VScopeNode parent = (VScopeNode)stubNode.getParent();
            if (stubNode == null || parent == null) {
                this.properties.setProperty("vconsole.working", "true");
                return;
            }
            ClickLoader cl = new ClickLoader(parent, stubNode, selectWhenDone);
            threadPool.run((Runnable)cl);
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleManager", (int)Debug.ERROR, (String)"Unexpected error loading tool", (Throwable)t);
        }
    }

    protected ViperClient handleStubClient(String host, String className, ToolNode child, VScopeNode parent) throws Throwable {
        ViperClient stubClient = null;
        try {
            stubClient = this.getStubViperClient(host);
            return stubClient;
        }
        catch (UnknownHostException e) {
            this.noServerFound(className, host, child, parent, e);
            throw e;
        }
        catch (RemoteException e) {
            this.noServerRunningOnHost(host, child, parent, e);
            throw e;
        }
        catch (Throwable t) {
            this.unexpectedException(className, child, parent, t);
            throw t;
        }
    }

    protected ToolInfo handleToolInfo(ViperClient stubClient, String className, ToolNode child, VScopeNode parent) throws Throwable {
        ToolInfo childInfo = null;
        try {
            childInfo = stubClient.getToolInfo(className);
            return childInfo;
        }
        catch (Throwable t) {
            this.toolNotFoundOnServer(className, child, parent, t);
            throw t;
        }
    }

    protected VLocalizedInfo handleLocalizedToolInfo(ViperClient stubClient, String className, ToolInfo toolInfo, ToolNode child, VScopeNode parent) throws Throwable {
        VLocalizedInfo locInfo = null;
        try {
            locInfo = stubClient.getLocalizedInfo(toolInfo.getResourceBaseName(), ResourceManager.currentLocale);
            return locInfo;
        }
        catch (Throwable t) {
            this.toolDoesNotHaveLocalizedInfo(className, child, toolInfo, parent, t);
            throw t;
        }
    }

    protected AdminMgmtScope handleMgmtScope(String scope, String host, ToolNode child, VLocalizedInfo locInfo, VScopeNode parent) throws Throwable {
        AdminMgmtScope childScope = null;
        try {
            childScope = scope != null ? new AdminMgmtScope(null, scope) : new AdminMgmtScope("file", null, host, null);
            return childScope;
        }
        catch (Throwable t) {
            this.invalidScopeForTool(child, locInfo, parent, scope, t);
            throw t;
        }
    }

    protected void handleSupportedContext(String className, ToolNode child, ToolInfo toolInfo, VLocalizedInfo locInfo, VScopeNode parent, String toolContext) throws Throwable {
        if (!ManagerUtility.toolSupportsContext(toolInfo, toolContext)) {
            this.toolDoesNotSupportContext(className, child, locInfo, parent, toolContext, null);
            throw new Exception();
        }
    }

    protected void handleSupportedScope(String className, ToolNode child, ToolInfo toolInfo, VLocalizedInfo locInfo, VScopeNode parent, AdminMgmtScope childScope) throws Throwable {
        if (!ManagerUtility.toolSupportsScope(toolInfo, childScope)) {
            this.toolDoesNotSupportScope(className, child, locInfo, parent, childScope, null);
            throw new Exception();
        }
    }

    protected Tool handleLoadTool(String className, String host, VScopeNode stubNode) throws Throwable {
        Tool tool = null;
        try {
            String messageText = className;
            if (stubNode != null) {
                messageText = stubNode.getText();
            }
            this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)loadingTool.format(new Object[]{messageText, host})));
            tool = this.openTool(className, host);
        }
        catch (Throwable t) {
            this.authenticationFailedForTool(host, stubNode, t);
            throw t;
        }
        if (tool == null) {
            this.userCanceledAuthenticationForTool(host, stubNode);
            throw new Exception("User Cancelled");
        }
        this.notifyLog(new VLogEvent((Object)this, 10, new Date(), ImplResourceManager.getString("Tool Download Successful"), toolLoadOK.format(new Object[]{className, host}), ImplResourceManager.getString("DownloadSuccess"), null, null));
        return tool;
    }

    protected void handleToolInitialization(Tool tool, ToolInfo toolInfo, AdminMgmtScope scope, Properties parameters, ViperClient client, String className, VScopeNode stubNode) throws Throwable {
        try {
            this.initializeTool(tool, toolInfo, scope, parameters, client);
        }
        catch (Throwable t) {
            this.toolInitializationFailed(className, stubNode, t);
            throw t;
        }
    }

    protected void initializeTool(Tool tool, ToolInfo toolInfo, AdminMgmtScope scope, Properties toolParameters, ViperClient client) throws Exception {
        if (toolInfo == null || tool == null || scope == null || client == null) {
            return;
        }
        VDefaultToolContext context = new VDefaultToolContext(toolContext, scope, toolParameters, toolInfo.getProperties());
        tool.setToolContext((ToolContext)context);
        tool.setProperties(this.properties);
        tool.addConsoleActionListener((VConsoleActionListener)this.console);
        if (tool instanceof VConsoleActionListener && this.console != null) {
            this.console.addConsoleActionListener((VConsoleActionListener)tool);
        }
        tool.init((ToolInfrastructure)new ToolInfrastructureImpl(client));
        if (this.toolList == null) {
            this.toolList = new Vector();
        }
        this.toolList.addElement(tool);
    }

    protected String getToolHost(ToolNode child) {
        if (child == null) {
            return null;
        }
        String host = child.getServerName();
        int port = child.getServerPort();
        if (host == null || host.length() == 0) {
            host = localHost;
        }
        if (port < 0) {
            port = 898;
        }
        return host + ":" + port;
    }

    protected void loadToolAndReplaceStub(VScopeNode parent, VScopeNode stubNode, boolean selectWhenDone) {
        if (parent == null || stubNode == null) {
            throw new IllegalArgumentException("Null input to loadToolAndReplaceStub");
        }
        try {
            ToolPayload toolPayload = (ToolPayload)stubNode.getPayload();
            ToolNode child = toolPayload.getToolNode();
            VScopeNode stubParent = null;
            if (this.selNode != null) {
                stubParent = (VScopeNode)this.selNode.getParent();
            }
            Tool tool = this.handleLoadTool(child.getClassName(), this.getToolHost(child), stubNode);
            this.handleToolInitialization(tool, toolPayload.getInfo(), toolPayload.getScope(), child.getParameters(), toolPayload.getClient(), child.getClassName(), stubNode);
            VScopeNode childNode = this.addToolToParent(child, tool, parent, stubNode);
            this.identitySet.put(childNode, toolPayload.getClient().getIdentity());
            if (childNode.getChildCount() > 0) {
                this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)childNode));
            }
            this.loadOnlineHelpForTool(tool, toolPayload.getInfo());
            if (selectWhenDone) {
                VConsoleEvent evt = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)childNode);
                if (!childNode.isNodeRelated((DefaultMutableTreeNode)stubParent)) {
                    evt.setID("vconsole.scopechildopened");
                }
                this.notifyListeners(evt);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public abstract int saveConsole();

    public abstract int saveConsoleAs();

    public abstract void editConsole();

    protected abstract String promptUserForTool(String var1);

    protected abstract URL promptUserForToolbox();

    protected abstract ManagedCredentials promptUserForAuthInfo(String var1, int var2, String var3, boolean var4);

    protected abstract ManagedCredentials promptUserForRoleInfo(ManagedCredentials var1, String var2, VIdentity[] var3, boolean var4);

    protected abstract boolean promptUserToRetryLogin(String var1, boolean var2);

    protected abstract void unexpectedException(String var1, VConfigurationNode var2, VScopeNode var3, Throwable var4);

    protected abstract void noServerFound(String var1, String var2, ToolNode var3, VScopeNode var4, Throwable var5);

    protected abstract void noServerRunningOnHost(String var1, ToolNode var2, VScopeNode var3, Throwable var4);

    protected abstract void toolNotFoundOnServer(String var1, ToolNode var2, VScopeNode var3, Throwable var4);

    protected abstract void toolDoesNotHaveLocalizedInfo(String var1, ToolNode var2, ToolInfo var3, VScopeNode var4, Throwable var5);

    protected abstract void invalidScopeForTool(ToolNode var1, VLocalizedInfo var2, VScopeNode var3, String var4, Throwable var5);

    protected abstract void toolDoesNotSupportScope(String var1, ToolNode var2, VLocalizedInfo var3, VScopeNode var4, AdminMgmtScope var5, Throwable var6);

    protected abstract void toolDoesNotSupportContext(String var1, ToolNode var2, VLocalizedInfo var3, VScopeNode var4, String var5, Throwable var6);

    protected abstract void authenticationFailedForTool(String var1, VScopeNode var2, Throwable var3);

    protected abstract void userCanceledAuthenticationForTool(String var1, VScopeNode var2);

    protected abstract void toolInitializationFailed(String var1, VScopeNode var2, Throwable var3);

    protected abstract VScopeNode addToolStubToParent(ToolNode var1, VScopeNode var2, VLocalizedInfo var3);

    protected abstract VScopeNode addToolToParent(ToolNode var1, Tool var2, VScopeNode var3, VScopeNode var4);

    protected abstract void loadOnlineHelpForTool(Tool var1, ToolInfo var2);

    protected abstract void establishWindowCommand(String var1);

    protected abstract void warnUserOfFailedToolbox(String var1, Throwable var2);

    class ClickLoader
    implements Runnable {
        protected VScopeNode parent = null;
        protected VScopeNode stubNode = null;
        protected boolean selectWhenDone = false;

        public ClickLoader(VScopeNode parent, VScopeNode stubNode, boolean selectWhenDone) {
            if (parent == null || stubNode == null) {
                throw new IllegalArgumentException("Null input to ClickLoader");
            }
            this.parent = parent;
            this.stubNode = stubNode;
            this.selectWhenDone = selectWhenDone;
        }

        public void run() {
            BaseConsoleManager.this.properties.setProperty("vconsole.working", "true");
            try {
                BaseConsoleManager.this.loadToolAndReplaceStub(this.parent, this.stubNode, this.selectWhenDone);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            BaseConsoleManager.this.properties.setProperty("vconsole.working", "false");
        }
    }

    class StubLoader
    implements Runnable {
        protected ToolNode child = null;
        protected VScopeNode parent = null;
        protected boolean stubOnly = true;

        public StubLoader(ToolNode child, VScopeNode parent, boolean stubOnly) throws RuntimeException, IllegalArgumentException {
            if (parent == null || child == null) {
                throw new IllegalArgumentException("Null input to StubLoader");
            }
            this.child = child;
            this.parent = parent;
            this.stubOnly = stubOnly;
        }

        public void run() {
            try {
                String host = BaseConsoleManager.this.getToolHost(this.child);
                ViperClient stubClient = BaseConsoleManager.this.handleStubClient(host, this.child.getClassName(), this.child, this.parent);
                ToolInfo childInfo = BaseConsoleManager.this.handleToolInfo(stubClient, this.child.getClassName(), this.child, this.parent);
                VLocalizedInfo locInfo = BaseConsoleManager.this.handleLocalizedToolInfo(stubClient, this.child.getClassName(), childInfo, this.child, this.parent);
                AdminMgmtScope childScope = BaseConsoleManager.this.handleMgmtScope(this.child.getScope(), host, this.child, locInfo, this.parent);
                BaseConsoleManager.this.handleSupportedContext(this.child.getClassName(), this.child, childInfo, locInfo, this.parent, toolContext);
                BaseConsoleManager.this.handleSupportedScope(this.child.getClassName(), this.child, childInfo, locInfo, this.parent, childScope);
                VScopeNode stubNode = BaseConsoleManager.this.addToolStubToParent(this.child, this.parent, locInfo);
                ToolPayload toolPayload = new ToolPayload(this.child, childInfo, locInfo, childScope, stubClient);
                stubNode.setPayload((Object)toolPayload);
                if (!this.stubOnly) {
                    BaseConsoleManager.this.loadToolAndReplaceStub(this.parent, stubNode, false);
                }
            }
            catch (Throwable t) {
                Debug.trace((String)"StubLoader", (int)Debug.ERROR, (String)"Unexpected throwable in StubLoader", (Throwable)t);
            }
            ++BaseConsoleManager.this.numToolsLoaded;
            if (BaseConsoleManager.this.numToolsLoaded >= BaseConsoleManager.this.numToolsToLoad) {
                BaseConsoleManager.this.establishConsoleModel();
            }
        }
    }
}

