/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.client;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.BeanNotFoundException;
import com.sun.management.viper.ExternalClientProvider;
import com.sun.management.viper.InfrastructureException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceContext;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ServiceProxy;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VLocalizedInfo;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationInfo;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceContextImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfrastructureImpl;
import com.sun.management.viperimpl.UserInfo;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.Viper;
import com.sun.management.viperimpl.client.ToolAgentManager;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticationRequest;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.client.AuthenticationClient;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;

public final class ViperClient
implements ToolInfrastructure,
AuthenticationRequest {
    public final int SMC_BEAN_COMPONENT = 0;
    public final int SMC_EXE_COMPONENT = 1;
    private static final String PN_VIPER_HOME = "viper.home";
    private static final String REMOTE_REGISTRY_VIPER = "/remoteregistry/_viper/_vstub";
    private static final String Default_Home = "/usr/sadm/lib/smc";
    public static final int DEFAULT_PORT = 898;
    private String viperHome = null;
    private VIdentity userID = null;
    private AuthenticationInfo authInfo = null;
    private ClientSecurityContext context = null;
    private VCallerImpl callerID = null;
    private ToolAgentManager saManager = null;
    private Viper viper = null;
    private ClassLoader codeLoader = null;
    private int codebasePort = 898;
    Hashtable loadedTools = new Hashtable();
    Hashtable loadedServices = new Hashtable();
    Hashtable loadedXCProviders = new Hashtable();

    public ViperClient(String host, int port) throws VException, RemoteException {
        this.configureViperHome();
        this.viper = this.lookupServer(host, port);
        this.codeLoader = this.getCodeLoader(this.viper);
    }

    public ViperClient(AuthenticationInfo info) throws VException, RemoteException {
        this.configureViperHome();
        if (info == null) {
            String[] fargs = new String[]{"null"};
            throw new VException("InvalidParameter", fargs);
        }
        this.login(info);
    }

    public void logout() {
        try {
            SecurityToken token;
            Object[] objs;
            String name;
            Enumeration e = this.loadedTools.keys();
            while (e.hasMoreElements()) {
                name = (String)this.loadedTools.get(e.nextElement());
                objs = new Object[]{name};
                token = this.getMessageToken(objs);
                this.viper.derefTool(name, token);
            }
            e = this.loadedServices.keys();
            while (e.hasMoreElements()) {
                name = (String)this.loadedServices.get(e.nextElement());
                objs = new Object[]{name};
                token = this.getMessageToken(objs);
                this.viper.derefService(name, token);
            }
        }
        catch (Exception ex) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"deref bean exception during logout", (Throwable)ex);
        }
        try {
            AuthenticationClient.close(this, this.context);
        }
        catch (AuthenticationException ae) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"close authentication session failed", (Throwable)ae);
        }
        this.context = null;
        this.authInfo = null;
        this.userID = null;
        this.callerID = null;
        this.saManager = null;
        this.loadedTools.clear();
        this.loadedServices.clear();
    }

    protected void finalize() throws Throwable {
        if (this.context != null) {
            this.logout();
        }
    }

    private void configureViperHome() {
        try {
            this.viperHome = System.getProperty(PN_VIPER_HOME);
            if (this.viperHome == null) {
                this.viperHome = Default_Home;
                System.setProperty(PN_VIPER_HOME, this.viperHome);
            }
        }
        catch (Exception e) {
            Debug.trace((String)"ViperClient", (int)Debug.WARNING, (String)e.getMessage(), (Throwable)e);
        }
    }

    public void login(AuthenticationInfo info) throws VException, RemoteException {
        if (info == null) {
            String[] fargs = new String[]{"null AuthenticationInfo"};
            throw new AuthenticationException("InvalidParameter", (Object)fargs);
        }
        this.codebasePort = info.getPort();
        if (this.codebasePort <= 0) {
            this.codebasePort = 898;
        }
        String host = info.getHostName();
        try {
            host = InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception e) {
            throw new VException("IP resolution of host " + host + "failed");
        }
        this.viper = this.lookupServer(host, this.codebasePort);
        this.codeLoader = this.getCodeLoader(this.viper);
        if (!this.authenticateUser(info)) {
            String[] fargs = new String[]{info.getName()};
            throw new AuthenticationException("UserLoginFailed", (Object)fargs);
        }
        if (!this.authenticateRole(info)) {
            String[] fargs = new String[]{info.getRoleName()};
            throw new AuthenticationException("RoleLoginFailed", (Object)fargs);
        }
        this.authInfo = this.cloneAuthInfo(info);
        this.saManager = new ToolAgentManager(this);
    }

    public void assumeRole(AuthenticationInfo info) throws VException, RemoteException {
        if (!this.authenticateRole(info)) {
            throw new AuthenticationLoginException("null");
        }
        this.authInfo = new UserInfo(this.authInfo.getHostName(), this.authInfo.getPort(), this.authInfo.getName(), this.authInfo.getCredential(), info.getRoleName(), info.getRoleCredential());
    }

    private Viper lookupServer(String host, int codePort) throws InfrastructureException, RemoteException {
        String herVersion;
        Viper ref;
        if (host == null) {
            throw new NullPointerException("null host name");
        }
        try {
            URL u = new URL("http://" + host + ":" + codePort + REMOTE_REGISTRY_VIPER);
            URLConnection uc = u.openConnection();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(uc.getInputStream()));
            ref = (Viper)ois.readObject();
            if (ref == null) {
                throw new NullPointerException("Server RMI reference is null");
            }
            herVersion = ref.getViperImplVersion();
        }
        catch (Exception e) {
            String[] fargs = new String[]{host + ":" + codePort};
            throw new RemoteException(e.getMessage());
        }
        String herMajor = herVersion.substring(0, herVersion.indexOf(46));
        String myMajor = Integer.toString(1);
        if (!myMajor.equals(herMajor)) {
            String[] fargs = new String[]{herVersion};
            throw new InfrastructureException("VersionIncompatible", fargs);
        }
        return ref;
    }

    private boolean authenticateUser(AuthenticationInfo info) throws VException {
        if (info == null) {
            return false;
        }
        ClientSecurityContext tmpContext = AuthenticationClient.getSecurityContext();
        String host = info.getHostName();
        AuthenticationPrincipal ap = new AuthenticationPrincipal(0, info.getName(), null);
        ap.setHostName(host);
        tmpContext.setServerHostName(host);
        tmpContext.setAuthPrincipal(ap);
        tmpContext.setUserPassword(info.getCredential());
        if (this.authenticateIdentity(tmpContext)) {
            this.userID = this.convertToVId(ap);
            try {
                this.callerID = this.viper.getCallerImpl(this.getMessageToken());
            }
            catch (RemoteException re) {
                throw new VException("RMI_ERR: " + re.getMessage());
            }
            return true;
        }
        return false;
    }

    private ClassLoader getCodeLoader(Viper v) throws VException {
        try {
            URL serverCodeBase = v.getCodebase();
            Class<?> c = RMIClassLoader.loadClass(serverCodeBase, "NullClass");
            return c.getClassLoader();
        }
        catch (Throwable t) {
            throw new VException("Could not create remote code loader.");
        }
    }

    private boolean authenticateRole(AuthenticationInfo info) throws VException, RemoteException {
        if (info == null || this.userID == null) {
            return false;
        }
        if (info.getRoleName() == null || info.getRoleName().length() == 0) {
            return true;
        }
        ClientSecurityContext tmpContext = AuthenticationClient.getSecurityContext();
        AuthenticationPrincipal ap = new AuthenticationPrincipal(0, this.authInfo != null ? this.authInfo.getName() : info.getName(), info.getRoleName());
        String host = this.authInfo != null ? this.authInfo.getHostName() : info.getHostName();
        ap.setHostName(host);
        tmpContext.setServerHostName(host);
        tmpContext.setAuthPrincipal(ap);
        tmpContext.setUserPassword(info.getRoleCredential());
        if (this.authenticateIdentity(tmpContext)) {
            this.userID = this.convertToVId(ap);
            this.callerID = this.viper.getCallerImpl(this.getMessageToken());
            return true;
        }
        return false;
    }

    private boolean authenticateIdentity(ClientSecurityContext cntx) throws VException {
        try {
            AuthenticationClient.authenticate(this, cntx);
        }
        catch (AuthenticationLoginException ex) {
            throw ex;
        }
        catch (AuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"unexpected exception from authenticate()", (Throwable)ex);
            throw new VException("Unable to authenticate:" + ex.toString());
        }
        if (this.context != null) {
            try {
                AuthenticationClient.close(this, this.context);
            }
            catch (AuthenticationException ae) {
                Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)"closing client context", (Throwable)ae);
            }
        }
        this.context = cntx;
        return true;
    }

    public SecurityToken authRequest(String type, SecurityToken token) throws AuthenticationException {
        SecurityToken rtok = null;
        try {
            rtok = this.viper.authRequest(type, token);
        }
        catch (RemoteException rex) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)("Remote exception in authentication request: type=" + type + ", exception=" + rex.getMessage()), (Throwable)rex);
            throw new AuthenticationException("Remote exception in authentication request", (Exception)rex);
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (VException ex) {
            Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)("Unexpected exception in authentication request: type=" + type + ", exception=" + ex.getMessage()), (Throwable)ex);
            throw new AuthenticationException("Unexpected exception in authentication request", (Exception)((Object)ex));
        }
        return rtok;
    }

    private SecurityToken getMessageToken() throws VException {
        return this.getMessageToken(null);
    }

    SecurityToken getMessageToken(Object[] objs) throws VException {
        if (this.context == null) {
            throw new InfrastructureException("NoSecureSession");
        }
        return this.context.generateMessageToken(objs);
    }

    public Service getServiceByName(String name) throws VException {
        if (name == null) {
            String[] pars = new String[]{"null"};
            throw new BeanNotFoundException("ServiceNotFound", (Object)pars);
        }
        String classname = null;
        ServiceAgent result = null;
        try {
            Object[] objs = new Object[]{name};
            SecurityToken token = this.getMessageToken(objs);
            ServiceInfoImpl[] infos = this.viper.getServiceInfoImpl(name, token);
            if (infos == null || infos.length == 0) {
                String[] pars = new String[]{name};
                throw new BeanNotFoundException("ServiceNotFound", (Object)pars);
            }
            for (int i = 0; i < infos.length; ++i) {
                result = null;
                classname = infos[i].getClassName();
                objs[0] = classname;
                token = this.getMessageToken(objs);
                try {
                    ServiceProxy sp;
                    if (infos[i].getImplType() == 1) {
                        ServiceAgent sa = this.viper.getServiceObject(classname, token);
                        if (sa == null) continue;
                        sa.setContext(this.saManager);
                        result = sa;
                        break;
                    }
                    if (infos[i].isSingleton()) {
                        Enumeration e = this.loadedServices.keys();
                        while (e.hasMoreElements()) {
                            Service s = (Service)e.nextElement();
                            if (!this.loadedServices.get(s).equals(classname)) continue;
                            result = s;
                            break;
                        }
                        if (result != null) break;
                    }
                    if ((sp = (ServiceProxy)Beans.instantiate(this.codeLoader, classname)) == null) continue;
                    sp.setContext((ServiceContext)new ServiceContextImpl(null, infos[i].getProperties(), this.callerID));
                    sp.init((ToolInfrastructure)new ToolInfrastructureImpl(this));
                    sp.start();
                    result = (Service)sp;
                    this.viper.refServiceProxy(classname, token);
                    break;
                }
                catch (Throwable t) {
                    if (t instanceof RemoteException) {
                        throw (RemoteException)t;
                    }
                    Debug.trace((String)"ViperClient", (int)Debug.ERROR, (String)("exception in getServiceByName: " + t.getMessage()), null);
                }
            }
        }
        catch (RemoteException re) {
            throw new VException("RMI_ERR: " + re.getMessage());
        }
        if (result == null) {
            String[] pars = new String[]{name};
            throw new BeanNotFoundException("ServiceNotFound", (Object)pars);
        }
        this.loadedServices.put(result, classname);
        return result;
    }

    public void releaseService(Service s) throws VException {
        if (s != null) {
            String servicename;
            if (s instanceof ServiceProxy) {
                try {
                    ServiceProxy sp = (ServiceProxy)s;
                    sp.stop();
                    sp.destroy();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if ((servicename = (String)this.loadedServices.remove(s)) != null) {
                try {
                    Object[] objs = new Object[]{servicename};
                    SecurityToken token = this.getMessageToken(objs);
                    this.viper.derefService(servicename, token);
                }
                catch (RemoteException re) {
                    throw new VException("RMI_ERR: " + re.getMessage());
                }
            }
        }
    }

    public Tool getToolByName(String toolname) throws VException {
        Object[] objs = new Object[]{toolname};
        SecurityToken token = this.getMessageToken(objs);
        try {
            Tool t = (Tool)Beans.instantiate(this.codeLoader, toolname);
            this.viper.refTool(toolname, token);
            this.loadedTools.put(t, toolname);
            return t;
        }
        catch (VException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VException("UnexpectedException", e);
        }
        catch (Throwable e) {
            throw new VException(e.getMessage());
        }
    }

    public void releaseTool(Tool t) throws VException {
        String name;
        if (t != null && (name = (String)this.loadedTools.remove(t)) != null) {
            try {
                Object[] objs = new Object[]{name};
                SecurityToken token = this.getMessageToken(objs);
                this.viper.derefTool(name, token);
            }
            catch (RemoteException re) {
                throw new VException("RMI_ERR: " + re.getMessage());
            }
        }
    }

    public ToolInfo getToolInfo(String toolname) throws VException {
        try {
            return this.viper.getToolInfoImpl(toolname);
        }
        catch (RemoteException re) {
            throw new InfrastructureException("RMI_ERR: " + re.getMessage());
        }
    }

    public ServiceInfo getServiceInfo(String servicename) throws VException {
        Object[] objs = new Object[]{servicename};
        SecurityToken token = this.getMessageToken(objs);
        try {
            return this.viper.getServiceInfoImpl(servicename, token)[0];
        }
        catch (RemoteException re) {
            throw new InfrastructureException("RMI_ERR: " + re.getMessage());
        }
    }

    public VIdentity getIdentity() {
        return this.userID;
    }

    public Object getExternalClient(String type, Object[] params) throws Exception {
        ExternalClientProvider xcp = (ExternalClientProvider)this.loadedXCProviders.get(type);
        if (xcp == null) {
            int i;
            Object[] objs = new Object[]{type};
            SecurityToken token = this.getMessageToken(objs);
            ExternalClientProviderInfoImpl[] infos = this.viper.getExternalClientProviderInfoImpl(type, token);
            if (infos == null) {
                String[] fargs = new String[]{type};
                throw new InfrastructureException("XCProviderNotFound", fargs);
            }
            String classname = null;
            String retryErrorMsg = "";
            for (i = 0; i < infos.length; ++i) {
                xcp = null;
                try {
                    classname = infos[i].getClassName();
                    xcp = (ExternalClientProvider)Beans.instantiate(this.codeLoader, classname);
                    if (xcp == null) continue;
                    break;
                }
                catch (Throwable t) {
                    retryErrorMsg = retryErrorMsg + "\n" + classname + ": " + t.getLocalizedMessage();
                }
            }
            if (xcp != null) {
                String[] types = infos[i].getClientTypes();
                for (int j = 0; j < types.length; ++j) {
                    this.loadedXCProviders.put(types[j], xcp);
                }
            } else {
                String[] fargs = new String[]{type, retryErrorMsg};
                throw new InfrastructureException("XCProviderLoadError", fargs);
            }
        }
        return xcp.getExternalClient(type, this.authInfo.getHostName(), this.authInfo.getName(), this.authInfo.getCredential(), this.authInfo.getRoleName(), this.authInfo.getRoleCredential(), params);
    }

    public void releaseExternalClient(String framework_type, Object[] params) throws Exception {
        ExternalClientProvider xcp = (ExternalClientProvider)this.loadedXCProviders.get(framework_type);
        if (xcp == null) {
            int i;
            Object[] objs = new Object[]{framework_type};
            SecurityToken token = this.getMessageToken(objs);
            ExternalClientProviderInfoImpl[] infos = this.viper.getExternalClientProviderInfoImpl(framework_type, token);
            if (infos == null) {
                String[] fargs = new String[]{framework_type};
                throw new InfrastructureException("XCProviderNotFound", fargs);
            }
            String classname = null;
            String retryErrorMsg = "";
            for (i = 0; i < infos.length; ++i) {
                xcp = null;
                try {
                    classname = infos[i].getClassName();
                    xcp = (ExternalClientProvider)Beans.instantiate(this.codeLoader, classname);
                    if (xcp == null) continue;
                    break;
                }
                catch (Throwable t) {
                    retryErrorMsg = retryErrorMsg + "\n" + classname + ": " + t.getLocalizedMessage();
                }
            }
            if (xcp != null) {
                String[] types = infos[i].getClientTypes();
                for (int j = 0; j < types.length; ++j) {
                    this.loadedXCProviders.put(types[j], xcp);
                }
            } else {
                String[] fargs = new String[]{framework_type, retryErrorMsg};
                throw new InfrastructureException("XCProviderLoadError", fargs);
            }
        }
        xcp.closeExternalClient(params);
    }

    public Process execConsole(int consoleType, String server, String toolbox, String toolname, AdminMgmtScope scope, Properties jprops, String tooloptions) throws VException {
        Enumeration<?> e;
        if (consoleType != 0) {
            throw new VException("UnsupportedConsoleType");
        }
        String viperHome = System.getProperty(PN_VIPER_HOME);
        String cmd = viperHome + "/bin/smc -t --trust";
        cmd = cmd + " --hostname " + (server == null || server.trim().length() == 0 ? this.authInfo.getHostName() + ":" + this.authInfo.getPort() : server.trim());
        cmd = cmd + " --username " + this.authInfo.getName();
        if (this.authInfo.getRoleName() != null && this.authInfo.getRoleName().trim().length() > 0) {
            cmd = cmd + " --rolename " + this.authInfo.getRoleName();
        }
        if (toolname == null || toolname.trim().length() == 0) {
            throw new VException("NullToolforVTerm");
        }
        cmd = cmd + " --tool " + toolname;
        if (scope != null) {
            cmd = cmd + " --domain " + scope.toDirectoryTableURL();
        }
        if (toolbox != null && toolbox.trim().length() > 0) {
            cmd = cmd + " --toolbox " + toolbox;
        }
        if (jprops != null && (e = jprops.propertyNames()) != null) {
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = jprops.getProperty(key);
                if ((key + value).indexOf(34) >= 0) {
                    InvalidParameterException ipe = new InvalidParameterException("no quotes are allowed in property key or value");
                    throw new VException("VTermExecErr", (Exception)ipe);
                }
                cmd = cmd + " -J-D\"" + key + "\"=\"" + value + "\"";
            }
        }
        if (tooloptions != null) {
            cmd = cmd + " -- " + tooloptions;
        }
        Debug.trace((String)"ViperClient", (int)Debug.INFORMATION, (String)("execConsole command: " + cmd), null);
        Process term = null;
        try {
            final String command = cmd;
            term = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Runtime.getRuntime().exec(command);
                }
            });
            OutputStream out = term.getOutputStream();
            out.write((this.authInfo.getCredential() + "\n").getBytes());
            if (this.authInfo.getRoleName() != null && this.authInfo.getRoleName().trim().length() > 0) {
                out.write((this.authInfo.getRoleCredential() + "\n").getBytes());
            }
            if (tooloptions == null || tooloptions.trim().length() == 0) {
                out.write("\n".getBytes());
            }
            out.flush();
            return term;
        }
        catch (PrivilegedActionException pae) {
            throw new VException("VTermExecErr", pae.getException());
        }
        catch (Exception e2) {
            if (term != null) {
                term.destroy();
            }
            throw new VException("VTermExecErr", e2);
        }
    }

    public VLocalizedInfo getLocalizedInfo(String resourceBase, Locale loc) throws VException {
        String path;
        String file;
        String name = null;
        String desc = null;
        String version = null;
        String vendor = null;
        ImageIcon large = null;
        ImageIcon small = null;
        ResourceBundle resource = null;
        try {
            resource = ResourceBundle.getBundle(resourceBase, loc, this.codeLoader);
        }
        catch (Exception e) {
            String[] fargs = new String[]{resourceBase};
            throw new VException("ResourceNotFound", fargs);
        }
        try {
            name = resource.getString("BEANNAME");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            desc = resource.getString("DESCRIPTION");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            version = resource.getString("VERSION");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            vendor = resource.getString("VENDOR");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            file = resource.getString("LARGEICON");
            if (file != null) {
                path = this.getResourcePath(resourceBase, file);
                large = ConsoleUtility.loadImageIcon((URL)this.codeLoader.getResource(path), (String)"");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            file = resource.getString("SMALLICON");
            if (file != null) {
                path = this.getResourcePath(resourceBase, file);
                small = ConsoleUtility.loadImageIcon((URL)this.codeLoader.getResource(path), (String)"");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new VLocalizedInfo(name, desc, vendor, version, large, small);
    }

    private String getResourcePath(String baseClass, String relativePath) {
        if (baseClass == null || relativePath == null) {
            return null;
        }
        int end = baseClass.lastIndexOf(46);
        while (end >= 0 && relativePath.startsWith("../")) {
            relativePath = relativePath.substring(3);
            baseClass = baseClass.substring(0, end);
            end = baseClass.lastIndexOf(46);
        }
        return baseClass.substring(0, end + 1).replace('.', '/') + relativePath;
    }

    public void stopServer() throws RemoteException {
        try {
            SecurityToken token = this.getMessageToken();
            this.viper.stopServer(token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector getToolInfoList() throws VException, RemoteException {
        return this.viper.getToolInfoImplList();
    }

    public Vector getServiceInfoList() throws VException, RemoteException {
        SecurityToken token = this.getMessageToken();
        return this.viper.getServiceInfoImplList(token);
    }

    public String getHostName() {
        if (this.userID == null) {
            return null;
        }
        return this.userID.getAuthenHost();
    }

    public int getPort() {
        return this.codebasePort;
    }

    public VIdentity[] getRoles() {
        AuthenticationPrincipal[] roles = this.context.getRoleList();
        if (roles == null) {
            return null;
        }
        VIdentity[] result = new VIdentity[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            result[i] = this.convertToVId(roles[i]);
        }
        return result;
    }

    private VIdentity convertToVId(AuthenticationPrincipal ap) {
        VIdentity id = ap.getRoleName() == null ? new VIdentity(ap.getUserName(), ap.getUserDesc(), ap.getUserName(), ap.getUserDesc(), ap.getHostName()) : new VIdentity(ap.getRoleName(), ap.getRoleDesc(), ap.getUserName(), ap.getUserDesc(), ap.getHostName());
        return id;
    }

    private AuthenticationInfo cloneAuthInfo(AuthenticationInfo info) {
        return new UserInfo(info.getHostName(), info.getPort(), info.getName(), info.getCredential(), info.getRoleName(), info.getRoleCredential());
    }
}

