/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.services.AuthenticationInfo;

public class UserInfo
implements AuthenticationInfo {
    static final long serialVersionUID = -3115325290612861708L;
    private String hostname = null;
    private int port = 0;
    private int[] username;
    private int[] password;
    private int[] rolename;
    private int[] rolepassword;

    public UserInfo(String hostname, String user, String pwd) {
        this.init(hostname, 0, user, pwd, null, null);
    }

    public UserInfo(String hostname, int port, String user, String pwd) {
        this.init(hostname, port, user, pwd, null, null);
    }

    public UserInfo(String hostname, String user, String pwd, String role, String rolepwd) {
        this.init(hostname, 0, user, pwd, role, rolepwd);
    }

    public UserInfo(String hostname, int port, String user, String pwd, String role, String rolepwd) {
        this.init(hostname, port, user, pwd, role, rolepwd);
    }

    private void init(String hostname, int port, String user, String pwd, String role, String rolepwd) {
        if (user == null) {
            this.username = new int[0];
        } else {
            this.setName(user);
        }
        if (pwd == null) {
            this.password = new int[0];
        } else {
            this.setCredential(pwd);
        }
        if (role == null) {
            this.rolename = new int[0];
        } else {
            this.setRoleName(role);
        }
        if (rolepwd == null) {
            this.rolepassword = new int[0];
        } else {
            this.setRoleCredential(rolepwd);
        }
        this.setHostName(hostname);
        this.setPort(port);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        int len = this.username.length;
        if (len == 0) {
            return null;
        }
        char[] myChars = new char[len];
        --len;
        while (len >= 0) {
            myChars[len] = (char)(this.username[len] ^ 0x7E44);
            --len;
        }
        return new String(myChars);
    }

    public String getCredential() {
        int len = this.password.length;
        char[] myChars = new char[len];
        --len;
        while (len >= 0) {
            myChars[len] = (char)(this.password[len] ^ 0x4E77);
            --len;
        }
        return new String(myChars);
    }

    public String getRoleName() {
        int len = this.rolename.length;
        if (len == 0) {
            return null;
        }
        char[] myChars = new char[len];
        --len;
        while (len >= 0) {
            myChars[len] = (char)(this.rolename[len] ^ 0x7E44);
            --len;
        }
        return new String(myChars);
    }

    public String getRoleCredential() {
        int len = this.rolepassword.length;
        char[] myChars = new char[len];
        --len;
        while (len >= 0) {
            myChars[len] = (char)(this.rolepassword[len] ^ 0x4E77);
            --len;
        }
        return new String(myChars);
    }

    private void setHostName(String host) {
        this.hostname = host;
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setName(String usr) {
        int len = usr.length();
        char[] myChars = new char[len];
        usr.getChars(0, len, myChars, 0);
        this.username = new int[len];
        --len;
        while (len >= 0) {
            this.username[len] = myChars[len] ^ 0x7E44;
            --len;
        }
    }

    private void setCredential(String passwd) {
        int len = passwd.length();
        char[] myChars = new char[len];
        passwd.getChars(0, len, myChars, 0);
        this.password = new int[len];
        --len;
        while (len >= 0) {
            this.password[len] = myChars[len] ^ 0x4E77;
            --len;
        }
    }

    private void setRoleName(String role) {
        int len = role.length();
        char[] myChars = new char[len];
        role.getChars(0, len, myChars, 0);
        this.rolename = new int[len];
        --len;
        while (len >= 0) {
            this.rolename[len] = myChars[len] ^ 0x7E44;
            --len;
        }
    }

    private void setRoleCredential(String rolepasswd) {
        int len = rolepasswd.length();
        char[] myChars = new char[len];
        rolepasswd.getChars(0, len, myChars, 0);
        this.rolepassword = new int[len];
        --len;
        while (len >= 0) {
            this.rolepassword[len] = myChars[len] ^ 0x4E77;
            --len;
        }
    }
}

