/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class LibInfoImpl
implements ComponentInfo,
Cloneable {
    static final long serialVersionUID = -3388205652290741120L;
    private int type = 0;
    private String id = null;
    private String resourceBase = "";
    private String version = "0.0";
    private String[] propertyList = null;
    private Properties props = new Properties();
    private String jarName = null;
    private Date regDate = null;
    private String[] nativeLibs = null;

    public LibInfoImpl(String v, String resource, Properties ps, String id) {
        if (v != null) {
            this.version = v;
        }
        if (resource != null) {
            this.resourceBase = resource;
        }
        if (ps != null) {
            this.props = ps;
            Vector prop_keys = new Vector();
            Enumeration<?> e = ps.propertyNames();
            while (e.hasMoreElements()) {
                prop_keys.add(e.nextElement());
            }
            this.propertyList = prop_keys.toArray(new String[0]);
        }
        this.id = id;
        this.jarName = null;
        this.regDate = new Date();
        this.nativeLibs = new String[0];
    }

    public LibInfoImpl(ComponentInfo info) {
        if (info == null) {
            return;
        }
        this.type = info.getComponentType();
        this.resourceBase = info.getResourceBaseName();
        this.version = info.getVersion();
        this.props = info.getProperties();
        this.id = info.getID();
        if (info instanceof LibInfoImpl) {
            this.jarName = ((LibInfoImpl)info).getJarName();
            this.regDate = ((LibInfoImpl)info).getRegistrarDate();
            this.nativeLibs = ((LibInfoImpl)info).getNativeLibs();
        }
        if (this.regDate == null) {
            this.regDate = new Date();
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        if (this.nativeLibs == null) {
            this.nativeLibs = new String[0];
        }
    }

    public int getComponentType() {
        return this.type;
    }

    protected void setComponentType(int newType) {
        this.type = newType;
    }

    public String getResourceBaseName() {
        return this.resourceBase;
    }

    public String getVersion() {
        return this.version;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getJarPath() {
        return VRegistry.toFullJarPath((String)this.jarName);
    }

    public void setJarName(String name) {
        this.jarName = name;
    }

    public Date getRegistrarDate() {
        return this.regDate;
    }

    public void setRegistrarDate(Date date) {
        this.regDate = date;
    }

    public String[] getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(String[] pl) {
        this.propertyList = pl;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties ps) {
        this.props = ps == null ? new Properties() : ps;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Object setProperty(String key, String value) {
        return this.props.setProperty(key, value);
    }

    public String[] getNativeLibs() {
        return this.nativeLibs;
    }

    public void setNativeLibs(String[] nLibs) {
        this.nativeLibs = nLibs == null ? new String[]{} : nLibs;
    }

    public String getID() {
        return this.id;
    }

    public synchronized Object clone() {
        return new LibInfoImpl(this);
    }

    public String toString() {
        return "Component info:\n\tversion=" + this.getVersion() + "\n\tresource=" + this.getResourceBaseName() + "\n\tproperty-list=" + this.printArray(this.getPropertyList()) + "\n\tproperties=" + this.getProperties() + "\n\tjar-name=" + this.getJarName() + "\n\treg-date=" + this.getRegistrarDate() + "\n\tnative-libs=" + this.printArray(this.getNativeLibs());
    }

    public String printArray(Object[] sarray) {
        String result = "";
        if (sarray != null) {
            for (int i = 0; i < sarray.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + sarray[i];
            }
        }
        return "{" + result + "}";
    }
}

