/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viperimpl.ExternalClientProviderInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Properties;

public class ExternalClientProviderInfoImpl
extends LibInfoImpl
implements ExternalClientProviderInfo,
Cloneable {
    static final long serialVersionUID = -8187831959767460926L;
    private String[] xclientTypes = null;
    private String classname = null;
    private String helpBase = null;
    private String APIversion = "1.0";
    private Date editDate = null;
    private LibInfoImpl[] attachments = null;

    public ExternalClientProviderInfoImpl(ExternalClientProviderInfo aInfo) {
        super(aInfo);
        if (aInfo != null) {
            this.xclientTypes = aInfo.getClientTypes();
            this.classname = aInfo.getClassName();
            this.helpBase = aInfo.getHelpBaseName();
            this.APIversion = aInfo.getAPIVersion();
            if (aInfo instanceof ExternalClientProviderInfoImpl) {
                this.editDate = ((ExternalClientProviderInfoImpl)aInfo).getEditDate();
                this.attachments = ((ExternalClientProviderInfoImpl)aInfo).getAttachments();
            }
            if (this.attachments == null) {
                this.attachments = new LibInfoImpl[0];
            }
            if (this.editDate == null) {
                this.editDate = new Date();
            }
            if (this.getJarName() == null) {
                this.setJarName(VRegistry.toJarName((int)3, (String)this.classname));
            }
        }
    }

    public ExternalClientProviderInfoImpl(String className, String[] xclientTypes, String resourceBase, String helpBase, String version, String APIversion, Properties props, String id) {
        super(version, resourceBase, props, id);
        this.classname = className;
        this.xclientTypes = xclientTypes;
        this.helpBase = helpBase;
        this.APIversion = APIversion;
        this.setJarName(VRegistry.toJarName((int)3, (String)this.classname));
        this.setComponentType(3);
        this.attachments = new LibInfoImpl[0];
        this.editDate = new Date();
    }

    public String[] getClientTypes() {
        return this.xclientTypes;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getHelpBaseName() {
        return this.helpBase;
    }

    public String getAPIVersion() {
        return this.APIversion;
    }

    public Date getEditDate() {
        return this.editDate;
    }

    public LibInfoImpl[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(LibInfoImpl[] l) {
        this.attachments = l != null ? l : new LibInfoImpl[]{};
        this.editDate = new Date();
    }

    public String[] getJarPaths() {
        String[] result = new String[1 + this.attachments.length];
        result[0] = this.getJarPath();
        for (int i = 0; i < this.attachments.length; ++i) {
            result[1 + i] = this.attachments[i].getJarPath();
        }
        return result;
    }

    public synchronized Object clone() {
        return new ExternalClientProviderInfoImpl(this);
    }

    public String toString() {
        return "ExternalClientProvider info:\n\timpl-class=" + this.getClassName() + "\n\txclient-types=" + this.printArray(this.getClientTypes()) + "\n\thelp-base=" + this.getHelpBaseName() + "\n\tapi-version=" + this.getAPIVersion() + "\n" + "\n\tlast-modified=" + this.getEditDate() + "\n\tattachments=" + this.printArray(this.getAttachments()) + "\n" + super.toString();
    }
}

