/*
 * Decompiled with CFR 0.152.
 */
package com.sun.srs.im;

import com.sun.srs.im.GenericData;
import com.sun.srs.im.MessageContent;
import com.sun.srs.im.SRSEnum;
import com.sun.srs.im.SRSTimestamp;

public class EventData
implements MessageContent {
    public static final Severity SEV_UNKNOWN = new Severity("unknown", 0);
    public static final Severity SEV_OTHER = new Severity("other", 1);
    public static final Severity SEV_INFO = new Severity("info", 2);
    public static final Severity SEV_WARNING = new Severity("warning", 3);
    public static final Severity SEV_MINOR = new Severity("minor", 4);
    public static final Severity SEV_MAJOR = new Severity("major", 5);
    public static final Severity SEV_CRITICAL = new Severity("critical", 6);
    public static final Severity SEV_FATAL = new Severity("fatal", 7);
    private SRSTimestamp timestamp;
    private String srcid;
    private Severity severity;
    private String text;
    private GenericData data;

    public EventData(SRSTimestamp timestamp, String srcid, Severity severity, String text) {
        this(timestamp, srcid, severity, text, null);
    }

    public EventData(SRSTimestamp timestamp, String srcid, Severity severity, String text, GenericData data) {
        if (timestamp == null) {
            throw new IllegalArgumentException("null timestamp");
        }
        if (srcid == null) {
            throw new IllegalArgumentException("null srcid");
        }
        if (text == null) {
            throw new IllegalArgumentException("null text");
        }
        if (severity == null) {
            throw new IllegalArgumentException("null severity");
        }
        this.timestamp = timestamp;
        this.srcid = srcid;
        this.severity = severity;
        this.text = text;
        this.data = data;
    }

    public SRSTimestamp getTimestamp() {
        return this.timestamp;
    }

    public String getSrcId() {
        return this.srcid;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public GenericData getData() {
        return this.data;
    }

    protected static class Severity
    extends SRSEnum {
        private Severity(String name, int value) {
            super(name, value);
        }
    }
}

