/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.UninstallSummaryDialog;
import com.sun.swup.client.ui.UninstallSummaryEditorPane;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import com.sun.swup.client.ui.foundation.swing.MessageTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

class UninstallSummaryPanel
extends InsetPanel {
    private WeakReference uninstallSummaryDialog;
    private JLabel processCompleteLabel;
    private JLabel failedUninstallLabel;
    private MessageTextArea failedUninstallInfoTextArea;
    private boolean failedUninstallType = false;
    private JScrollPane uninstallSummaryScrollPane;
    private UninstallSummaryEditorPane uninstallSummaryEditorPane;
    private JButton okButton;

    UninstallSummaryPanel(UninstallSummaryDialog uninstallSummaryDialog) {
        this.setUninstallSummaryDialog(uninstallSummaryDialog);
        this.createComponents();
        this.createLayout();
    }

    UninstallSummaryEditorPane getEditorPane() {
        return this.uninstallSummaryEditorPane;
    }

    private void createComponents() {
        GenericActionSet actionSet = this.getUninstallSummaryDialog().getActionSet();
        ImageIcon infoImageIcon = Environment.getImageIcon((String)"info_medium.gif");
        this.processCompleteLabel = new JLabel(UninstallSummaryDialog.I18N.getString("process-complete"), infoImageIcon, 2);
        this.checkForUpdateTypes();
        int iReferenceWidth = this.getUninstallSummaryDialog().getSize().width;
        if (this.failedUninstallType) {
            ImageIcon failedImageIcon = Environment.getImageIcon((String)"warning_medium.gif");
            this.failedUninstallLabel = new JLabel(UninstallSummaryDialog.I18N.getString("failed-uninstallation"), failedImageIcon, 2);
            String sString = UninstallSummaryDialog.I18N.getString("failed-uninstallation-message");
            this.failedUninstallInfoTextArea = new MessageTextArea(sString, iReferenceWidth);
            this.failedUninstallInfoTextArea.setFont(Utility.getReducedFont(this, "small-font-reduction"));
            this.failedUninstallInfoTextArea.setAlignmentX(0.0f);
        }
        this.uninstallSummaryEditorPane = new UninstallSummaryEditorPane(this.getUninstallSummaryDialog());
        this.uninstallSummaryScrollPane = this.uninstallSummaryEditorPane.getScrollPane();
        this.okButton = new JButton(actionSet.getAction("ok"));
        this.okButton.setDefaultCapable(true);
        this.getUninstallSummaryDialog().getRootPane().setDefaultButton(this.okButton);
        this.okButton.setMnemonic(UninstallSummaryDialog.I18N.getString("ok.mnemonic").charAt(0));
    }

    private void createLayout() {
        InsetPanel headerPanel = new InsetPanel(new Insets(6, 6, 6, 6));
        headerPanel.setLayout(new BoxLayout(headerPanel, 1));
        headerPanel.setAlignmentY(0.0f);
        headerPanel.add(this.processCompleteLabel);
        headerPanel.add(Box.createRigidArea(Utility.VGAP10));
        if (this.failedUninstallType) {
            headerPanel.add(this.failedUninstallLabel);
            headerPanel.add(this.failedUninstallInfoTextArea);
            headerPanel.add(Box.createRigidArea(Utility.VGAP10));
        }
        InsetPanel footerPanel = new InsetPanel(new Insets(8, 0, 0, 0));
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(this.okButton);
        this.setInsets(new Insets(13, 13, 13, 13));
        this.setLayout(new BorderLayout());
        this.add((Component)headerPanel, "North");
        this.add((Component)this.uninstallSummaryScrollPane, "Center");
        this.add((Component)footerPanel, "South");
    }

    private void checkForUpdateTypes() {
        UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
        Update[] aUpdates = ud.getUninstallSummaryUpdates();
        for (int i = 0; i < aUpdates.length; ++i) {
            int us = aUpdates[i].getUpdateOperateStatus();
            if (us != 1) continue;
            this.failedUninstallType = true;
            break;
        }
    }

    private void setUninstallSummaryDialog(UninstallSummaryDialog uninstallSummaryDialog) {
        this.uninstallSummaryDialog = new WeakReference<UninstallSummaryDialog>(uninstallSummaryDialog);
    }

    private UninstallSummaryDialog getUninstallSummaryDialog() {
        return (UninstallSummaryDialog)this.uninstallSummaryDialog.get();
    }
}

