/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.AboutFrame;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

class AboutPanel
extends InsetPanel
implements ActionListener {
    private WeakReference aboutFrame;
    private JLabel versionLabel;
    private JScrollPane sTextArea;
    private ImageIcon umBranding;
    private JTextPane leftTextPane;
    private JButton closeButton;

    AboutPanel(AboutFrame aboutFrame) {
        this.setAboutFrame(aboutFrame);
        this.createComponents();
        this.createLayout();
        this.setOpaque(true);
    }

    private void createComponents() {
        this.versionLabel = new JLabel(AboutFrame.I18N.getString("version"));
        this.versionLabel.setAlignmentY(1.0f);
        this.versionLabel.setFont(this.versionLabel.getFont().deriveFont(1));
        this.versionLabel.setOpaque(true);
        AboutTextArea textArea = new AboutTextArea(AboutFrame.I18N.getString("restrictions"));
        this.sTextArea = new JScrollPane(textArea, 20, 31);
        this.leftTextPane = new JTextPane();
        this.leftTextPane.setOpaque(true);
        String imageName = AboutFrame.I18N.getString("branding_graphic_name");
        this.leftTextPane.insertIcon(Environment.getImageIcon((String)imageName));
        this.leftTextPane.setEditable(false);
        this.leftTextPane.setOpaque(true);
        this.closeButton = new JButton(AboutFrame.I18N.getString("close"));
        this.closeButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        AboutFrame parent = (AboutFrame)this.getParent().getParent().getParent().getParent();
        if (parent != null) {
            parent.requestToClose();
        }
    }

    private void createLayout() {
        InsetPanel rightTextPanel = new InsetPanel(new Insets(10, 10, 10, 10));
        rightTextPanel.setLayout(new BorderLayout(0, 5));
        InsetPanel topRightTextPanel = new InsetPanel(new Insets(10, 10, 10, 10));
        topRightTextPanel.setLayout(new BorderLayout(0, 5));
        topRightTextPanel.add((Component)this.versionLabel, "East");
        topRightTextPanel.setOpaque(true);
        rightTextPanel.add((Component)topRightTextPanel, "North");
        rightTextPanel.add((Component)this.sTextArea, "Center");
        InsetPanel botRightTextPanel = new InsetPanel(new Insets(10, 10, 10, 10));
        botRightTextPanel.setLayout(new BorderLayout(0, 5));
        botRightTextPanel.add((Component)this.closeButton, "East");
        botRightTextPanel.setOpaque(true);
        rightTextPanel.add((Component)botRightTextPanel, "South");
        rightTextPanel.setOpaque(true);
        InsetPanel textPanel = new InsetPanel(new Insets(10, 10, 10, 10));
        textPanel.setLayout(new BorderLayout(0, 5));
        textPanel.add((Component)this.leftTextPane, "West");
        textPanel.add((Component)rightTextPanel, "East");
        textPanel.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)textPanel, "Center");
        this.setOpaque(true);
    }

    private void setAboutFrame(AboutFrame aboutFrame) {
        this.aboutFrame = new WeakReference<AboutFrame>(aboutFrame);
    }

    private AboutFrame getAboutFrame() {
        return (AboutFrame)this.aboutFrame.get();
    }

    class AboutTextArea
    extends JTextArea {
        private int WIDTH = 354;

        AboutTextArea(String sString) {
            super(sString);
            this.setOpaque(true);
            this.setEditable(false);
            this.setFont(Utility.getReducedFont(this, "small-font-reduction"));
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = this.WIDTH;
            d.height = 450;
            return d;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

