/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.engine.solaris;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.engine.AbstractUpdateCollection;
import com.sun.swup.client.engine.solaris.CategoryFileException;
import com.sun.swup.client.engine.solaris.CollectionFileException;
import com.sun.swup.client.engine.solaris.PatchCategory;
import com.sun.swup.client.engine.solaris.PatchCollection;
import com.sun.swup.client.engine.solaris.SolarisAuthenticator;
import com.sun.swup.client.engine.solaris.SolarisInstaller;
import com.sun.swup.client.engine.solaris.SolarisUninstaller;
import com.sun.swup.client.interfaces.Authenticator;
import com.sun.swup.client.interfaces.Cancellable;
import com.sun.swup.client.interfaces.DataController;
import com.sun.swup.client.interfaces.Installer;
import com.sun.swup.client.interfaces.Uninstaller;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.interfaces.UpdateCollection;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class SolarisDataCollector
implements DataController {
    private static DataController collector = null;
    private static PatchCategory categoryObj = null;
    private static PatchCollection collectionObj = null;
    private List availableCollectionNames = new ArrayList();
    private List availableCollectionDescriptions = new ArrayList();
    private Hashtable collectionTable = new Hashtable();
    private boolean debug = false;
    private boolean useStoredData = false;
    private Authenticator authenticator = new SolarisAuthenticator();
    private Installer installer = new SolarisInstaller();
    private Uninstaller uninstaller = new SolarisUninstaller();

    protected SolarisDataCollector() {
    }

    public static DataController getInstance() {
        collector = new SolarisDataCollector();
        return collector;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUseStoredData(boolean stored) {
        this.useStoredData = stored;
    }

    public synchronized UpdateCollection[] getAvailableUpdateCollections() throws Throwable {
        ArrayList<UpdateCollection> collections = new ArrayList<UpdateCollection>();
        String[] names = this.getAvailableCollectionNames();
        if (names == null || names.length == 0) {
            return null;
        }
        for (int i = 0; i < names.length; ++i) {
            String key = names[i];
            String value = SolarisDataCollector.getCollectionsObject().getDescription(key);
            this.availableCollectionNames.add(key);
            this.availableCollectionDescriptions.add(value);
            this.collectionTable.put(key, value);
            UpdateCollection updateCollection = AbstractUpdateCollection.getInstance(key);
            updateCollection.setDescription(value);
            collections.add(updateCollection);
        }
        int size = collections.size();
        UpdateCollection[] collectionArray = new UpdateCollection[size];
        for (int i = 0; i < size; ++i) {
            collectionArray[i] = (UpdateCollection)collections.get(i);
        }
        return collectionArray;
    }

    public UpdateCollection getUpdateCollection(String name) throws Throwable {
        UpdateCollection collection = AbstractUpdateCollection.getInstance(name);
        if (this.availableCollectionNames != null && !this.availableCollectionNames.isEmpty() && this.availableCollectionNames.contains(name)) {
            String description;
            collection.setName(name);
            collection.setUseStoredData(this.useStoredData);
            collection.populate();
            if (this.collectionTable != null && (description = (String)this.collectionTable.get(name)) != null) {
                collection.setDescription(description);
            }
            this.setUseStoredData(false);
            return collection;
        }
        String desc = SolarisDataCollector.getCollectionsObject().getDescription(name);
        if (desc != null) {
            collection.setName(name);
            collection.setDescription(desc);
            collection.setUseStoredData(this.useStoredData);
            collection.populate();
            this.setUseStoredData(false);
            return collection;
        }
        this.setUseStoredData(false);
        return collection;
    }

    public UpdateCollection getUpdateCollection(UpdateCollection collection) throws Throwable {
        UpdateCollection curCollection = collection;
        String collectionName = null;
        if (curCollection != null) {
            collectionName = collection.getName();
        }
        if (collectionName == null || collectionName.length() == 0) {
            this.setUseStoredData(false);
            return curCollection;
        }
        curCollection = this.getUpdateCollection(collectionName);
        this.setUseStoredData(false);
        return curCollection;
    }

    public String[] getAvailableCollectionNames() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        return SolarisDataCollector.getCollectionsObject().getCollectionNames();
    }

    public String[] getAvailableCollectionDescriptions() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        return SolarisDataCollector.getCollectionsObject().getCollectionDescriptions();
    }

    public Hashtable getAvailableCollectionTable() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        SolarisDataCollector.getCollectionsObject();
        return PatchCollection.getCollectionTable();
    }

    public Update[] getInstalledUpdates() throws Throwable {
        UpdateCollection installedCollection = AbstractUpdateCollection.getInstance(null);
        installedCollection.setIsInstalledCollection(true);
        installedCollection.populate();
        Update[] updates = installedCollection.getUpdates();
        return updates;
    }

    public String[] getPrecedenceSortedCategoryList() throws CMDExecutionException, NotAuthenticatedException, CategoryFileException {
        return SolarisDataCollector.getCategoriesObject().getPrecedenceSortedCategories();
    }

    public String[] getDisplayPrecedenceSortedCategoryList() throws CMDExecutionException, NotAuthenticatedException, CategoryFileException {
        return SolarisDataCollector.getCategoriesObject().getDisplayPrecedenceSortedCategories();
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public Uninstaller getUninstaller() {
        return this.uninstaller;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public static synchronized PatchCollection getCollectionsObject() throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        if (collectionObj == null) {
            collectionObj = PatchCollection.getInstance();
        }
        return collectionObj;
    }

    public static void invalidateCategoriesObject() {
        PatchCategory.invalidatePatchCategory();
        categoryObj = null;
    }

    public static void invalidateCollectionsObject() {
        PatchCollection.invalidatePatchCollections();
        collectionObj = null;
    }

    public static boolean isCollCatDataValid() {
        return PatchCategory.isCategoryObjInit() && PatchCollection.isCollectionObjInit();
    }

    public static synchronized PatchCategory getCategoriesObject() throws CMDExecutionException, NotAuthenticatedException, CategoryFileException {
        if (categoryObj == null) {
            categoryObj = PatchCategory.getInstance();
        }
        return categoryObj;
    }

    public Cancellable getCancelAction() {
        return PatchProWrapper.getInstance().getCancelAction();
    }

    public void setPatchSet(String name) throws CMDExecutionException, NotAuthenticatedException, CollectionFileException {
        SolarisDataCollector.getCollectionsObject().setPatchSet(name);
    }

    public Update[] getHistoryUpdates() {
        return null;
    }
}

