/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.client;

import com.sun.admin.pm.client.pmAddAccessFailedException;
import com.sun.admin.pm.client.pmButtonScreen;
import com.sun.admin.pm.client.pmCalls;
import com.sun.admin.pm.client.pmFrame;
import com.sun.admin.pm.client.pmGuiException;
import com.sun.admin.pm.client.pmIncompleteFormException;
import com.sun.admin.pm.client.pmLoginFailedException;
import com.sun.admin.pm.client.pmMessageDialog;
import com.sun.admin.pm.client.pmMustBeRemoteServerException;
import com.sun.admin.pm.client.pmOKCancelDialog;
import com.sun.admin.pm.client.pmPrinterExistsException;
import com.sun.admin.pm.client.pmTextField;
import com.sun.admin.pm.client.pmTop;
import com.sun.admin.pm.client.pmUserCancelledException;
import com.sun.admin.pm.client.pmUtility;
import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.NameService;
import com.sun.admin.pm.server.Printer;
import com.sun.admin.pm.server.PrinterUtil;
import com.sun.admin.pm.server.Valid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class pmAccess
extends pmButtonScreen {
    JComboBox portCombo;
    pmFrame frame = new pmFrame(pmUtility.getResource("SPM:Add.Access.To.Printer"));
    pmTextField pnameText;
    pmTextField snameText;
    pmTextField descText;
    Boolean makedefault;
    JCheckBox defaultp;
    Printer newpr = null;
    pmTop mytop;
    String printer = null;
    String server = null;
    String cmdLog = null;
    String errorLog = null;
    String warnLog = null;
    static final int OK = 1;
    static final int APPLY = 2;
    static final int RESET = 3;
    static final int CANCEL = 4;
    static final int HELP = 5;

    public pmAccess(pmTop pmTop2) {
        this.frame.setClearButtonsOnClose(true);
        this.setLayout(new BorderLayout());
        this.mytop = pmTop2;
        this.centerPanel();
        this.southPanel();
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Debug.message((String)"CLNT:  default cancel action");
                pmAccess.this.actioncancelButton();
            }
        }, KeyStroke.getKeyStroke(27, 0, false), 2);
        this.frame.setDefaultComponent(this.pnameText);
        Component component = this.frame.getGlassPane();
        component.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Debug.info((String)("Glass: " + keyEvent));
            }

            public void keyReleased(KeyEvent keyEvent) {
                Debug.info((String)("Glass: " + keyEvent));
            }

            public void keyTyped(KeyEvent keyEvent) {
                Debug.info((String)("Glass: " + keyEvent));
            }
        });
    }

    public void centerPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(pmUtility.getResource("Printer.Name:")), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(pmUtility.getResource("Printer.Server:")), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(pmUtility.getResource("Description:")), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel(pmUtility.getResource("Option:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        this.pnameText = new pmTextField(14);
        jPanel.add((Component)this.pnameText, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.snameText = new pmTextField(25);
        jPanel.add((Component)this.snameText, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.descText = new pmTextField(25);
        jPanel.add((Component)this.descText, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 3;
        this.defaultp = new JCheckBox(pmUtility.getResource("Default.Printer"));
        jPanel.add((Component)this.defaultp, gridBagConstraints);
        this.add("Center", jPanel);
    }

    public void createAccess() throws pmGuiException {
        boolean bl;
        boolean bl2 = true;
        String string = "";
        this.newpr = new Printer(this.mytop.ns);
        Debug.message((String)"CLNT: createAccess()");
        pmCalls.debugShowPrinter(this.newpr);
        this.printer = this.pnameText.getText().trim();
        this.server = this.snameText.getText().trim();
        string = this.descText.getText();
        if (this.printer.equals("")) {
            this.pnameText.requestFocus();
            Debug.message((String)"CLNT:pmAccess:Printer name required.");
            throw new pmIncompleteFormException(pmUtility.getResource("Printer.name.required."));
        }
        if (!Valid.remotePrinterName((String)this.printer)) {
            this.pnameText.requestFocus();
            Debug.message((String)("CLNT:pmAccess:Printer name invalid: " + this.printer));
            throw new pmIncompleteFormException(pmUtility.getResource("Printer.name.invalid."));
        }
        if (this.server.equals("")) {
            this.snameText.requestFocus();
            Debug.message((String)"CLNT:pmAccess:Server name required.");
            throw new pmIncompleteFormException(pmUtility.getResource("Server.name.required."));
        }
        if (!Valid.serverName((String)this.server)) {
            this.snameText.requestFocus();
            Debug.message((String)"CLNT:pmAccess:Server name invalid.");
            throw new pmIncompleteFormException(pmUtility.getResource("Server.name.invalid."));
        }
        try {
            pmTop pmTop2 = this.mytop;
            if (this.server.equals(pmTop2.host.getLocalHostName())) {
                this.snameText.requestFocus();
                bl2 = false;
            }
        }
        catch (Exception exception) {
            Debug.warning((String)"CLNT: pmAccess:createAccess:getLocalHostName exception");
            throw new pmGuiException(pmUtility.getResource("Could.not.get.local.hostname " + exception));
        }
        if (!bl2) {
            Debug.warning((String)"CLNT: pmAccess:createAccess:Server name required.");
            throw new pmMustBeRemoteServerException(pmUtility.getResource("Server.name.required."));
        }
        try {
            bl = PrinterUtil.exists((String)this.printer, (NameService)this.mytop.ns);
        }
        catch (Exception exception) {
            throw new pmGuiException(exception.toString());
        }
        if (bl) {
            throw new pmPrinterExistsException();
        }
        if (this.mytop.ns.getNameService().equals("nis") || this.mytop.ns.getNameService().equals("ldap")) {
            try {
                if (!this.mytop.ns.isAuth()) {
                    pmUtility.doLogin(this.mytop, this.frame);
                }
            }
            catch (pmUserCancelledException pmUserCancelledException2) {
                Debug.message((String)"CLNT:pmAccess:user cancelled login");
                throw new pmUserCancelledException(pmUtility.getResource("User.cancelled.login."));
            }
            catch (pmGuiException pmGuiException2) {
                Debug.message((String)("CLNT:pmAccess:login nis/nis+/ldap failed: " + pmGuiException2));
                throw new pmLoginFailedException();
            }
            catch (Exception exception) {
                Debug.message((String)("CLNT:pmAccess:login nis/nis+/ldap failed: " + exception));
                throw new pmLoginFailedException();
            }
        }
        Debug.message((String)("CLNT:pmAccess:checkbox: " + this.defaultp.isSelected()));
        if (this.mytop.getConfirmOption() && this.confirmAction() || !this.mytop.getConfirmOption()) {
            this.newpr.setPrinterName(this.printer);
            this.newpr.setPrintServer(this.server);
            this.newpr.setComment(string);
            if (this.defaultp.isSelected()) {
                this.newpr.setIsDefaultPrinter(true);
            }
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl3 = false;
            try {
                this.newpr.addRemotePrinter();
            }
            catch (Exception exception) {
                bl3 = true;
                Debug.warning((String)("CLNT:pmAccess:addRemotePrinter caught:" + exception));
            }
            this.frame.setCursor(Cursor.getDefaultCursor());
            this.gatherLogs();
            this.dumpLogs("CLNT:pmAccess:createAccess()");
            pmCalls.debugShowPrinter(this.newpr);
            this.mytop.setLogData(this.cmdLog, this.errorLog, this.warnLog);
            this.mytop.showLogData(pmUtility.getResource("Add.Access.To.Printer"));
            this.mytop.pmsetPrinterList();
            this.mytop.clearSelected();
            this.mytop.listTable.clearSelection();
            if (bl3) {
                throw new pmAddAccessFailedException(this.errorLog);
            }
        }
    }

    public void clearAccessInput() {
        try {
            this.pnameText.setText("");
            this.snameText.setText("");
            this.descText.setText("");
            if (this.defaultp.isSelected()) {
                this.defaultp.doClick();
            }
        }
        catch (Exception exception) {
            Debug.warning((String)("CLNT:pmAccess: Error clearAccessInput: " + exception));
        }
    }

    public boolean confirmAction() {
        if (this.mytop.getConfirmOption()) {
            pmOKCancelDialog pmOKCancelDialog2 = new pmOKCancelDialog((Frame)this.frame, pmUtility.getResource("Action.Confirmation"), pmUtility.getResource("Continue.creating.access.for.this.printer?"));
            pmOKCancelDialog2.setVisible(true);
            if (pmOKCancelDialog2.getValue() != 0) {
                pmMessageDialog pmMessageDialog2 = new pmMessageDialog((Frame)this.frame, pmUtility.getResource("Warning"), pmUtility.getResource("Operation.Cancelled"));
                pmMessageDialog2.setVisible(true);
                return false;
            }
        }
        return true;
    }

    void gatherLogs() {
        this.cmdLog = this.newpr.getCmdLog();
        this.errorLog = this.newpr.getErrorLog();
        this.warnLog = this.newpr.getWarnLog();
    }

    void dumpLogs(String string) {
        Debug.message((String)string);
        Debug.message((String)(string + " command: " + this.cmdLog));
        Debug.message((String)(string + " warnings: " + this.warnLog));
        Debug.message((String)(string + " errors: " + this.errorLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doAction() {
        boolean bl = false;
        try {
            this.createAccess();
            bl = true;
        }
        catch (pmIncompleteFormException pmIncompleteFormException2) {
            Debug.warning((String)("CLNT:pmAccess:incomplete form " + pmIncompleteFormException2.getMessage()));
            pmMessageDialog pmMessageDialog2 = new pmMessageDialog(this.frame, pmUtility.getResource("Error"), pmIncompleteFormException2.getMessage(), this.mytop, "AddAccessFailed");
            pmMessageDialog2.setVisible(true);
        }
        catch (pmPrinterExistsException pmPrinterExistsException2) {
            Debug.warning((String)"CLNT:pmAccess:printer exists");
            pmMessageDialog pmMessageDialog3 = new pmMessageDialog((Frame)this.frame, pmUtility.getResource("Error"), pmUtility.getResource("The.specified.printer.already.exists."));
            pmMessageDialog3.setVisible(true);
        }
        catch (pmMustBeRemoteServerException pmMustBeRemoteServerException2) {
            Debug.warning((String)"CLNT:pmAccess:server must be remove.");
            pmMessageDialog pmMessageDialog4 = new pmMessageDialog(this.frame, pmUtility.getResource("Error"), pmUtility.getResource("The.server.must.be.a.remote.server."), this.mytop, "RemoteServer");
            pmMessageDialog4.setVisible(true);
        }
        catch (pmLoginFailedException pmLoginFailedException2) {
            Debug.warning((String)"CLNT:pmAccess:Required login failed");
            pmMessageDialog pmMessageDialog5 = new pmMessageDialog(this.frame, pmUtility.getResource("Error"), pmUtility.getResource("Required.login.failed."), this.mytop, "LoginFailed");
            pmMessageDialog5.setVisible(true);
        }
        catch (pmAddAccessFailedException pmAddAccessFailedException2) {
            Debug.warning((String)("CLNT:pmAccess:add access failed " + pmAddAccessFailedException2.getMessage()));
            pmMessageDialog pmMessageDialog6 = new pmMessageDialog(this.frame, pmUtility.getResource("Error"), pmAddAccessFailedException2.getMessage(), this.mytop, "AddAccessFailed");
            pmMessageDialog6.setVisible(true);
        }
        catch (pmUserCancelledException pmUserCancelledException2) {
            Debug.message((String)"CLNT:pmAccess:createAccess: User cancelled namespace login");
        }
        catch (pmGuiException pmGuiException2) {
            Debug.warning((String)("CLNT:pmAccess:Application Error" + pmGuiException2.getMessage()));
            pmMessageDialog pmMessageDialog7 = new pmMessageDialog((Frame)this.frame, pmUtility.getResource("Application.Error"), pmGuiException2.getMessage());
            pmMessageDialog7.setVisible(true);
        }
        return bl;
    }

    public void pmScreendispose() {
        this.frame.dispose();
    }

    public void actionokButton() {
        Debug.message((String)"CLNT:pmAccess:actionokButton()");
        if (this.doAction()) {
            this.clearAccessInput();
            this.mytop.pmsetdefaultpLabel();
            this.frame.setVisible(false);
            this.frame.repaint();
            this.mytop.scrollPane.revalidate();
            this.mytop.scrollPane.repaint();
        } else {
            Debug.message((String)"CLNT: pmAccess: doAction is false");
        }
    }

    public void actionapplyButton() {
        Debug.message((String)"CLNT:pmAccess:actionapplyButton()");
        if (this.doAction()) {
            this.mytop.pmsetdefaultpLabel();
            this.mytop.scrollPane.revalidate();
            this.mytop.scrollPane.repaint();
        }
    }

    public void actionresetButton() {
        Debug.message((String)"CLNT:pmAccess:actionresetButton()");
        this.clearAccessInput();
        this.pnameText.requestFocus();
    }

    public void actioncancelButton() {
        Debug.message((String)"CLNT:pmAccess:actioncancelButton()");
        this.clearAccessInput();
        this.frame.setVisible(false);
        this.frame.repaint();
    }

    public void actionhelpButton() {
        Debug.message((String)"CLNT:pmAccess:actionhelpButton()");
        this.mytop.showHelpItem("AddAccess");
    }

    public void Show() {
        this.frame.getContentPane().add("North", this);
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.repaint();
        this.frame.toFront();
        this.frame.requestFocus();
        this.okButton.setAsDefaultButton();
        this.pnameText.requestFocus();
        Debug.message((String)"CLNT:pmAccess:Show()");
    }
}

