/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Random;

public class DigestSecurityUtil {
    private static final int MAX_PASSWORD_SIZE = 16;
    private static final int DIGEST_SESSION_KEY_SIZE = 20;
    private static Provider prov;
    private static SecureRandom random;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static MessageDigest digester;
    private static Signature signer;
    private static PrivateKey privkey;
    private static PublicKey pubkey;
    private static ByteArrayOutputStream outstr;
    private static PrintWriter prtwrtr;
    private static boolean initialized;
    private static final int RANDOM_KEYSIZE = 20;
    private static final char[] hex;

    public static void initialize(Provider provider, String digestAlgo, String signAlgo, String keygenAlgo, int keyStrength) throws AuthenticationException {
        if (initialized) {
            return;
        }
        prov = null;
        if (provider != (Provider)null) {
            prov = provider;
        }
        String msgid = null;
        String algo = null;
        String name = null;
        if (prov == (Provider)null) {
            name = "any";
            try {
                msgid = "EXSS_NDA";
                algo = digestAlgo;
                digester = MessageDigest.getInstance(algo, name);
                msgid = "EXSS_NSA";
                algo = signAlgo;
                signer = Signature.getInstance(algo, name);
            }
            catch (NoSuchAlgorithmException x) {
                throw new AuthenticationException(msgid, (Object)name, (Object)algo);
            }
            catch (NoSuchProviderException x) {
                throw new AuthenticationException("EXSS_SPI", (Object)name);
            }
        }
        name = prov.getName();
        try {
            msgid = "EXSS_NDA";
            algo = digestAlgo;
            digester = MessageDigest.getInstance(algo, name);
            msgid = "EXSS_NSA";
            algo = signAlgo;
            signer = Signature.getInstance(algo, name);
        }
        catch (NoSuchAlgorithmException x) {
            throw new AuthenticationException(msgid, (Object)name, (Object)algo);
        }
        catch (NoSuchProviderException x) {
            throw new AuthenticationException("EXSS_SPI", (Object)name);
        }
        try {
            byte[] seed = DigestSecurityUtil.getSeed();
            random = new SecureRandom(seed);
        }
        catch (Exception x) {
            throw new AuthenticationException("EXSS_NRN");
        }
        initialized = true;
    }

    public static synchronized void getRandomBytes(byte[] randBytes) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        random.nextBytes(randBytes);
    }

    public static synchronized byte[] getSessionKey() throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        byte[] rb = new byte[20];
        random.nextBytes(rb);
        return rb;
    }

    public static synchronized byte[] getBytes(Object obj) throws AuthenticationException {
        byte[] bytes;
        ObjectOutputStream oos;
        ByteArrayOutputStream bas;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            bas = new ByteArrayOutputStream(1024);
            oos = new ObjectOutputStream(bas);
        }
        catch (IOException ex) {
            throw new AuthenticationException("EXSS_OOS");
        }
        try {
            oos.writeObject(obj);
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_USO");
        }
        try {
            oos.flush();
            bytes = bas.toByteArray();
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_NBS");
        }
        try {
            oos.close();
            bas.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bytes;
    }

    public static synchronized byte[] generateDigest(byte[] byteArray1, byte[] byteArray2, byte[] byteArray3) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        digester.reset();
        if (byteArray1 != null) {
            digester.update(byteArray1);
        }
        if (byteArray2 != null) {
            digester.update(byteArray2);
        }
        if (byteArray3 != null) {
            digester.update(byteArray3);
        }
        byte[] digest = digester.digest();
        return digest;
    }

    public static synchronized byte[] generateDigest(Object[] objs) throws AuthenticationException {
        byte[] bytes;
        ObjectOutputStream oos;
        ByteArrayOutputStream bas;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            bas = new ByteArrayOutputStream(2048);
            oos = new ObjectOutputStream(bas);
        }
        catch (IOException ex) {
            throw new AuthenticationException("EXSS_OOS");
        }
        for (int i = 0; i < objs.length; ++i) {
            try {
                oos.writeObject(objs[i]);
                continue;
            }
            catch (Exception ex) {
                throw new AuthenticationException("EXSS_USO");
            }
        }
        try {
            oos.flush();
            bytes = bas.toByteArray();
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_NBS");
        }
        digester.reset();
        digester.update(bytes);
        byte[] digest = digester.digest();
        try {
            oos.close();
            bas.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return digest;
    }

    public static synchronized boolean compareDigests(byte[] digest_1, byte[] digest_2) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        return MessageDigest.isEqual(digest_1, digest_2);
    }

    public static synchronized byte[] signDigest(byte[] digest) throws AuthenticationException {
        byte[] result = null;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            signer.initSign(privkey);
            signer.update(digest);
            result = signer.sign();
        }
        catch (Exception x) {
            throw new AuthenticationException("EXSS_CSD");
        }
        return result;
    }

    public static synchronized boolean verifyDigest(byte[] digest, byte[] signature, PublicKey publicKey) throws AuthenticationException {
        boolean result = false;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        try {
            signer.initVerify(publicKey);
            signer.update(digest);
            result = signer.verify(signature);
        }
        catch (Exception x) {
            throw new AuthenticationException("EXSS_CVD");
        }
        return result;
    }

    public static synchronized byte[] encryptDigest(byte[] digest, byte[] key) throws AuthenticationException {
        int dl = digest.length;
        int kl = key.length;
        byte[] rb = new byte[dl];
        System.arraycopy(digest, 0, rb, 0, dl);
        int j = 0;
        for (int i = 0; i < dl; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ key[i]);
            if (++j <= kl) continue;
            j = 0;
        }
        return rb;
    }

    public static synchronized byte[] encryptPassword(byte[] key, byte[] pwb) throws AuthenticationException {
        int i;
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        byte[] rb = new byte[key.length];
        System.arraycopy(key, 0, rb, 0, key.length);
        byte[] pad = new byte[key.length];
        random.nextBytes(pad);
        for (i = 0; i < pwb.length; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
        }
        int n = i++;
        rb[n] = (byte)(rb[n] ^ 0);
        while (i < rb.length) {
            int n2 = i;
            rb[n2] = (byte)(rb[n2] ^ pad[i]);
            ++i;
        }
        return rb;
    }

    public static synchronized byte[] decryptPassword(byte[] key, byte[] pwb) throws AuthenticationException {
        if (!initialized) {
            throw new AuthenticationException("EXSS_SNI", (Object)"Digest");
        }
        if (key.length != pwb.length) {
            throw new AuthenticationException("EXSS_BEP");
        }
        byte[] rb = new byte[key.length];
        System.arraycopy(key, 0, rb, 0, key.length);
        boolean sw = true;
        int j = 0;
        int k = key.length;
        for (int i = 0; i < k; ++i) {
            int n = i;
            rb[n] = (byte)(rb[n] ^ pwb[i]);
            if (!sw || rb[i] != 0) continue;
            sw = false;
            j = i;
        }
        if (j < 1 || j > 16) {
            throw new AuthenticationException("EXSS_BEP");
        }
        byte[] pb = new byte[j];
        System.arraycopy(rb, 0, pb, 0, j);
        return pb;
    }

    private static synchronized byte[] getSeed() {
        byte[] kb1 = new byte[20];
        byte[] kb2 = new byte[20];
        byte[] seed = new byte[20];
        long time = System.currentTimeMillis();
        Random seeder = new Random(time);
        seeder.nextBytes(kb1);
        seeder.nextBytes(kb2);
        time = System.currentTimeMillis();
        long mask = 1L;
        long test = 0L;
        for (int i = 0; i < 20; ++i) {
            test = time & mask;
            seed[i] = test > 0L ? kb1[i] : kb2[i];
            mask <<= 1;
        }
        return seed;
    }

    private static synchronized String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    static {
        initialized = false;
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

