/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import java.io.Serializable;
import java.security.Principal;

public class AuthenticationPrincipal
implements Principal,
Cloneable,
Serializable {
    static final long serialVersionUID = -3789454378649277037L;
    public static final int AUTH_SOLARIS_USER = 0;
    public static final int AUTH_MGMT_SERVER = 1;
    public static final int AUTH_NT_USER = 2;
    private static final int AUTH_PRINCIPAL_TYPE_EOL = 2;
    private int type;
    private String name;
    private String role;
    private String host;
    private String userDesc = null;
    private String roleDesc = null;

    public AuthenticationPrincipal(int principalType, String principalName, String roleName) throws AuthenticationException {
        if (principalType < 0 || principalType > 2) {
            throw new AuthenticationException("EXSS_IPT", (Object)new Integer(principalType));
        }
        this.type = principalType;
        if (principalName == null || principalName.trim().length() == 0) {
            throw new AuthenticationException("EXSS_IPN");
        }
        this.name = principalName;
        this.role = roleName == null || roleName.trim().length() == 0 ? null : roleName;
        this.host = null;
    }

    public boolean equals(Object other) {
        AuthenticationPrincipal ap = null;
        boolean bool = false;
        if (other instanceof AuthenticationPrincipal && (ap = (AuthenticationPrincipal)other).getUserType() == this.type && this.name.equals(ap.getName())) {
            String str = ap.getRoleName();
            if (this.role != null && str != null) {
                if (this.role.equals(str)) {
                    bool = true;
                }
            } else if (this.role == null && str == null) {
                bool = true;
            }
        }
        return bool;
    }

    public String getName() {
        return this.role == null ? this.name : this.role;
    }

    public String toString() {
        String str1;
        switch (this.type) {
            case 0: {
                str1 = "Solaris-user: ";
                break;
            }
            case 1: {
                str1 = "Mgmt-server: ";
                break;
            }
            case 2: {
                str1 = "NT-user: ";
                break;
            }
            default: {
                str1 = "Unknown-type: ";
            }
        }
        String str2 = str1 + this.name;
        if (this.userDesc != null) {
            str2 = str2 + "(" + this.userDesc + ")";
        }
        if (this.role != null) {
            str2 = str2 + " in role: " + this.role;
        }
        if (this.roleDesc != null) {
            str2 = str2 + "(" + this.roleDesc + ")";
        }
        if (this.host != null) {
            str2 = str2 + " at host: " + this.host;
        }
        return str2;
    }

    public int hashCode() {
        String str = new String(this.type + this.name);
        if (this.role != null) {
            str = str.concat(this.role);
        }
        return str.hashCode();
    }

    public String getUserName() {
        return this.name;
    }

    public int getUserType() {
        return this.type;
    }

    public String getRoleName() {
        return this.role;
    }

    public String getHostName() {
        return this.host;
    }

    public void setHostName(String hostName) {
        this.host = hostName;
    }

    public AuthenticationPrincipal newCopy() throws AuthenticationException {
        AuthenticationPrincipal ap = new AuthenticationPrincipal(this.type, this.name, this.role);
        if (this.host != null) {
            ap.setHostName(this.host);
        }
        return ap;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public String getRoleDesc() {
        return this.roleDesc;
    }

    public void setUserDesc(String newDesc) {
        this.userDesc = newDesc;
    }

    public void setRoleDesc(String newDesc) {
        this.roleDesc = newDesc;
    }
}

