/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.VPermission;
import com.sun.management.viper.VPolicy;
import com.sun.management.viperimpl.util.ResourceStringReader;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class PolicyAdder {
    public static final int SUCCESS = 0;
    public static final int INVALID_USAGE = 1;
    public static final int INVALID_POLICY = 2;
    public static final int NOPERMISSION = 3;
    private static final String AUTH_ATTR_FILE = "/etc/security/auth_attr";
    private static final String AUTH_HELP_DIR = "/usr/lib/help/auths/locale";
    private static final String PROF_ATTR_FILE = "/etc/security/prof_attr";
    private static final String PROF_HELP_DIR = "/usr/lib/help/profiles/locale";
    private static final String RESOURCE_BUNDLE = "com.sun.management.viperimpl.server.repository.RepositoryServiceResources";
    private static String currentFile = null;
    private static ResourceStringReader resource = null;

    public static void main(String[] argvs) {
        resource = new ResourceStringReader(RESOURCE_BUNDLE);
        if (argvs.length != 1) {
            System.err.println(resource.getString("BadUsage"));
            System.exit(1);
        }
        VPolicy policy = null;
        try {
            policy = (VPolicy)Class.forName(argvs[0]).newInstance();
        }
        catch (Exception e) {
            System.err.println(resource.getString("BadPolicyClass") + ": " + e.getLocalizedMessage());
            System.exit(2);
        }
        VPermission[] perms = policy.getPermissions();
        if (perms != null && perms.length > 0) {
            int size = 0;
            String newSegment = "";
            for (int i = 0; i < perms.length; ++i) {
                if (!PolicyAdder.isDuplicated(perms[i])) {
                    String file;
                    String row = PolicyAdder.toAuthAttrRow(perms[i]);
                    newSegment = newSegment + row + "\n";
                    ++size;
                    System.err.println(resource.getString("VerifyingPermission", perms[i].getName()));
                    String root = perms[i].getHelpDir();
                    if (root == null || root.trim().length() == 0) {
                        root = ".";
                    }
                    if ((file = perms[i].getHelpFile()) == null || file.trim().length() <= 0) continue;
                    System.out.println("/usr/lib/help/auths/locale\t" + root + "\t" + file);
                    continue;
                }
                System.err.println(resource.getString("SkipPermission", perms[i].getName()));
            }
            if (size > 0) {
                try {
                    FileOutputStream fw = new FileOutputStream(AUTH_ATTR_FILE, true);
                    PrintWriter aafile = new PrintWriter(fw);
                    aafile.print("# Automatically added by SMC\n" + newSegment);
                    aafile.close();
                    fw.close();
                }
                catch (IOException ioe) {
                    System.err.println(resource.getString("CannotUpdateAttr") + ": " + ioe.getLocalizedMessage());
                    System.exit(3);
                }
            }
        }
        System.exit(0);
    }

    private static boolean isDuplicated(VPermission perm) {
        if (perm == null || perm.getName() == null || perm.getName().length() == 0) {
            return true;
        }
        if (currentFile == null) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(AUTH_ATTR_FILE));
                currentFile = "";
                String line = null;
                while ((line = reader.readLine()) != null) {
                    currentFile = currentFile + "^" + line.trim();
                }
                reader.close();
            }
            catch (IOException ioe) {
                System.err.println(resource.getString("CannotReadAttr") + " :" + ioe.getLocalizedMessage());
                System.exit(3);
            }
        }
        return currentFile.indexOf("^" + perm.getName()) >= 0;
    }

    private static String toAuthAttrRow(VPermission perm) {
        return perm.getName() + ":::" + (perm.getShortDesc() == null ? "" : perm.getShortDesc()) + "::" + (perm.getHelpFile() == null ? "" : "help=" + perm.getHelpFile());
    }
}

