/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfo;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.util.ResourceStringReader;
import com.sun.management.viperimpl.xml.viperbean.DescriptorManager;
import java.io.File;

public class InfoCheck {
    private static final int P_OPTION = 4;
    private static ResourceStringReader resource;

    public static void main(String[] argv) {
        resource = new ResourceStringReader("com.sun.management.viperimpl.server.repository.RepositoryServiceResources");
        int retValue = 1;
        if (argv[0].equals("-R")) {
            retValue = InfoCheck.checkBean(argv[1]);
        } else if (argv[0].equals("-A")) {
            retValue = InfoCheck.checkJarEntry(argv[1], argv[2]);
        } else if (argv[0].equals("-P")) {
            retValue = InfoCheck.checkProperties(argv[1].trim(), argv[2].trim(), argv[3]);
        }
        System.exit(retValue);
    }

    private static int checkProperties(String keyStr, String beanName, String libName) {
        return VRegistry.checkProperties(keyStr, beanName, libName);
    }

    private static int checkJarEntry(String beanName, String jarBaseName) {
        return VRegistry.checkJarEntry(beanName, jarBaseName);
    }

    private static int checkBean(String infoXMLName) {
        ComponentInfo obj = null;
        try {
            obj = DescriptorManager.createDescriptor(new File(infoXMLName).toURL());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (obj == null) {
            System.err.println();
            System.err.println(resource.getString("InfoReadError", infoXMLName));
            System.exit(1);
        }
        if (obj instanceof ServiceInfo) {
            ServiceInfo info = (ServiceInfo)obj;
            return VRegistry.checkBean(info);
        }
        if (obj instanceof ToolInfo) {
            ToolInfo info = (ToolInfo)obj;
            return VRegistry.checkBean(info);
        }
        if (obj instanceof ExternalClientProviderInfo) {
            ExternalClientProviderInfo info = (ExternalClientProviderInfo)obj;
            return VRegistry.checkBean(info);
        }
        return 1;
    }
}

