/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.BeanNotFoundException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.ServiceProxy;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viper.services.Authorization;
import com.sun.management.viper.services.AuthorizationException;
import com.sun.management.viper.services.Log;
import com.sun.management.viper.services.ServiceList;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ConnectionInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.Viper;
import com.sun.management.viperimpl.ViperImplVersion;
import com.sun.management.viperimpl.server.ServiceACManager;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.RepositoryException;
import com.sun.management.viperimpl.server.repository.RepositoryService;
import com.sun.management.viperimpl.services.LogRecord;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.NoSecureSessionException;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationService;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ViperImpl
extends UnicastRemoteObject
implements Viper,
ServiceInfrastructure {
    static final long serialVersionUID = -3430808449060039361L;
    private Vector result = new Vector(10, 10);
    private Vector error = new Vector(10, 10);
    private static Log log = null;
    private static Authorization congress = null;
    private static RepositoryService rep = null;
    private static String[] cores = new String[]{ServiceList.LOG, ServiceList.AUTHORIZATION};
    private Properties config = null;
    private Hashtable beanUsageTable = new Hashtable();
    private VCallerImpl serviceRole = null;
    private ServiceACManager sacManager = null;
    private static Vector logBuffer = new Vector();
    private String msg = null;
    public final int SMC_BEAN_COMPONENT = 0;
    public final int SMC_EXE_COMPONENT = 1;
    private Hashtable localLoadedServices = new Hashtable();

    public ViperImpl(Properties props) throws RemoteException, VException {
        this.config = props;
        this.init(props);
    }

    public SecurityToken authRequest(String type, SecurityToken token) throws RemoteException, VException {
        return AuthenticationService.authRequest(type, token);
    }

    public ServiceAgent getServiceObject(String serviceName, SecurityToken token) throws RemoteException, VException {
        ServiceAgent sa = null;
        Object[] objs = new Object[]{serviceName};
        this.checkToken(token, objs);
        if (serviceName == null) {
            return null;
        }
        VCallerImpl caller = this.getCallerId(token);
        if (rep == null) {
            this.msg = "Repository didn't initialized";
            Debug.trace((String)"ViperImpl", (int)Debug.ERROR, (String)this.msg, null);
            throw new RepositoryException(this.msg);
        }
        sa = rep.getServiceAgent(serviceName, caller, null);
        this.msg = "Service agent " + sa + " created";
        Debug.trace((String)"ViperImpl", (int)Debug.INFORMATION, (String)this.msg, null);
        ConnectionInfo ci = this.findConnectionInfo(token);
        ci.addService(serviceName);
        return sa;
    }

    public Vector getServiceInfoImplList(SecurityToken token) throws RemoteException, VException {
        this.checkToken(token, null);
        String user = this.getCallerId(token).getName();
        return rep.getServiceInfoList();
    }

    public ServiceInfoImpl[] getServiceInfoImpl(String servicename, SecurityToken token) throws RemoteException, VException {
        Object[] objs = new Object[]{servicename};
        this.checkToken(token, objs);
        String user = this.getCallerId(token).getName();
        return rep.getServiceInfo(servicename);
    }

    public Vector getToolInfoImplList() throws RemoteException, VException {
        return rep.getToolInfoList();
    }

    public ToolInfoImpl getToolInfoImpl(String toolname) throws RemoteException, VException {
        return rep.getToolInfo(toolname);
    }

    public ExternalClientProviderInfoImpl[] getExternalClientProviderInfoImpl(String clientType, SecurityToken token) throws RemoteException, VException {
        Object[] objs = new Object[]{clientType};
        this.checkToken(token, objs);
        return rep.getExternalClientProviderInfo(clientType);
    }

    public URL getCodebase() throws RemoteException, VException {
        StringTokenizer st;
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase != null && (st = new StringTokenizer(codebase)).countTokens() > 0) {
            codebase = st.nextToken();
        }
        try {
            return new URL(codebase);
        }
        catch (MalformedURLException ue) {
            throw new VException("Server codebase was not set correctly.");
        }
    }

    public URL getToolURL(String name, SecurityToken token) throws RemoteException, VException {
        Object[] objs = new Object[]{name};
        this.checkToken(token, objs);
        URL codebase = this.getCodebase();
        if (codebase == null) {
            throw new VException("Server codebase not setup");
        }
        if (rep == null) {
            throw new RepositoryException("Repository is not avaiable");
        }
        String jarName = rep.getToolJarName(name);
        if (jarName == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)name);
        }
        URL result = null;
        try {
            result = new URL(codebase, jarName);
        }
        catch (MalformedURLException ue) {
            throw new VException("Server codebase URL format error:" + ue.getMessage());
        }
        return result;
    }

    public void refTool(String toolname, SecurityToken token) throws RemoteException, VException {
        Object[] params = new Object[]{toolname};
        this.checkToken(token, params);
        ConnectionInfo ci = this.findConnectionInfo(token);
        ci.addTool(toolname);
    }

    public void refServiceProxy(String proxyname, SecurityToken token) throws RemoteException, VException {
        Object[] params = new Object[]{proxyname};
        this.checkToken(token, params);
        ConnectionInfo ci = this.findConnectionInfo(token);
        ci.addService(proxyname);
    }

    public void derefTool(String toolname, SecurityToken token) throws RemoteException, VException {
        Object[] params = new Object[]{toolname};
        this.checkToken(token, params);
        ConnectionInfo ci = this.findConnectionInfo(token);
        ci.removeTool(toolname);
    }

    public void derefService(String servicename, SecurityToken token) throws RemoteException, VException {
        Object[] params = new Object[]{servicename};
        this.checkToken(token, params);
        ConnectionInfo ci = this.findConnectionInfo(token);
        ci.removeService(servicename);
    }

    public ConnectionInfo[] connectionList(SecurityToken token) throws RemoteException, VException {
        this.checkToken(token, null);
        return this.getCurrentConnectionList();
    }

    public VCallerImpl getCallerImpl(SecurityToken token) throws RemoteException, VException {
        this.checkToken(token, null);
        return this.getCallerId(token);
    }

    public void stopServer(SecurityToken token) throws RemoteException, VException {
        this.checkToken(token, null);
        ViperServer.exitServer((VIdentity)this.getCallerId(token), 0);
    }

    public void restartServer(int port, SecurityToken token) throws RemoteException, VException {
        Object[] params = new Object[]{new Integer(port)};
        this.checkToken(token, params);
        ViperServer.exitServer((VIdentity)this.getCallerId(token), 0);
    }

    public String getViperImplVersion() throws RemoteException {
        return ViperImplVersion.getFullVersion();
    }

    public Service getServiceByName(String name) throws VException {
        return this.getServiceByName(name, false);
    }

    public Service getServiceByName(String name, boolean useDelegation) throws VException {
        if (name == null) {
            String[] pars = new String[]{"null"};
            throw new BeanNotFoundException("ServiceNotFound", (Object)pars);
        }
        ServiceAgent sa = rep.getServiceAgent(name, this.serviceRole, null);
        if (sa != null) {
            if (useDelegation) {
                sa.setDelegationConext(this.sacManager);
            } else {
                sa.setContext(this.sacManager);
            }
        } else {
            String[] pars = new String[]{name};
            throw new BeanNotFoundException("ServiceNotFound", (Object)pars);
        }
        this.localLoadedServices.put(sa, name);
        return sa;
    }

    public void releaseService(Service s) throws VException {
        if (s != null) {
            if (s instanceof ServiceProxy) {
                try {
                    ServiceProxy sp = (ServiceProxy)s;
                    sp.stop();
                    sp.destroy();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            String string = (String)this.localLoadedServices.remove(s);
        }
    }

    public Tool getToolByName(String name) throws VException {
        return null;
    }

    public ServiceInfo getServiceInfo(String name) throws VException {
        return rep.getServiceInfo(name)[0];
    }

    public ToolInfo getToolInfo(String name) throws VException {
        return rep.getToolInfo(name);
    }

    public VIdentity getIdentity() {
        return this.serviceRole;
    }

    public Object getExternalClient(String type, Object[] params) throws Exception {
        return null;
    }

    ConnectionInfo[] getCurrentConnectionList() throws RemoteException, VException {
        Hashtable updatedUsage = new Hashtable();
        Enumeration e = this.beanUsageTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ConnectionInfo ci = (ConnectionInfo)this.beanUsageTable.get(key);
            try {
                this.checkSecureConnection(ci.getUserId().getToken());
                updatedUsage.put(key, ci);
            }
            catch (AuthenticationException ae) {}
        }
        this.beanUsageTable = updatedUsage;
        Collection result = updatedUsage.values();
        return result.toArray(new ConnectionInfo[0]);
    }

    private void init(Properties props) throws VException {
        this.msg = "In ViperImpl init";
        Debug.trace((String)"ViperImpl", (int)Debug.INFORMATION, (String)this.msg, null);
        String processOwner = AuthenticationLibrary.getProcessOwnerName();
        if (processOwner == null) {
            this.serviceRole = null;
        } else {
            try {
                this.serviceRole = new VCallerImpl(processOwner, "SMC Service", "localhost", "localhost", null);
                int uid = Integer.parseInt(AuthenticationLibrary.getUid(processOwner));
                int gid = Integer.parseInt(AuthenticationLibrary.getGid(processOwner));
                this.serviceRole.setUid(uid);
                this.serviceRole.setGid(gid);
                this.serviceRole.setShell(AuthenticationLibrary.getShell(processOwner));
                this.serviceRole.setHome(AuthenticationLibrary.getHomedir(processOwner));
            }
            catch (NumberFormatException nfe) {
                throw new VException("Can't retrieve current process uid or gid.");
            }
        }
        this.sacManager = new ServiceACManager(this);
        this.buildServices();
        AuthenticationService.init(props, log);
    }

    private void buildServices() throws VException {
        Debug.trace((String)"ViperImpl", (int)Debug.INFORMATION, (String)"*****  Building Core Services ******", null);
        rep = new RepositoryService(cores, this, this.sacManager);
        log = (Log)rep.getCoreService(ServiceList.LOG);
        ViperImpl.flushLogBuffer();
        congress = (Authorization)rep.getCoreService(ServiceList.AUTHORIZATION);
    }

    void onExit() {
        rep.unload();
    }

    private ConnectionInfo findConnectionInfo(SecurityToken token) throws AuthenticationException {
        ConnectionInfo ci = (ConnectionInfo)this.beanUsageTable.get(new Long(token.getSecurityId()));
        if (ci == null) {
            ServerSecurityContext ssc = this.checkSecureConnection(token);
            ci = new ConnectionInfo(this.getCallerId(token), ssc.getStartTime());
            this.beanUsageTable.put(new Long(token.getSecurityId()), ci);
        }
        return ci;
    }

    protected VCallerImpl getServiceRole() {
        return this.serviceRole;
    }

    protected void checkToken(SecurityToken token, Object[] objs) throws AuthenticationException {
        if (!(token instanceof MessageSecurityToken)) {
            throw new AuthenticationMessageException();
        }
        ServerSecurityContext ssc = this.checkSecureConnection(token);
        ssc.verifyMessageToken((MessageSecurityToken)token, objs);
    }

    protected VCallerImpl getCallerId(SecurityToken token) throws AuthenticationException {
        ServerSecurityContext ssc = this.checkSecureConnection(token);
        AuthenticationPrincipal ap = ssc.getAuthPrincipal();
        String fromHost = "unknown";
        try {
            fromHost = this.getClientHost();
        }
        catch (ServerNotActiveException e) {
            // empty catch block
        }
        VCallerImpl result = new VCallerImpl(ap, fromHost, token);
        result.setUid(ssc.getUid());
        result.setGid(ssc.getGid());
        result.setShell(ssc.getShell());
        result.setHome(ssc.getHome());
        return result;
    }

    protected ServerSecurityContext checkSecureConnection(SecurityToken token) throws AuthenticationException {
        ServerSecurityContext ssc = AuthenticationService.lookupSecurityContext(token);
        if (ssc == null || ssc.getAuthState() != 4) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Attempt to call method when secure session not established or expired", null);
            throw new NoSecureSessionException();
        }
        return ssc;
    }

    protected void checkPermission(VIdentity user, VPermission perm) throws RemoteException, AuthorizationException {
        if (congress == null) {
            throw new AuthorizationException("Authorization Service not installed.");
        }
        congress.checkPermission((Principal)user, perm);
    }

    static void writeBufferedLog(String sourceKey, String category, int severity, String sumKey, String detKey, String[] fargs, String resource, String data) {
        ViperImpl.appendLogBuffer(sourceKey, category, severity, sumKey, detKey, fargs, resource, data);
        if (log != null) {
            ViperImpl.flushLogBuffer();
        }
    }

    private static void appendLogBuffer(String sourceKey, String category, int severity, String sumKey, String detKey, String[] fargs, String resource, String data) {
        logBuffer.add(new LogRecord(sourceKey, category, severity, sumKey, detKey, fargs, resource, data));
    }

    private static void flushLogBuffer() {
        for (int i = 0; i < logBuffer.size(); ++i) {
            LogRecord lr = (LogRecord)logBuffer.elementAt(i);
            ViperImpl.writeLog(lr.sourceKey, lr.category, lr.severity, lr.sumKey, lr.detKey, lr.fargs, lr.resource, lr.data);
        }
        logBuffer.clear();
    }

    private static void writeLog(String sourceKey, String category, int severity, String sumKey, String detKey, String[] fargs, String resource, String data) {
        if (log == null) {
            return;
        }
        try {
            log.writeLog(sourceKey, category, severity, sumKey, detKey, fargs, resource, data);
        }
        catch (RemoteException e) {
            Debug.trace((String)"Server", (int)Debug.ERROR, (String)"exception from log service", (Throwable)e);
        }
        catch (Throwable t) {
            Debug.trace((String)"Server", (int)Debug.ERROR, (String)"exception from log service", (Throwable)t);
        }
    }
}

