/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viperimpl.ContainerContext;
import com.sun.management.viperimpl.DelegationAgentContext;
import com.sun.management.viperimpl.DelegationSecurityToken;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.server.ViperImpl;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.services.authentication.SecurityToken;

public class ServiceACManager
implements DelegationAgentContext,
ContainerContext {
    private long delegationKey = 0L;
    private ViperImpl daemon = null;

    ServiceACManager(ViperImpl vi) {
        this.daemon = vi;
    }

    public SecurityToken generateMessageToken(Object[] params) throws AuthenticationException {
        return this.generateDelegationToken(this.daemon.getServiceRole());
    }

    public DelegationSecurityToken generateDelegationToken(VCallerImpl delegate) throws AuthenticationException {
        while (this.delegationKey == 0L) {
            this.delegationKey = ViperServer.getRandom().nextLong();
        }
        return new DelegationSecurityToken(this.delegationKey, delegate);
    }

    public VCallerImpl verifyMessageToken(SecurityToken token, Object[] objs) throws AuthenticationException {
        if (token instanceof DelegationSecurityToken) {
            return this.verifyDelegationToken((DelegationSecurityToken)token);
        }
        this.daemon.checkToken(token, objs);
        return this.daemon.getCallerId(token);
    }

    public VCallerImpl verifyDelegationToken(DelegationSecurityToken delegationToken) throws AuthenticationException {
        if (delegationToken == null) {
            throw new AuthenticationException("EXSS_BVD");
        }
        if (delegationToken.getSecurityId() != this.delegationKey) {
            throw new AuthenticationMessageException();
        }
        return delegationToken.getDelegate();
    }
}

