/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.rmic2;

import com.sun.management.viperimpl.rmic2.Generator;
import com.sun.management.viperimpl.rmic2.Names;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.rmi.rmic.BatchEnvironment;
import sun.rmi.rmic.RMIConstants;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.ClassPath;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;

public class Main
implements RMIConstants {
    String classPathString;
    File destDir;
    int flags;
    long tm;
    Vector v;
    boolean nowrite;
    String props;
    boolean keepGenerated;
    int stubVersion;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public Main(OutputStream out, String program) {
        this.out = out;
        this.program = program;
    }

    public void output(String msg) {
        PrintStream out = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        out.println(msg);
    }

    private void error(String msg) {
        this.output(Main.getText(msg));
    }

    private void error(String msg, String arg1) {
        this.output(Main.getText(msg, arg1));
    }

    private void error(String msg, String arg1, String arg2) {
        this.output(Main.getText(msg, arg1, arg2));
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }

    public synchronized boolean compile(String[] argv) {
        if (!this.parseArgs(argv)) {
            return false;
        }
        if (this.v.size() == 0) {
            this.usage();
            return false;
        }
        return this.doCompile();
    }

    public boolean parseArgs(String[] argv) {
        this.destDir = null;
        this.flags = 4;
        this.tm = System.currentTimeMillis();
        this.v = new Vector();
        this.nowrite = false;
        this.props = null;
        this.keepGenerated = false;
        this.stubVersion = 2;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-g")) {
                this.flags &= 0xFFFFBFFF;
                this.flags |= 0x3000;
                continue;
            }
            if (argv[i].equals("-O")) {
                this.flags &= 0xFFFFEFFF;
                this.flags &= 0xFFFFDFFF;
                this.flags |= 0x4020;
                continue;
            }
            if (argv[i].equals("-nowarn")) {
                this.flags &= 0xFFFFFFFB;
                continue;
            }
            if (argv[i].equals("-debug")) {
                this.flags |= 2;
                continue;
            }
            if (argv[i].equals("-depend")) {
                this.flags |= 0x20;
                continue;
            }
            if (argv[i].equals("-verbose")) {
                this.flags |= 1;
                continue;
            }
            if (argv[i].equals("-nowrite")) {
                this.nowrite = true;
                continue;
            }
            if (argv[i].equals("-keep") || argv[i].equals("-keepgenerated")) {
                this.keepGenerated = true;
                continue;
            }
            if (argv[i].equals("-show")) {
                this.error("rmic.option.unsupported", "-show");
                this.usage();
                return false;
            }
            if (argv[i].equals("-classpath")) {
                if (i + 1 < argv.length) {
                    if (this.classPathString != null) {
                        this.error("rmic.option.already.seen", "-classpath");
                        this.usage();
                        return false;
                    }
                    this.classPathString = argv[++i];
                    continue;
                }
                this.error("rmic.option.requires.argument", "-classpath");
                this.usage();
                return false;
            }
            if (argv[i].equals("-d")) {
                if (i + 1 < argv.length) {
                    if (this.destDir != null) {
                        this.error("rmic.option.already.seen", "-d");
                        this.usage();
                        return false;
                    }
                    this.destDir = new File(argv[++i]);
                    if (this.destDir.exists()) continue;
                    this.error("rmic.no.such.directory", this.destDir.getPath());
                    this.usage();
                    return false;
                }
                this.error("rmic.option.requires.argument", "-d");
                this.usage();
                return false;
            }
            if (argv[i].equals("-v1.1")) {
                this.stubVersion = 1;
                continue;
            }
            if (argv[i].equals("-vcompat")) {
                this.stubVersion = 2;
                continue;
            }
            if (argv[i].equals("-v1.2")) {
                this.stubVersion = 3;
                continue;
            }
            if (argv[i].startsWith("-")) {
                this.error("rmic.no.such.option", argv[i]);
                this.usage();
                return false;
            }
            this.v.addElement(argv[i]);
        }
        return true;
    }

    public boolean doCompile() {
        BatchEnvironment env;
        block38: {
            ClassPath classPath = this.classPathString != null ? new ClassPath(this.classPathString) : new ClassPath();
            env = new BatchEnvironment(this.out, classPath, null);
            env.flags |= this.flags;
            switch (this.stubVersion) {
                case 1: 
                case 2: {
                    env.majorVersion = (short)48;
                    env.minorVersion = 0;
                    break;
                }
                default: {
                    env.majorVersion = (short)45;
                    env.minorVersion = (short)3;
                }
            }
            String noMemoryErrorString = Main.getText("rmic.no.memory");
            String stackOverflowErrorString = Main.getText("rmic.stack.overflow");
            Vector javacClasslist = new Vector();
            try {
                int j;
                for (int i = this.v.size() - 1; i >= 0; --i) {
                    Identifier implClassName = Identifier.lookup((String)((String)this.v.elementAt(i)));
                    implClassName = env.resolvePackageQualifiedName(implClassName);
                    implClassName = Names.mangleClass(implClassName);
                    ClassDeclaration decl = env.getClassDeclaration(implClassName);
                    try {
                        ClassDefinition def = decl.getClassDefinition((Environment)env);
                        Generator.generate(env, def, this.destDir, this.stubVersion, javacClasslist);
                        continue;
                    }
                    catch (ClassNotFound ex) {
                        env.error(0L, "rmic.class.not.found", (Object)implClassName);
                    }
                }
                ByteArrayOutputStream buf = new ByteArrayOutputStream(4096);
                Vector<String> containerClassList = new Vector<String>();
                if (javacClasslist.size() > 0) {
                    int k = javacClasslist.size();
                    if (this.classPathString != null) {
                        k += 2;
                    }
                    if (this.destDir != null) {
                        k += 2;
                    }
                    String[] javacParams = new String[k];
                    k = 0;
                    if (this.classPathString != null) {
                        javacParams[k++] = "-classpath";
                        javacParams[k++] = this.classPathString;
                    }
                    if (this.destDir != null) {
                        javacParams[k++] = "-d";
                        javacParams[k++] = this.destDir.getName();
                    }
                    for (j = 0; j < javacClasslist.size(); ++j) {
                        File generatedFile = (File)javacClasslist.elementAt(j);
                        javacParams[k + j] = generatedFile.toString();
                        if (!javacParams[k + j].endsWith("_Container.java")) continue;
                        String cpath = javacParams[k + j].replaceFirst("./", "");
                        cpath = cpath.replaceAll("/", ".");
                        cpath = cpath.replaceAll(".java", "");
                        containerClassList.addElement(cpath);
                    }
                    new com.sun.tools.javac.Main();
                    com.sun.tools.javac.Main.compile(javacParams);
                }
                if (containerClassList.size() > 0) {
                    int k = containerClassList.size();
                    if (this.keepGenerated) {
                        ++k;
                    }
                    if (this.stubVersion == 3) {
                        ++k;
                    }
                    if (this.classPathString != null) {
                        k += 2;
                    }
                    if (this.destDir != null) {
                        k += 2;
                    }
                    String[] rmicParams = new String[k];
                    k = 0;
                    if (this.keepGenerated) {
                        rmicParams[k++] = "-keepgenerated";
                    }
                    if (this.stubVersion == 3) {
                        rmicParams[k++] = "-v1.2";
                    }
                    if (this.classPathString != null) {
                        rmicParams[k++] = "-classpath";
                        rmicParams[k++] = this.classPathString;
                    }
                    if (this.destDir != null) {
                        rmicParams[k++] = "-d";
                        rmicParams[k++] = this.destDir.getName();
                    }
                    for (j = 0; j < containerClassList.size(); ++j) {
                        rmicParams[k + j] = (String)containerClassList.elementAt(j);
                    }
                    new sun.rmi.rmic.Main((OutputStream)System.out, "rmic").compile(rmicParams);
                }
            }
            catch (OutOfMemoryError ee) {
                env.output(noMemoryErrorString);
                return false;
            }
            catch (StackOverflowError ee) {
                env.output(stackOverflowErrorString);
                return false;
            }
            catch (Error ee) {
                if (env.nerrors == 0 || env.dump()) {
                    ee.printStackTrace();
                    env.error(0L, "fatal.error");
                }
            }
            catch (Exception ee) {
                if (env.nerrors != 0 && !env.dump()) break block38;
                ee.printStackTrace();
                env.error(0L, "fatal.exception");
            }
        }
        env.flushErrors();
        boolean status = true;
        if (env.nerrors > 0) {
            String msg = "";
            msg = env.nerrors > 1 ? Main.getText("rmic.errors", env.nerrors) : Main.getText("rmic.1error");
            if (env.nwarnings > 0) {
                msg = env.nwarnings > 1 ? msg + ", " + Main.getText("rmic.warnings", env.nwarnings) : msg + ", " + Main.getText("rmic.1warning");
            }
            this.output(msg);
            status = false;
        } else if (env.nwarnings > 0) {
            if (env.nwarnings > 1) {
                this.output(Main.getText("rmic.warnings", env.nwarnings));
            } else {
                this.output(Main.getText("rmic.1warning"));
            }
        }
        try {
            if (!this.keepGenerated) {
                env.deleteGeneratedFiles();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        env.shutdown();
        if (env.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(Main.getText("rmic.done_in", Long.toString(this.tm)));
        }
        return status;
    }

    public static void main(String[] argv) {
        Main compiler = new Main(System.out, "rmic");
        System.exit(compiler.compile(argv) ? 0 : 1);
    }

    public static String getString(String key) {
        if (!resourcesInitialized) {
            Main.initResources();
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("sun.rmi.rmic.resources.rmic");
            resourcesInitialized = true;
        }
        catch (MissingResourceException e) {
            throw new Error("fatal: missing resource bundle: " + e.getClassName());
        }
    }

    public static String getText(String key) {
        String message = Main.getString(key);
        if (message == null) {
            message = "no text found: \"" + key + "\"";
        }
        return message;
    }

    public static String getText(String key, int num) {
        return Main.getText(key, Integer.toString(num), null, null);
    }

    public static String getText(String key, String arg0) {
        return Main.getText(key, arg0, null, null);
    }

    public static String getText(String key, String arg0, String arg1) {
        return Main.getText(key, arg0, arg1, null);
    }

    public static String getText(String key, String arg0, String arg1, String arg2) {
        String format = Main.getString(key);
        if (format == null) {
            format = "no text found: key = \"{0}\", arguments = \"{1}\", \"{2}\", \"{3}\"";
        }
        Object[] args = new String[]{arg0 != null ? arg0.toString() : "null", arg1 != null ? arg1.toString() : "null", arg2 != null ? arg2.toString() : "null"};
        return MessageFormat.format(format, args);
    }
}

