/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class ListDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2079;
    }

    public int getDataLength(Object value) {
        return ((ListData)value).length();
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        return content;
    }

    static final class ListData {
        final Object[] data;
        private String canonical;

        public int length() {
            return this.data.length;
        }

        public Object item(int index) {
            return this.data[index];
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListData)) {
                return false;
            }
            int count = this.data.length;
            Object[] odata = ((ListData)obj).data;
            if (count != odata.length) {
                return false;
            }
            int i = 0;
            while (i < count) {
                if (!this.data[i].equals(odata[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public ListData(Object[] data) {
            this.data = data;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                int len = this.data.length;
                StringBuffer buf = new StringBuffer();
                if (len > 0) {
                    buf.append(this.data[0].toString());
                }
                int i = 1;
                while (i < len) {
                    buf.append(' ');
                    buf.append(this.data[i].toString());
                    ++i;
                }
                this.canonical = buf.toString();
            }
            return this.canonical;
        }
    }
}

