/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class Base64BinaryDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2079;
    }

    public int getDataLength(Object value) {
        return ((XBase64)value).length();
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        byte[] decoded = Base64.decode(content);
        if (decoded == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "base64Binary"});
        }
        return new XBase64(decoded);
    }

    private static final class XBase64 {
        final byte[] data;
        private String canonical;

        public int length() {
            return this.data.length;
        }

        public XBase64(byte[] data) {
            this.data = data;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XBase64)) {
                return false;
            }
            int len = this.data.length;
            byte[] odata = ((XBase64)obj).data;
            if (len != odata.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (this.data[i] != odata[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = Base64.encode(this.data);
            }
            return this.canonical;
        }
    }
}

