/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.lang;

public class Bytes {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static int toInt(byte[] byArray) {
        return (byArray[3] & 0xFF) + ((byArray[2] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 16) + ((byArray[0] & 0xFF) << 24);
    }

    public static long toLong(byte[] byArray) {
        return ((long)byArray[7] & 0xFFL) + (((long)byArray[6] & 0xFFL) << 8) + (((long)byArray[5] & 0xFFL) << 16) + (((long)byArray[4] & 0xFFL) << 24) + (((long)byArray[3] & 0xFFL) << 32) + (((long)byArray[2] & 0xFFL) << 40) + (((long)byArray[1] & 0xFFL) << 48) + (((long)byArray[0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(int n) {
        return Bytes.toBytes(n, new byte[4]);
    }

    public static byte[] toBytes(int n, byte[] byArray) {
        byArray[3] = (byte)n;
        byArray[2] = (byte)(n >>>= 8);
        byArray[1] = (byte)(n >>>= 8);
        byArray[0] = (byte)(n >>>= 8);
        return byArray;
    }

    public static byte[] toBytes(long l) {
        return Bytes.toBytes(l, new byte[8]);
    }

    public static byte[] toBytes(long l, byte[] byArray) {
        byArray[7] = (byte)l;
        byArray[6] = (byte)(l >>>= 8);
        byArray[5] = (byte)(l >>>= 8);
        byArray[4] = (byte)(l >>>= 8);
        byArray[3] = (byte)(l >>>= 8);
        byArray[2] = (byte)(l >>>= 8);
        byArray[1] = (byte)(l >>>= 8);
        byArray[0] = (byte)(l >>>= 8);
        return byArray;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] append(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] append(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    public static byte[] copy(byte[] byArray, int n) {
        return Bytes.copy(byArray, n, byArray.length - n);
    }

    public static byte[] copy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static void merge(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        System.arraycopy(byArray, n, byArray2, n2, n3);
    }

    public static void merge(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    public static void merge(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
    }

    public static void merge(byte[] byArray, byte[] byArray2, int n, int n2) {
        System.arraycopy(byArray, 0, byArray2, n, n2);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            cArray[n3++] = hexDigits[by >>> 4 & 0xF];
            cArray[n3++] = hexDigits[by & 0xF];
        }
        return new String(cArray);
    }

    public static String toString(byte[] byArray) {
        return Bytes.toString(byArray, 0, byArray.length);
    }
}

