/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.io;

import java.io.File;
import java.io.FilenameFilter;

public class SimpleFileFilter
implements FilenameFilter {
    private String[] extensions;

    public SimpleFileFilter(String string) {
        this(new String[]{string});
    }

    public SimpleFileFilter(String[] stringArray) {
        this.extensions = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.extensions[i] = stringArray[i].toLowerCase();
        }
    }

    public boolean accept(File file, String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!string2.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    public static File[] fileOrFiles(File file) {
        if (file == null) {
            return null;
        }
        String string = file.getParent();
        File file2 = string != null ? new File(string) : new File("");
        String string2 = file.getName();
        if (string2.length() > 0 && string2.charAt(0) == '*') {
            String string3 = string2.substring(1, string2.length());
            String[] stringArray = file2.list(new SimpleFileFilter(string3));
            if (stringArray == null) {
                return null;
            }
            File[] fileArray = new File[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fileArray[i] = new File(file2.getPath() + File.separator + stringArray[i]);
            }
            return fileArray;
        }
        File[] fileArray = new File[]{file};
        return fileArray;
    }
}

