/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.datacollector.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class CIMUtil {
    protected static Logger LOG = Logger.getLogger((class$com$sun$cns$datacollector$util$CIMUtil == null ? (class$com$sun$cns$datacollector$util$CIMUtil = CIMUtil.class$("com.sun.cns.datacollector.util.CIMUtil")) : class$com$sun$cns$datacollector$util$CIMUtil).getName());
    protected static Object lock = new Object();
    protected static CIMClient cim = null;
    protected static boolean startedSolaris = false;
    static /* synthetic */ Class class$com$sun$cns$datacollector$util$CIMUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connect(String username, String password) throws CIMException {
        Object object = lock;
        synchronized (object) {
            cim = new CIMClient(new CIMNameSpace(), (Principal)new UserPrincipal(username), (Object)new PasswordCredential(password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnect() throws CIMException {
        Object object = lock;
        synchronized (object) {
            if (cim != null) {
                cim.close();
            }
            cim = null;
        }
    }

    public static Map getCIMData(Map data) throws CIMException {
        if (cim == null) {
            throw new CIMException("not connected");
        }
        LinkedHashMap<String, Map[]> result = new LinkedHashMap<String, Map[]>(data.size());
        Iterator it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String objectName = (String)entry.getKey();
            String[] propertyList = (String[])entry.getValue();
            ArrayList list = new ArrayList();
            Enumeration en = cim.enumerateInstances(new CIMObjectPath(objectName), true, false, false, false, propertyList);
            while (en.hasMoreElements()) {
                CIMInstance inst = (CIMInstance)en.nextElement();
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>(propertyList.length);
                for (int i = 0; i < propertyList.length; ++i) {
                    Object value = inst.getProperty(propertyList[i]).getValue().getValue();
                    if (value instanceof CIMDateTime) {
                        item.put(propertyList[i], ((CIMDateTime)value).getCalendar().getTime());
                        continue;
                    }
                    item.put(propertyList[i], value);
                }
                list.add(item);
            }
            Map[] maplist = new Map[list.size()];
            list.toArray(maplist);
            result.put(objectName, maplist);
        }
        return result;
    }

    public static void initSolaris() throws IOException {
        String status = "";
        Pattern running = Pattern.compile("[^t] running ");
        try {
            status = CIMUtil.getProcessOutput(new String[]{"/etc/init.d/init.wbem", "status"});
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "get wbem status error", ex);
        }
        if (!running.matcher(status).find()) {
            LOG.fine("Start wbem");
            CIMUtil.exec(new String[]{"/etc/init.d/init.wbem", "start"});
            startedSolaris = true;
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(750L);
                    status = CIMUtil.getProcessOutput(new String[]{"/etc/init.d/init.wbem", "status"});
                    if (!running.matcher(status).find()) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void done() throws IOException {
        try {
            CIMUtil.disconnect();
        }
        catch (CIMException ex) {
            LOG.log(Level.WARNING, "disconnect error", ex);
        }
        if (startedSolaris) {
            LOG.fine("Stop wbem");
            startedSolaris = false;
            CIMUtil.exec(new String[]{"/etc/init.d/init.wbem", "stop"});
        }
    }

    protected static void exec(String[] cmd) throws IOException {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "process error", ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            LOG.log(Level.WARNING, "process interrupted", ex);
        }
    }

    protected static String getProcessOutput(String[] cmd) throws IOException {
        StringBuffer buf = new StringBuffer(256);
        char[] cbuf = new char[256];
        Process p = Runtime.getRuntime().exec(cmd);
        InputStreamReader in = new InputStreamReader(p.getInputStream());
        int len = in.read(cbuf, 0, 256);
        while (len >= 0) {
            buf.append(cbuf, 0, len);
            len = in.read(cbuf, 0, 256);
        }
        in.close();
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        String logConfig = "handlers=java.util.logging.ConsoleHandler\njava.util.logging.ConsoleHandler.level=ALL\njava.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter\n" + (class$com$sun$cns$datacollector$util$CIMUtil == null ? (class$com$sun$cns$datacollector$util$CIMUtil = CIMUtil.class$("com.sun.cns.datacollector.util.CIMUtil")) : class$com$sun$cns$datacollector$util$CIMUtil).getName() + ".level=FINE\n";
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(logConfig.getBytes()));
        CIMUtil.initSolaris();
        CIMUtil.connect(args[0], args[1]);
        LinkedHashMap<String, String[]> data = new LinkedHashMap<String, String[]>(4);
        data.put("Solaris_Package", new String[]{"Name", "Version", "InstallDate", "Status"});
        data.put("Solaris_Patch", new String[]{"Name"});
        data.put("Solaris_ComputerSystem", new String[]{"Name", "HostId", "Description"});
        data.put("Solaris_OperatingSystem", new String[]{"Version", "OtherVersionDescription", "LastBootUpTime"});
        data.put("Solaris_Processor", new String[]{"DeviceID", "CurrentClockSpeed"});
        data.put("Solaris_IPProtocolEndpoint", new String[]{"Name", "Address"});
        data.put("Solaris_EthernetAdapter", new String[]{"DeviceID", "PermanentAddress"});
        data.put("Solaris_SerialPort", new String[]{"DeviceID", "ServiceTag", "PortMonitor"});
        data.put("Solaris_DiskDrive", new String[]{"DeviceID", "DiskType"});
        data.put("Solaris_UFS", new String[]{"Name", "Root", "FileSystemSize", "AvailableSpace"});
        data.put("Solaris_VMExtent", new String[]{"DeviceID", "NumberOfBlocks", "BlockSize"});
        Map result = CIMUtil.getCIMData(data);
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String objectName = (String)entry.getKey();
            Map[] list = (Map[])entry.getValue();
            System.out.println("\n\n" + objectName);
            for (int i = 0; i < list.length; ++i) {
                Iterator it2 = list[i].entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry item = it2.next();
                    System.out.println("   " + item.getKey() + " = (" + item.getValue().getClass().getName() + ") " + item.getValue());
                }
                System.out.println();
            }
        }
        CIMUtil.done();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

