#!/usr/bin/perl
#############################################################################
# Copyright (C) 2005, Sun Microsystems Inc. All rights reserved.
# Use is subject to license terms.
# 
# Description:
# Use pkginfo, and pkgparam to gather the data we need on each installed
# Solaris Packge.
#
# Output:
# for each package name listed by `pkginfo`:
# id:\b<PKGINST>\tname:\b<NAME>\tcategory:\b<CATEGORY>\tarch:\b<ARCH>\tversion:\b<VERSION>\tvendor:\b<VENDOR>\tdescription:\b<DESC>
# Use pkgparam to get the values.
# Actually want two blanks between <word>: and <value> as this is what the original code did.
#
# This code is introduced late in the schedule so we produce the same
# output as the original code just to be safe.

use Carp;

# Commands who's output we want to read:
$PKGINFO="/usr/bin/pkginfo|";
$PKGPARAM="/usr/bin/pkgparam|";

open PKGINFO or die "ERROR: Can't run pkginfo";

while ( <PKGINFO> ) {
    # We expect ^<type><whitespace><name><whitespace><description>$
    # Any of the values can contain any characters so we match them by looking
    # for non-whitespace.
    $line = $_;
    if ( $line =~ /(\S+)\s+(\S+)\s+(.*)/ ) {
        $pkgname=$2;
        # Now get the params we need for this package name.
        open PKGPARAM, "/usr/bin/pkgparam $pkgname PKGINST NAME CATEGORY ARCH VERSION VENDOR DESC 2>&1 |" or die "ERROR: Can't run pkgparam $pkgname";
        @params = <PKGPARAM>;
        chomp(@params);
        ( $pkginst, $name, $category, $arch, $version, $vendor, $desc ) = @params;
        print "id:  $pkginst\tname:  $name\tcategory:  $category\tarch:  $arch\tversion:  $version\tvendor:  $vendor\tdescription:  $desc\n";
        close PKGPARAM;
    }
    else {
        print "ERROR: unexpected output from pkginfo: $line";
    }
}
close PKGINFO;
