package com.sun.cc.platform.user;

import java.rmi.RemoteException;

/** 
 * Implementations of this interface know how to interact with
 * the UserInformationService.  
 * <p>
 * Tokens returned by this implementation have an service implementation
 * specific lifespan.  They expire and should not be kept around beyond 
 * that experation time.  The default/usual lifespan is 30 minutes. 
 */  
public interface UserServiceClient {

    /** validates the given username and password 
     *  with the UserInformationService.
     * @param username the identifier of the user
     * @param password a shared secret
     * @return an SSO token associated with the given user 
     *         null if the given username and password are incorrect.
     * @throws RemoteException if there is an error connecting 
     *         to the remote service
     */
    public String validate(String username, String password) 
        throws RemoteException;


    /** registers a user's profile information and thier associated
     *  legal agreement acceptence with the UserInformationService.
     * @param username the identifier of the user
     * @param password a shared secret
     * @param touVersion the version of the terms of use the user accepted
     *        (for the SMI Terms Of Use use 2.0)
     * @param touLanguageCode the language code identifying the language 
     *        the terms of use was presented in (e.g.,  'en')
     * @param touCountryCode the country code identifying a variant
     *        of the language of the displayed terms of use.  This is also
     *        used to identify the country denoting the legal requirements
     *        of the terms of use.   (e.g.,  'US')
     * @param licenseAccepted the name of the license the user accepted
     *        (for the SMI Terms Of Use use SMI_TOU)
     * @param licenseVersion the version of the license the user accepted
     *        (for the SMI Terms Of Use use 2.0)
     * @param licenseLanguageCode the language code identifying the language 
     *        the license was presented in (e.g.,  'en')
     * @param licenseCountryCode the country code identifying a variant
     *        of the language of the displayed license.  This is also
     *        used to identify the country denoting the legal requirements
     *        of the license.   (e.g.,  'US')
     * @param application the Name (or maybe UUID) of the application
     *        <b>This needs more clearification in the morning.</b>
     * @return an SSO token associated with the given user or
     *         null if the account could not be created.
     * @throws RemoteException if there is an error connecting 
     *         to the remote service
     * @throws DuplicateAccountException if the given username
     *         has already been used.
     */
    public String validateAndAccept(String username, String password,
                                    String touAccepted, 
                                    String touVersion,
                                    String touLanguageCode,
                                    String touCountryCode,
                                    String licenseAccepted, 
                                    String licenseVersion,
                                    String licenseLanguageCode,
                                    String licenseCountryCode,
                                    String application) 
        throws RemoteException;

    /** registers a user's profile information and thier associated
     *  legal agreement acceptence with the UserInformationService.
     * @param username the identifier of the user
     * @param password a shared secret
     * @param touAccepted true if the user accepted the 
     *        SMI Terms Of Use version 2.0 in US_english
     * @param licenseAccepted true if the user accepted the 
     *        SMI Binary License agreement version 1.0 in US_english
     * @param application the Name (or maybe UUID) of the application
     *        <b>This needs more clearification in the morning.</b>
     * @return an SSO token associated with the given user or
     *         null if the account could not be created.
     * @throws RemoteException if there is an error connecting 
     *         to the remote service
     * @throws DuplicateAccountException if the given username
     *         has already been used.
     */
    public String validateAndAccept(String username, String password,
                                    boolean touAcceptedAndBL,  
                                    String application) 
        throws RemoteException;

    /** registers a user's profile information and thier associated
     *  legal agreement acceptence with the UserInformationService.
     * @param username the identifier of the user
     * @param password a shared secret
     * @param firstname the user's firstname
     * @param lastname the user's lastname
     * @param companyName the name of the user's company
     * @param address1 the first line of the user's address
     * @param address2 the second line of the user's address 
     *        (currently ignored)
     * @param address3 the third line of the user's address
     *        (currently ignored)
     * @param city the city in which the user lives
     * @param state the state or province identifier in which 
     *        the city is located
     * @param postalCode a postal identifier for the user's address
     * @param country the name of the country encompassing the 
     *        state or province
     * @param phone a telephone number that could be used to reach 
     *        the user for sales calls
     * @param email an email address which sales solicitations could be sent to
     * @param preferredLanguage the user's preferredLanguage
     * @param jobTitle the job title
     * @param maySunContact true if sun may contact this user (ignored)
     * @param touAccepted the name of the terms of use the user accepted
     *        (for the SMI Terms Of Use use SMI_TOU)
     * @param touVersion the version of the terms of use the user accepted
     *        (for the SMI Terms Of Use use 2.0)
     * @param touLanguageCode the language code identifying the language 
     *        the terms of use was presented in (e.g.,  'en')
     * @param touCountryCode the country code identifying a variant
     *        of the language of the displayed terms of use.  This is also
     *        used to identify the country denoting the legal requirements
     *        of the terms of use.   (e.g.,  'US')
     * @param application the Name (or maybe UUID) of the application
     *        <b>This needs more clearification in the morning.</b>
     * @return an SSO token associated with the given user or
     *         null if the account could not be created.
     * @throws RemoteException if there is an error connecting 
     *         to the remote service
     * @throws DuplicateAccountException if the given username
     *         has already been used.
     */
    public String registerUser(String username, String password,
                               String firstName, String lastName, 
                               String companyName,
                               String address1, String address2, 
                               String address3, String city, String state, 
                               String postalCode, String country, 
                               String phone, String email, 
                               String preferredLanguage,
                               String jobTitle, boolean maySunContact, 
                               String touAccepted, 
                               String touVersion,
                               String touLanguageCode,
                               String touCountryCode,
                               String application) 
        throws RemoteException, DuplicateAccountException;
   

    /** registers a user's profile information and thier associated
     *  legal agreement acceptence with the UserInformationService.
     * @param username the identifier of the user
     * @param password a shared secret
     * @param firstname the user's firstname
     * @param lastname the user's lastname
     * @param companyName the name of the user's company
     * @param address1 the first line of the user's address
     * @param address2 the second line of the user's address 
     *        (currently ignored)
     * @param address3 the third line of the user's address
     *        (currently ignored)
     * @param city the city in which the user lives
     * @param state the state or province identifier in which 
     *        the city is located
     * @param postalCode a postal identifier for the user's address
     * @param country the name of the country encompassing the 
     *        state or province
     * @param phone a telephone number that could be used to reach 
     *        the user for sales calls
     * @param email an email address which sales solicitations could be sent to
     * @param preferredLanguage the user's preferredLanguage
     * @param jobTitle the job title
     * @param maySunContact true if sun may contact this user (ignored)
     * @param touVersion the version of the terms of use the user accepted
     *        (for the SMI Terms Of Use use 2.0)
     * @param touLanguageCode the language code identifying the language 
     *        the terms of use was presented in (e.g.,  'en')
     * @param touCountryCode the country code identifying a variant
     *        of the language of the displayed terms of use.  This is also
     *        used to identify the country denoting the legal requirements
     *        of the terms of use.   (e.g.,  'US')
     * @param licenseAccepted the name of the license the user accepted
     *        (for the SMI Terms Of Use use SMI_TOU)
     * @param licenseVersion the version of the license the user accepted
     *        (for the SMI Terms Of Use use 2.0)
     * @param licenseLanguageCode the language code identifying the language 
     *        the license was presented in (e.g.,  'en')
     * @param licenseCountryCode the country code identifying a variant
     *        of the language of the displayed license.  This is also
     *        used to identify the country denoting the legal requirements
     *        of the license.   (e.g.,  'US')
     * @param application the Name (or maybe UUID) of the application
     *        <b>This needs more clearification in the morning.</b>
     * @return an SSO token associated with the given user or
     *         null if the account could not be created.
     * @throws RemoteException if there is an error connecting 
     *         to the remote service
     * @throws DuplicateAccountException if the given username
     *         has already been used.
     */
    public String registerUser(String username, String password,
                               String firstName, String lastName, 
                               String companyName,
                               String address1, String address2, 
                               String address3, String city, String state, 
                               String postalCode, String country, 
                               String phone, String email, 
                               String preferredLanguage,
                               String jobTitle, boolean maySunContact, 
                               String touAccepted, 
                               String touVersion,
                               String touLanguageCode,
                               String touCountryCode,
                               String licenseAccepted, 
                               String licenseVersion,
                               String licenseLanguageCode,
                               String licenseCountryCode,
                               String application) 
        throws RemoteException, DuplicateAccountException;

    /** registers a user's profile information and thier associated
     *  legal agreement acceptence with the UserInformationService.
     * @param username the identifier of the user
     * @param password a shared secret
     * @param firstname the user's firstname
     * @param lastname the user's lastname
     * @param companyName the name of the user's company
     * @param address1 the first line of the user's address
     * @param address2 the second line of the user's address 
     *        (currently ignored)
     * @param address3 the third line of the user's address
     *        (currently ignored)
     * @param city the city in which the user lives
     * @param state the state or province identifier in which 
     *        the city is located
     * @param postalCode a postal identifier for the user's address
     * @param country the name of the country encompassing the 
     *        state or province
     * @param phone a telephone number that could be used to reach 
     *        the user for sales calls
     * @param email an email address which sales solicitations could be sent to
     * @param preferredLanguage the user's preferredLanguage
     * @param jobTitle the job title
     * @param maySunContact true if sun may contact this user (ignored)
     * @param touAccepted true if the user accepted the 
     *        SMI Terms Of Use version 2.0 in US_english
     * @param licenseAccepted true if the user accepted the 
     *        SMI Binary License agreement version 1.0 in US_english
     * @param application the Name (or maybe UUID) of the application
     *        <b>This needs more clearification in the morning.</b>
     * @return an SSO token associated with the given user or
     *         null if the account could not be created.
     * @throws RemoteException if there is an error connecting 
     *         to the remote service
     * @throws DuplicateAccountException if the given username
     *         has already been used.
     */
    public String registerUser(String username, String password,
                               String firstName, String lastName, 
                               String companyName,
                               String address1, String address2, 
                               String address3, String city, String state, 
                               String postalCode, String country, 
                               String phone, String email, 
                               String preferredLanguage,
                               String jobTitle, boolean maySunContact, 
                               boolean touAccepted, 
                               boolean licenseAccepted, 
                               String application) 
        throws RemoteException, DuplicateAccountException;
   
}
