/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.ndbm;

import com.sun.database.simpleadapter.common.PracticalTokenizer;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DatabaseExistsException;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.NoSuchDatabaseException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import java.util.NoSuchElementException;

public class Ndbm {
    static String fieldDelimiter = "|";
    private int keyFieldNumber;
    private String databaseName;
    private int databaseHandle;
    private boolean databaseIsOpen = false;

    protected Ndbm() {
    }

    public Ndbm(String string, int n, boolean bl) throws SecurityException, NoSuchDatabaseException, DatabaseExistsException {
        this(string, fieldDelimiter, n, bl);
    }

    public Ndbm(String string, String string2, int n, boolean bl) throws SecurityException, NoSuchDatabaseException, DatabaseExistsException {
        fieldDelimiter = string2;
        this.keyFieldNumber = n;
        this.databaseName = new String(string + this.keyFieldNumber);
        if (bl && this.createDatabase(this.databaseName) == -1) {
            throw new DatabaseExistsException("Ndbm: Attempt to create a new database at " + string + " found an existing database.");
        }
        this.databaseHandle = this.openDatabase(this.databaseName);
        if (this.databaseHandle == 0) {
            if (bl) {
                throw new NoSuchDatabaseException("Ndbm: Successfully created database " + this.databaseName + " is not accessible.");
            }
            throw new NoSuchDatabaseException("Ndbm: The database " + this.databaseName + " is not accessible.");
        }
        if (this.databaseHandle == -1) {
            throw new NoSuchDatabaseException("Ndbm: Attempt to open database at " + string + " failed.");
        }
        this.databaseIsOpen = true;
    }

    public void destroyNdbm() throws IllegalAccessException {
        this.close();
        this.destroyDatabase(this.databaseName);
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addRecord(String string) throws DuplicateEntryException, IllegalAccessException {
        String string2 = this.getKey(string);
        try {
            this.findRecord(string2);
            throw new DuplicateEntryException("Initial search of the database found an existing copy of " + string + ".");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            this.dbmStore(this.databaseHandle, string2, string);
            return;
        }
    }

    public void deleteRecord(String string) throws NoSuchObjectException {
        this.dbmDelete(this.databaseHandle, string);
    }

    private String getKey(String string) {
        PracticalTokenizer practicalTokenizer = new PracticalTokenizer(fieldDelimiter, string);
        for (int i = 0; i <= this.keyFieldNumber; ++i) {
            try {
                practicalTokenizer.nextToken();
                continue;
            }
            catch (Exception exception) {
                throw new DatabaseError(exception, "Ndbm.getKey: Malformed record - " + string + ".");
            }
        }
        return practicalTokenizer.sval;
    }

    public String findRecord(String string) throws NoSuchObjectException {
        String string2 = "";
        string2 = this.dbmFetch(this.databaseHandle, string);
        if (string2.compareTo("") == 0) {
            throw new NoSuchObjectException("Ndbm.findRecord: Empty record retrieved using dbmFetch(" + this.databaseHandle + ", " + string + ").");
        }
        return string2;
    }

    public String getFirstKey() throws NoSuchElementException {
        return this.dbmFirstKey(this.databaseHandle);
    }

    public String getNextKey() throws NoSuchElementException {
        return this.dbmNextKey(this.databaseHandle);
    }

    protected void close() {
        if (this.databaseIsOpen) {
            this.dbmClose(this.databaseHandle);
            this.databaseIsOpen = false;
        }
    }

    protected native void destroyDatabase(String var1);

    protected native int createDatabase(String var1);

    protected native int openDatabase(String var1);

    protected native void dbmStore(int var1, String var2, String var3);

    protected native String dbmFetch(int var1, String var2);

    protected native void dbmClose(int var1);

    protected native String dbmFirstKey(int var1) throws NoSuchElementException;

    protected native String dbmNextKey(int var1) throws NoSuchElementException;

    protected native void dbmDelete(int var1, String var2);

    static {
        System.loadLibrary("sdbndbm");
    }
}

