/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.GenericEditorPane;
import com.sun.swup.client.ui.UninstallSummaryDialog;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.foundation.Utility;
import java.awt.Font;
import java.lang.ref.WeakReference;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class UninstallSummaryEditorPane
extends GenericEditorPane {
    private WeakReference uninstallSummaryDialog;

    UninstallSummaryEditorPane(UninstallSummaryDialog uninstallSummaryDialog) {
        this.setUninstallSummaryDialog(uninstallSummaryDialog);
        this.setEditable(false);
        this.setFont(Utility.getReducedFont(this, "small-font-reduction"));
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        this.modifyStyleSheet(htmlEditorKit.getStyleSheet());
        this.setEditorKit(htmlEditorKit);
    }

    void populate() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<body><table width=\"100%\">");
        try {
            UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
            Update[] aUpdates = ud.getUninstallSummaryUpdates();
            for (int i = 0; i < aUpdates.length; ++i) {
                int updateStatus = aUpdates[i].getUpdateOperateStatus();
                sb.append("<tr>");
                sb.append("<td width=\"5%\">");
                if (updateStatus == 1) {
                    sb.append("<img src=\"");
                    sb.append(Environment.getImageIcon((String)"warning_medium.gif"));
                    sb.append("\">");
                    sb.append("</img>");
                }
                sb.append("</td>");
                sb.append("<td width=\"10%\">");
                sb.append(Utility.checkNull(aUpdates[i].getName()));
                sb.append("</td>");
                sb.append("<td>");
                sb.append(Utility.checkNull(aUpdates[i].getDescription()));
                sb.append("</td>");
                sb.append("<td width=\"15%\" align=\"left\">");
                switch (updateStatus) {
                    case 0: {
                        sb.append("<img src=\"");
                        sb.append(Environment.getImageIcon((String)"success_task.gif"));
                        sb.append("\">");
                        sb.append("</img>");
                        sb.append(UninstallSummaryDialog.I18N.getString("uninstallation-summary-success"));
                        break;
                    }
                    case 5: {
                        sb.append("<img src=\"");
                        sb.append(Environment.getImageIcon((String)"cancelled_task.gif"));
                        sb.append("\">");
                        sb.append("</img>");
                        sb.append(UninstallSummaryDialog.I18N.getString("uninstallation-summary-canceled"));
                        break;
                    }
                    case 1: {
                        sb.append("<img src=\"");
                        sb.append(Environment.getImageIcon((String)"failed_task.gif"));
                        sb.append("\">");
                        sb.append("</img>");
                        sb.append(UninstallSummaryDialog.I18N.getString("uninstallation-summary-failed"));
                        break;
                    }
                    case -1: {
                        sb.append(UninstallSummaryDialog.I18N.getString("uninstallation-summary-not-set"));
                        break;
                    }
                    default: {
                        sb.append(UninstallSummaryDialog.I18N.getString("uninstallation-summary-failed"));
                    }
                }
                sb.append("</td>");
                sb.append("</tr>");
                if (updateStatus != 1) continue;
                sb.append("<tr>");
                sb.append("<td></td><td></td>");
                sb.append("<td>");
                sb.append(aUpdates[i].getUpdateOperateMessage());
                sb.append("</td>");
                sb.append("<td></td>");
                sb.append("</tr>");
            }
        }
        catch (Exception e) {
            System.err.println("error populating UnInstallSummaryEditorPane...");
        }
        sb.append("</table></html>");
        sb.append("</body>");
        if (UMData.getDebug()) {
            System.out.println("UnInstall Summary:" + sb.toString());
        }
        this.setText(sb.toString());
        this.setCaretPosition(0);
    }

    private void modifyStyleSheet(StyleSheet styleSheet) {
        Font font = this.getFont();
        String sFontFamily = font.getFamily();
        int iFontSize = font.getSize();
        styleSheet.addRule("body {font-family:" + sFontFamily + ";font-size:" + iFontSize + "pt;}");
    }

    private void setUninstallSummaryDialog(UninstallSummaryDialog uninstallSummaryDialog) {
        this.uninstallSummaryDialog = new WeakReference<UninstallSummaryDialog>(uninstallSummaryDialog);
    }

    private UninstallSummaryDialog getUninstallSummaryDialog() {
        return (UninstallSummaryDialog)this.uninstallSummaryDialog.get();
    }
}

