/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.NAUtils;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.engine.solaris.SolarisDataCollector;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AvailablePanel;
import com.sun.swup.client.ui.PreferencesFrame;
import com.sun.swup.client.ui.Settings;
import com.sun.swup.client.ui.WarningDialog;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.wrapper.PatchProPreferences;
import com.sun.swup.client.wrapper.PatchProWrapper;
import java.awt.Frame;
import javax.swing.JFrame;

class SolarisSettings
implements Settings {
    private String tempUpdateSource = "defaultUpdateSource";
    private String updateSet = "all_available_updates";
    private String sunUsername = "";
    private String sunUserPassword = "";
    private String proxySet = null;
    private Boolean proxyAuth = null;
    private String tempProxyHostName = null;
    private String tempProxyPortNumber = null;
    private String tempProxyUsername = null;
    private String tempProxyPassword = null;
    private String tempDownloadDirectory = "/var/sadm/spool";
    private String tempBackoutDataDirectory = "";
    private Boolean standard = new Boolean(true);
    private Boolean singleUser = new Boolean(true);
    private Boolean rebootAfter = new Boolean(true);
    private Boolean reconfigAfter = new Boolean(true);
    private Boolean rebootImmediate = new Boolean(true);
    private Boolean reconfigImmediate = new Boolean(true);
    private String oldPatchSource = null;
    private static final String[] GET_PROPERTIES = new String[]{"patchpro.patch.source", "patchpro.proxy.host", "patchpro.proxy.port", "patchpro.proxy.user", "patchpro.proxy.passwd", "patchpro.download.directory", "patchpro.backout.directory"};

    SolarisSettings() {
    }

    public void setUpdateSource(String updateSource) throws NotAuthenticatedException, Exception {
        this.tempUpdateSource = updateSource;
    }

    public String getUpdateSource() throws NotAuthenticatedException, Exception {
        return this.tempUpdateSource;
    }

    public void setProxySet(String proxySet) throws NotAuthenticatedException, Exception {
        this.proxySet = proxySet;
    }

    public String getProxySet() throws NotAuthenticatedException, Exception {
        return this.proxySet;
    }

    public void setProxyHostName(String proxyHostName) throws NotAuthenticatedException, Exception {
        this.tempProxyHostName = proxyHostName;
    }

    public String getProxyHostName() throws NotAuthenticatedException, Exception {
        return this.tempProxyHostName;
    }

    public void setProxyPortNumber(String proxyPortNumber) throws NotAuthenticatedException, Exception {
        this.tempProxyPortNumber = proxyPortNumber;
    }

    public String getProxyPortNumber() throws NotAuthenticatedException, Exception {
        return this.tempProxyPortNumber;
    }

    public void setProxyAuth(Boolean proxyAuth) throws NotAuthenticatedException, Exception {
        this.proxyAuth = proxyAuth;
    }

    public Boolean getProxyAuth() throws NotAuthenticatedException, Exception {
        return this.proxyAuth;
    }

    public void setProxyUsername(String proxyUsername) throws NotAuthenticatedException, Exception {
        this.tempProxyUsername = proxyUsername;
    }

    public String getProxyUsername() throws NotAuthenticatedException, Exception {
        return this.tempProxyUsername;
    }

    public void setProxyPassword(String proxyPassword) throws NotAuthenticatedException, Exception {
        this.tempProxyPassword = proxyPassword;
    }

    public String getProxyPassword() throws NotAuthenticatedException, Exception {
        return this.tempProxyPassword;
    }

    public void setDownloadDirectory(String downloadDirectory) throws NotAuthenticatedException, Exception {
        this.tempDownloadDirectory = downloadDirectory;
    }

    public String getDownloadDirectory() throws NotAuthenticatedException, Exception {
        return this.tempDownloadDirectory;
    }

    public void setBackoutDataDirectory(String backoutDataDirectory) throws NotAuthenticatedException, Exception {
        this.tempBackoutDataDirectory = backoutDataDirectory;
    }

    public String getBackoutDataDirectory() throws NotAuthenticatedException, Exception {
        return this.tempBackoutDataDirectory;
    }

    public void setUsePanelUpdateNotifications(Boolean usePanelUpdateNotifications) throws NotAuthenticatedException, Exception {
        if (usePanelUpdateNotifications.booleanValue()) {
            if (!NAUtils.isNotAppRunning((boolean)UMData.getDebug())) {
                NAUtils.enableNotApp((boolean)UMData.getDebug());
            }
        } else if (NAUtils.isNotAppEnabled((boolean)UMData.getDebug())) {
            NAUtils.disableNotApp((boolean)UMData.getDebug());
        }
    }

    public Boolean getUsePanelUpdateNotifications() throws NotAuthenticatedException, Exception {
        return new Boolean(NAUtils.isNotAppRunning((boolean)UMData.getDebug()));
    }

    public void setAutoAnalysis(String autoAnalysis) throws NotAuthenticatedException, Exception {
        if (autoAnalysis.equals("yes")) {
            try {
                UpdateMgrUtil.enableAutoAnalysis();
                CCRUtils.setAutoAnalysisEnabled((boolean)true);
            }
            catch (CMDExecutionException cee) {
                WarningDialog warnDialog = new WarningDialog((Frame)Application.getInstance().getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.cron.title"), PreferencesFrame.I18N.getString("prefs.cron.enable.error") + "\n" + cee.getErrorMessage());
                Utility.centerOverFrame(warnDialog, (JFrame)Application.getInstance().getPreferencesFrame());
                warnDialog.setVisible(true);
                cee.printStackTrace();
            }
        } else if (autoAnalysis.equals("no")) {
            try {
                UpdateMgrUtil.disableAutoAnalysis();
                CCRUtils.setAutoAnalysisEnabled((boolean)false);
            }
            catch (CMDExecutionException cee) {
                System.out.println(cee.getErrorMessage());
                WarningDialog warnDialog = new WarningDialog((Frame)Application.getInstance().getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.cron.title"), PreferencesFrame.I18N.getString("prefs.cron.disable.error") + "\n" + cee.getErrorMessage());
                Utility.centerOverFrame(warnDialog, (JFrame)Application.getInstance().getPreferencesFrame());
                warnDialog.setVisible(true);
                cee.printStackTrace();
            }
        }
    }

    public String getAutoAnalysis() throws NotAuthenticatedException, Exception {
        if (CCRUtils.isAutoAnalysisEnabled()) {
            return "yes";
        }
        return "no";
    }

    public void storeValuesInPatchPro() throws Exception {
        PatchProPreferences ppp = new PatchProPreferences();
        this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.patch.source", this.tempUpdateSource);
        if (this.getProxySet().equals("manual")) {
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.host", this.tempProxyHostName);
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.port", this.tempProxyPortNumber);
            if (this.getProxyAuth().booleanValue()) {
                this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.user", this.tempProxyUsername);
                if (this.tempProxyPassword != null && !this.tempProxyPassword.equals("****")) {
                    this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.passwd", this.tempProxyPassword);
                }
            } else {
                this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.user", "");
                this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.passwd", "");
            }
        } else {
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.host", "");
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.port", "");
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.user", "");
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.proxy.passwd", "");
        }
        if (this.isNonEmpty(this.tempDownloadDirectory)) {
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.download.directory", this.tempDownloadDirectory);
        } else {
            this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.download.directory", "/var/sadm/spool");
            this.tempDownloadDirectory = "/var/sadm/spool";
        }
        this.addPatchProPreferencesSetPropertyValue(ppp, "patchpro.backout.directory", this.tempBackoutDataDirectory);
        PatchProWrapper.getInstance().set(ppp);
        if (!UMData.getSystemRegistrationReqd() && this.tempUpdateSource.equals("defaultUpdateSource")) {
            PatchProWrapper.getInstance().unset("patchpro.patch.source");
        }
        this.oldPatchSource = UMData.getCurrentPatchSource();
        if (this.oldPatchSource != null && !this.oldPatchSource.equals(this.tempUpdateSource)) {
            UMData.setCurrentPatchSource((String)this.tempUpdateSource);
            if (!UMData.getSystemRegistrationReqd() || UMData.getLpsToSunBR() == 1) {
                SolarisDataCollector.invalidateCategoriesObject();
                SolarisDataCollector.invalidateCollectionsObject();
                AvailablePanel aPanel = Application.getInstance().getUpdateFrame().getAvailablePanel();
                aPanel.gatherUpdates();
            }
        }
    }

    private boolean isNonEmpty(String value) {
        return value != null && !value.trim().equals("");
    }

    private void addPatchProPreferencesSetPropertyValue(PatchProPreferences ppp, String property, String value) {
        if (this.isNonEmpty(value)) {
            ppp.addPreferenceToSet(property, value);
        } else {
            ppp.addPreferenceToSet(property, "");
        }
    }

    public void readValuesFromPatchPro() throws Exception {
        PatchProPreferences ppp = new PatchProPreferences(PatchProWrapper.getInstance().get());
        this.tempUpdateSource = ppp.isUpdateSourceDefault() ? "defaultUpdateSource" : ppp.getPreference("patchpro.patch.source");
        this.tempProxyHostName = ppp.getPreference("patchpro.proxy.host");
        this.tempProxyPortNumber = ppp.getPreference("patchpro.proxy.port");
        this.tempProxyUsername = ppp.getPreference("patchpro.proxy.user");
        this.tempProxyPassword = ppp.getPreference("patchpro.proxy.passwd");
        this.tempDownloadDirectory = ppp.getPreference("patchpro.download.directory");
        this.tempBackoutDataDirectory = ppp.getPreference("patchpro.backout.directory");
        if (this.proxySet == null) {
            String string = this.proxySet = this.isNonEmpty(this.tempProxyHostName) ? "manual" : "direct";
        }
        if (this.proxyAuth == null) {
            this.proxyAuth = this.isNonEmpty(this.tempProxyUsername) ? new Boolean(true) : new Boolean(false);
        }
    }

    private void addPatchProPreferencesGetProperty(PatchProPreferences ppp, String property) {
        ppp.addPreferenceToGet(property);
    }
}

