/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.DefaultPreferenceElement;
import com.sun.swup.client.ui.PreferenceElement;
import com.sun.swup.client.ui.PreferencesFrame;
import com.sun.swup.client.ui.Settings;
import com.sun.swup.client.ui.SettingsImpl;
import com.sun.swup.client.ui.SolarisSettings;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class PreferencesManager {
    static PreferencesManager preferencesManager;
    private static final Class CLASS;
    private static final String SET = "set";
    private static final String GET = "get";
    private HashMap preferenceElements = new HashMap();
    private Settings settings = DataController.isLiveData() ? new SolarisSettings() : new SettingsImpl();
    static /* synthetic */ Class class$com$sun$swup$client$ui$Settings;
    static /* synthetic */ Class class$com$sun$swup$client$ui$foundation$swing$PasswordTextField;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    static PreferencesManager getInstance() {
        if (preferencesManager == null) {
            preferencesManager = new PreferencesManager();
        }
        return preferencesManager;
    }

    private PreferencesManager() {
    }

    public void syncAutoAnalysisSettings() {
        try {
            if (CCRUtils.isAutoAnalysisEnabled()) {
                ((SolarisSettings)this.settings).setAutoAnalysis("yes");
            } else {
                ((SolarisSettings)this.settings).setAutoAnalysis("no");
            }
        }
        catch (NotAuthenticatedException nae) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Settings getSettings() {
        return this.settings;
    }

    void putElement(String sKey, PreferenceElement preferenceElement) {
        this.preferenceElements.put(sKey, preferenceElement);
    }

    PreferenceElement getElement(String sKey) {
        return (PreferenceElement)this.preferenceElements.get(sKey);
    }

    void displayPreferencesFrame() {
        this.prepareElements();
        PopulateElementsAction action = new PopulateElementsAction();
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    void prepareElements() {
        if (UMData.getDebug()) {
            System.out.println("PreferencesManager.prepareElements()");
        }
        Method[] aMethod = CLASS.getDeclaredMethods();
        for (int i = 0; i < aMethod.length; ++i) {
            Method method = aMethod[i];
            String sName = method.getName();
            if (!sName.startsWith(GET)) continue;
            String sString = sName.substring(GET.length());
            String sKey = this.convertKey(sString);
            Class theClass = method.getReturnType();
            if (sKey.equals("proxy-password")) {
                theClass = class$com$sun$swup$client$ui$foundation$swing$PasswordTextField == null ? PreferencesManager.class$("com.sun.swup.client.ui.foundation.swing.PasswordTextField") : class$com$sun$swup$client$ui$foundation$swing$PasswordTextField;
            }
            DefaultPreferenceElement element = new DefaultPreferenceElement(theClass);
            element.setMethod(sString);
            this.preferenceElements.put(sKey, element);
        }
    }

    boolean populateElements() {
        try {
            if (UMData.getDebug()) {
                System.out.println("Calling settings.readValuesFromPatchPro()");
            }
            this.settings.readValuesFromPatchPro();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (UMData.getDebug()) {
            System.out.println("\npopulateElements()");
        }
        Set keySet = this.preferenceElements.keySet();
        Iterator iterator = this.preferenceElements.keySet().iterator();
        while (iterator.hasNext()) {
            String sKey = (String)iterator.next();
            PreferenceElement preferenceElement = (PreferenceElement)this.preferenceElements.get(sKey);
            try {
                Class theClass = class$com$sun$swup$client$ui$Settings == null ? PreferencesManager.class$("com.sun.swup.client.ui.Settings") : class$com$sun$swup$client$ui$Settings;
                String sMethod = GET + preferenceElement.getMethod();
                Class[] aClass = new Class[]{};
                Method method = theClass.getMethod(sMethod, aClass);
                Object object = method.invoke((Object)this.settings, new Object[0]);
                preferenceElement.setValue(object);
                Object value = preferenceElement.getValue();
                if (!UMData.getDebug()) continue;
                System.out.println("populate element: " + sKey + ": " + value);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NotAuthenticatedException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AuthenticationManager.getInstance().setAction(new PopulateElementsAction());
                            AuthenticationManager.getInstance().authenticate();
                        }
                    });
                    return false;
                }
                e.getCause().printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static boolean checkPort(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (int j = 0; j < s.length(); ++j) {
            if (Character.isDigit(s.charAt(j))) continue;
            return false;
        }
        return Integer.parseInt(s) <= 65535;
    }

    Vector validateElements() {
        Vector<String> failures = new Vector<String>();
        Iterator iterator = this.preferenceElements.keySet().iterator();
        while (iterator.hasNext()) {
            File dir;
            Object value2;
            PreferenceElement preferenceElement2;
            PreferenceElement preferenceElement22;
            Object value22;
            Object value;
            PreferenceElement preferenceElement;
            Object value3;
            PreferenceElement preferenceElement3;
            PreferenceElement preferenceElement23;
            Object value23;
            Object value4;
            PreferenceElement preferenceElement4;
            String sKey = (String)iterator.next();
            if (sKey.equals("proxy-host-name")) {
                preferenceElement4 = (PreferenceElement)this.preferenceElements.get("proxy-set");
                value4 = preferenceElement4.getValue();
                if (!((String)value4).equals("manual") || ((String)(value23 = (preferenceElement23 = (PreferenceElement)this.preferenceElements.get("proxy-host-name")).getValue())).length() <= 255 && ((String)value23).length() != 0) continue;
                failures.addElement("proxy-host-name");
                continue;
            }
            if (sKey.equals("update-source")) {
                preferenceElement4 = (PreferenceElement)this.preferenceElements.get("update-source");
                value4 = preferenceElement4.getValue();
                if (((String)value4).equals("defaultUpdateSource")) continue;
                try {
                    URL source = new URL((String)value4);
                }
                catch (MalformedURLException mue) {
                    failures.addElement("update-source");
                }
                continue;
            }
            if (sKey.equals("proxy-port-number")) {
                preferenceElement4 = (PreferenceElement)this.preferenceElements.get("proxy-set");
                value4 = preferenceElement4.getValue();
                if (!((String)value4).equals("manual")) continue;
                preferenceElement23 = (PreferenceElement)this.preferenceElements.get("proxy-port-number");
                value23 = preferenceElement23.getValue();
                if (PreferencesManager.checkPort((String)value23)) continue;
                failures.addElement("proxy-port-number");
                continue;
            }
            if (sKey.equals("proxy-username")) {
                preferenceElement3 = (PreferenceElement)this.preferenceElements.get("proxy-set");
                value3 = preferenceElement3.getValue();
                preferenceElement = (PreferenceElement)this.preferenceElements.get("proxy-auth");
                value = preferenceElement.getValue();
                if (!((Boolean)value).booleanValue() || !((String)value3).equals("manual") || ((String)(value22 = (preferenceElement22 = (PreferenceElement)this.preferenceElements.get("proxy-username")).getValue())).length() <= 80) continue;
                failures.addElement("proxy-username");
                continue;
            }
            if (sKey.equals("proxy-password")) {
                preferenceElement3 = (PreferenceElement)this.preferenceElements.get("proxy-set");
                value3 = preferenceElement3.getValue();
                preferenceElement = (PreferenceElement)this.preferenceElements.get("proxy-auth");
                value = preferenceElement.getValue();
                if (!((Boolean)value).booleanValue() || !((String)value3).equals("manual") || ((String)(value22 = (preferenceElement22 = (PreferenceElement)this.preferenceElements.get("proxy-password")).getValue())).length() <= 80) continue;
                failures.addElement("proxy-password");
                continue;
            }
            if (sKey.equals("download-directory")) {
                preferenceElement2 = (PreferenceElement)this.preferenceElements.get("download-directory");
                value2 = preferenceElement2.getValue();
                if (((String)value2).length() == 0 || (dir = new File((String)value2)).isDirectory()) continue;
                failures.addElement("download-directory");
                continue;
            }
            if (!sKey.equals("backout-data-directory") || ((String)(value2 = (preferenceElement2 = (PreferenceElement)this.preferenceElements.get("backout-data-directory")).getValue())).length() <= 0 || (dir = new File((String)value2)).isDirectory()) continue;
            failures.addElement("backout-data-directory");
        }
        return failures;
    }

    public boolean checkForChange() {
        Iterator iterator = this.preferenceElements.keySet().iterator();
        while (iterator.hasNext()) {
            String sKey = (String)iterator.next();
            PreferenceElement preferenceElement = (PreferenceElement)this.preferenceElements.get(sKey);
            try {
                Class theClass = class$com$sun$swup$client$ui$Settings == null ? PreferencesManager.class$("com.sun.swup.client.ui.Settings") : class$com$sun$swup$client$ui$Settings;
                String sMethod = GET + preferenceElement.getMethod();
                Class[] aClass = new Class[]{};
                Method method = theClass.getMethod(sMethod, aClass);
                Object setValue = method.invoke((Object)this.settings, new Object[0]);
                Object userValue = preferenceElement.getValue();
                if (setValue.toString().equals(userValue.toString())) continue;
                return true;
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
                break;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
                break;
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
                break;
            }
        }
        return false;
    }

    boolean captureElements() {
        if (UMData.getDebug()) {
            System.out.println("\ncaptureElements()");
        }
        Set keySet = this.preferenceElements.keySet();
        Iterator iterator = this.preferenceElements.keySet().iterator();
        while (iterator.hasNext()) {
            String sKey = (String)iterator.next();
            PreferenceElement preferenceElement = (PreferenceElement)this.preferenceElements.get(sKey);
            Object value = preferenceElement.getValue();
            if (UMData.getDebug()) {
                System.out.println("capture element: " + sKey + ": " + value);
            }
            try {
                Class theClass = class$com$sun$swup$client$ui$Settings == null ? PreferencesManager.class$("com.sun.swup.client.ui.Settings") : class$com$sun$swup$client$ui$Settings;
                String sMethod = SET + preferenceElement.getMethod();
                Class[] aClass = new Class[]{preferenceElement.getElementClass()};
                Method method = theClass.getMethod(sMethod, aClass);
                if (value == null) continue;
                Object[] aObject = new Object[]{value};
                method.invoke((Object)this.settings, aObject);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NotAuthenticatedException) {
                    AuthenticationManager.getInstance().setAction(new CaptureElementsAction());
                    AuthenticationManager.getInstance().authenticate();
                    return true;
                }
                e.getCause().printStackTrace();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            if (UMData.getDebug()) {
                System.out.println("Calling settings.storeValuesInPatchPro()");
            }
            this.settings.storeValuesInPatchPro();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        PreferenceElement downloadPreferenceElement = this.getElement("download-directory");
        try {
            downloadPreferenceElement.setValue(this.settings.getDownloadDirectory());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private void displayElements() {
        Set keySet = this.preferenceElements.keySet();
        Iterator iterator = this.preferenceElements.keySet().iterator();
        while (iterator.hasNext()) {
            String sKey = (String)iterator.next();
            PreferenceElement preferenceElement = (PreferenceElement)this.preferenceElements.get(sKey);
            Class elementClass = preferenceElement.getElementClass();
            if (elementClass == (class$java$lang$String == null ? PreferencesManager.class$("java.lang.String") : class$java$lang$String)) {
                if (!UMData.getDebug()) continue;
                System.out.println(sKey + " (String.class)");
                continue;
            }
            if (elementClass == (class$java$lang$Integer == null ? PreferencesManager.class$("java.lang.Integer") : class$java$lang$Integer)) {
                if (!UMData.getDebug()) continue;
                System.out.println(sKey + " (Integer.class)");
                continue;
            }
            if (elementClass == (class$java$lang$Boolean == null ? PreferencesManager.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                if (!UMData.getDebug()) continue;
                System.out.println(sKey + " (Boolean.class)");
                continue;
            }
            if (elementClass == Integer.TYPE) {
                if (!UMData.getDebug()) continue;
                System.out.println(sKey + " (int primitive)");
                continue;
            }
            if (elementClass == Boolean.TYPE) {
                if (!UMData.getDebug()) continue;
                System.out.println(sKey + " (boolean primitive)");
                continue;
            }
            if (!UMData.getDebug()) continue;
            System.out.println("unhandled class type");
        }
    }

    private String convertKey(String sKey) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sKey.length(); ++i) {
            char ch = sKey.charAt(i);
            if (Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
                if (i > 0) {
                    sb.append('-');
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CLASS = class$com$sun$swup$client$ui$Settings == null ? (class$com$sun$swup$client$ui$Settings = PreferencesManager.class$("com.sun.swup.client.ui.Settings")) : class$com$sun$swup$client$ui$Settings;
    }

    class CaptureElementsAction
    extends AbstractAction {
        CaptureElementsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PreferencesManager.this.captureElements();
        }
    }

    class PopulateElementsAction
    extends AbstractAction {
        PopulateElementsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean bSuccess = PreferencesManager.this.populateElements();
            if (bSuccess) {
                Application.getInstance().getPreferencesFrame().setVisible(true);
            } else {
                JOptionPane.showMessageDialog(null, PreferencesFrame.I18N.getString("prefs.read.error"), PreferencesFrame.I18N.getString("prefs.read.title"), 0);
            }
        }
    }
}

