/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.PreferenceElement;
import com.sun.swup.client.ui.PreferencesFrame;
import com.sun.swup.client.ui.PreferencesManager;
import com.sun.swup.client.ui.RadioGroupPreferenceElement;
import com.sun.swup.client.ui.Settings;
import com.sun.swup.client.ui.foundation.swing.FixedWidthTextField;
import com.sun.swup.client.ui.foundation.swing.FlowPanel;
import com.sun.swup.client.ui.foundation.swing.GenericTabbedPane;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

class MainPanel
extends InsetPanel {
    private JTabbedPane tabbedPane;
    private UpdateSourcePanel updateSourcePanel;
    private NotificationsPanel notificationsPanel;

    MainPanel() {
        super(new Insets(13, 0, 0, 0));
        this.createComponents();
        this.createLayout();
    }

    private void createComponents() {
        this.updateSourcePanel = new UpdateSourcePanel();
        this.notificationsPanel = new NotificationsPanel();
        this.tabbedPane = new GenericTabbedPane();
        this.tabbedPane.addTab(PreferencesFrame.I18N.getString("configuration-tab"), new FlowPanel(this.updateSourcePanel));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.setToolTipTextAt(0, PreferencesFrame.I18N.getString("configuration-tab-tip"));
        this.tabbedPane.addTab(PreferencesFrame.I18N.getString("notification-tab"), new FlowPanel(this.notificationsPanel));
        this.tabbedPane.setToolTipTextAt(1, PreferencesFrame.I18N.getString("notification-tab-tip"));
        this.tabbedPane.setMnemonicAt(1, 50);
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    void setUpdateSource(JRadioButton radioButton) {
        String assetId = CCRUtils.getCCRValue((String)"cns.assetid");
        boolean registrationReqd = true;
        if (assetId != null && !assetId.equals("")) {
            registrationReqd = false;
        }
        UMData.setSystemRegistrationReqd((boolean)registrationReqd);
        UMData.setLpsToSunBR((int)2);
        if (registrationReqd) {
            ImageIcon icon = Environment.getImageIcon((String)"help_medium.gif");
            String questionMsg = PreferencesFrame.I18N.getString("prefs.confirm-sun-source");
            String title = PreferencesFrame.I18N.getString("prefs.confirm-sun-source-title");
            int n = JOptionPane.showConfirmDialog(this, questionMsg, title, 0, 3, icon);
            switch (n) {
                case -1: 
                case 1: {
                    radioButton.setSelected(true);
                    break;
                }
                case 0: {
                    PreferencesManager pm = PreferencesManager.getInstance();
                    Settings settings = pm.getSettings();
                    try {
                        UMData.setLPSValue((String)settings.getUpdateSource());
                        break;
                    }
                    catch (NotAuthenticatedException nae) {
                        AuthenticationManager.getInstance().authenticate();
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    class SmallerLabel
    extends JLabel {
        SmallerLabel(String sString) {
            super(sString);
            float baseSize = this.getFont().getSize();
            this.setFont(this.getFont().deriveFont(0.75f * baseSize));
        }
    }

    class HeaderLabel
    extends JLabel {
        HeaderLabel(String sString) {
            super(sString);
            float baseSize = this.getFont().getSize();
            this.setFont(this.getFont().deriveFont(1.25f * baseSize));
        }
    }

    class FixedPanel
    extends InsetPanel {
        FixedPanel(int iPos, JComponent[] aComponent, boolean isLastRight) {
            this.setInsets(new Insets(0, iPos * 20, 0, 0));
            this.setLayout(new BoxLayout(this, 0));
            for (int i = 0; i < aComponent.length; ++i) {
                JComponent component = aComponent[i];
                if (i == aComponent.length - 1 && isLastRight) {
                    this.add(Box.createHorizontalGlue());
                    JPanel rightPanel = new JPanel();
                    rightPanel.setOpaque(false);
                    rightPanel.setLayout(new FlowLayout(2));
                    rightPanel.add(component);
                    rightPanel.setAlignmentY(0.5f);
                    this.add(rightPanel);
                    continue;
                }
                component.setAlignmentY(0.5f);
                this.add(component);
            }
        }
    }

    class TabPanel
    extends InsetPanel {
        TabPanel() {
        }

        void addLine(int iPos, JComponent[] aComponent) {
            this.addLine(iPos, aComponent, false);
        }

        void addLine(int iPos, JComponent[] aComponent, boolean isLastRight) {
            FixedPanel fixedPanel = new FixedPanel(iPos, aComponent, isLastRight);
            fixedPanel.setAlignmentX(0.0f);
            this.add(fixedPanel);
        }
    }

    class NotificationsPanel
    extends TabPanel {
        NotificationsPanel() {
            PreferencesManager preferencesManager = PreferencesManager.getInstance();
            this.setLayout(new BoxLayout(this, 1));
            PreferenceElement preferenceElement = preferencesManager.getElement("use-panel-update-notifications");
            preferenceElement.setLabel(PreferencesFrame.I18N.getString("notification-select"));
            JCheckBox cb = (JCheckBox)preferenceElement.getComponent();
            cb.setMnemonic(PreferencesFrame.I18N.getString("notification-select.mnemonic").charAt(0));
            this.addLine(1, new JComponent[]{new JLabel(" ")});
            this.addLine(1, new JComponent[]{new HeaderLabel(PreferencesFrame.I18N.getString("notification"))});
            this.addLine(2, new JComponent[]{new JLabel(PreferencesFrame.I18N.getString("notification-prompt"))});
            this.addLine(2, new JComponent[]{preferenceElement.getComponent()});
            PreferenceElement autoAnalysisPE = preferencesManager.getElement("auto-analysis");
            RadioGroupPreferenceElement autoAnalysisRGPE = new RadioGroupPreferenceElement(autoAnalysisPE.getElementClass());
            autoAnalysisRGPE.setMethod(autoAnalysisPE.getMethod());
            autoAnalysisRGPE.addItem(PreferencesFrame.I18N.getString("updates-yes"), "yes", PreferencesFrame.I18N.getString("updates-yes.mnemonic"));
            autoAnalysisRGPE.addItem(PreferencesFrame.I18N.getString("updates-no"), "no", PreferencesFrame.I18N.getString("updates-no.mnemonic"));
            autoAnalysisRGPE.setValue(autoAnalysisPE.getValue());
            preferencesManager.putElement("auto-analysis", autoAnalysisRGPE);
            this.addLine(1, new JComponent[]{new JLabel(" ")});
            this.addLine(1, new JComponent[]{new HeaderLabel(PreferencesFrame.I18N.getString("updates"))});
            this.addLine(2, new JComponent[]{new JLabel(PreferencesFrame.I18N.getString("updates-prompt"))});
            this.addLine(2, new JComponent[]{autoAnalysisRGPE.getComponentAt(0)});
            this.addLine(2, new JComponent[]{autoAnalysisRGPE.getComponentAt(1)});
            ItemListener itemListener = new ItemListener(this){
                private final /* synthetic */ NotificationsPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    Application.getInstance().getPreferencesFrame().getPreferencesPanel().buttonPanel.enableApplyButton();
                }
            };
            cb.addItemListener(itemListener);
            ((JRadioButton)autoAnalysisRGPE.getComponentAt(0)).addItemListener(itemListener);
            ((JRadioButton)autoAnalysisRGPE.getComponentAt(1)).addItemListener(itemListener);
        }
    }

    class UpdateSourceRadioGroupPreferenceElement
    extends RadioGroupPreferenceElement {
        private JTextField textField = new FixedWidthTextField();

        UpdateSourceRadioGroupPreferenceElement(Class elementClass) {
            super(elementClass);
        }

        public void setValue(Object value) {
            AbstractButton button;
            Enumeration<AbstractButton> e = this.buttonGroup.getElements();
            while (e.hasMoreElements()) {
                button = e.nextElement();
                if (!(value instanceof String)) continue;
                String sValue = (String)value;
                if (!button.getName().equals(sValue)) continue;
                button.setSelected(true);
                return;
            }
            if (this.getComponentCount() > 0) {
                int iCount = this.getComponentCount();
                button = (AbstractButton)this.getComponentAt(iCount - 1);
                button.setSelected(true);
                this.textField.setText(value.toString());
            }
        }

        public Object getValue() {
            String sValue;
            Object value = super.getValue();
            if (value instanceof String && (sValue = (String)value).equals("other")) {
                return this.textField.getText();
            }
            return value;
        }

        JTextField getOtherTextField() {
            return this.textField;
        }
    }

    class UpdateSourcePanel
    extends TabPanel {
        UpdateSourcePanel() {
            PreferencesManager preferencesManager = PreferencesManager.getInstance();
            this.setLayout(new BoxLayout(this, 1));
            PreferenceElement preferenceElement = preferencesManager.getElement("update-source");
            UpdateSourceRadioGroupPreferenceElement radio = new UpdateSourceRadioGroupPreferenceElement(preferenceElement.getElementClass());
            radio.setMethod(preferenceElement.getMethod());
            radio.addItem(PreferencesFrame.I18N.getString("source-sun"), "defaultUpdateSource", PreferencesFrame.I18N.getString("source-sun.mnemonic"));
            radio.addItem(PreferencesFrame.I18N.getString("source-local"), "other", PreferencesFrame.I18N.getString("source-local.mnemonic"));
            ((RadioGroupPreferenceElement)radio).setValue(preferenceElement.getValue());
            preferencesManager.putElement("update-source", radio);
            UpdateSourceRadioGroupPreferenceElement updateSourceElement = (UpdateSourceRadioGroupPreferenceElement)preferencesManager.getElement("update-source");
            JRadioButton radioButtonSunSource = (JRadioButton)radio.getComponentAt(0);
            JRadioButton radioButton = (JRadioButton)radio.getComponentAt(1);
            updateSourceElement.getOtherTextField().setEnabled(radioButton.isSelected());
            ItemListener itemListener = new ItemListener(this, updateSourceElement, radioButton, radioButtonSunSource, MainPanel.this){
                private final /* synthetic */ UpdateSourceRadioGroupPreferenceElement val$updateSourceElement;
                private final /* synthetic */ JRadioButton val$radioButton;
                private final /* synthetic */ JRadioButton val$radioButtonSunSource;
                private final /* synthetic */ MainPanel val$this$0;
                private final /* synthetic */ UpdateSourcePanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$updateSourceElement = val$updateSourceElement;
                    this.val$radioButton = val$radioButton;
                    this.val$radioButtonSunSource = val$radioButtonSunSource;
                    this.val$this$0 = val$this$0;
                }

                public void itemStateChanged(ItemEvent e) {
                    Application.getInstance().getPreferencesFrame().getPreferencesPanel().buttonPanel.enableApplyButton();
                    this.val$updateSourceElement.getOtherTextField().setEnabled(this.val$radioButton.isSelected());
                    if (this.val$radioButton.isSelected()) {
                        UMData.setLpsToSunBR((int)1);
                    }
                    if (this.val$radioButtonSunSource.isSelected()) {
                        UpdateSourcePanel.access$000(this.this$1).setUpdateSource(this.val$radioButton);
                    }
                }
            };
            KeyListener keyListener = new KeyListener(this){
                private final /* synthetic */ UpdateSourcePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    Application.getInstance().getPreferencesFrame().getPreferencesPanel().buttonPanel.enableApplyButton();
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }
            };
            updateSourceElement.getOtherTextField().addKeyListener(keyListener);
            radioButton.addItemListener(itemListener);
            radioButtonSunSource.addItemListener(itemListener);
            this.addLine(1, new JComponent[]{new JLabel(" ")});
            this.addLine(1, new JComponent[]{new HeaderLabel(PreferencesFrame.I18N.getString("update-source"))});
            this.addLine(2, new JComponent[]{new JLabel(PreferencesFrame.I18N.getString("source-prompt"))});
            this.addLine(2, new JComponent[]{updateSourceElement.getComponentAt(0)});
            this.addLine(2, new JComponent[]{updateSourceElement.getComponentAt(1)});
            this.addLine(3, new JComponent[]{updateSourceElement.getOtherTextField()});
            PreferenceElement proxyPE = preferencesManager.getElement("proxy-set");
            RadioGroupPreferenceElement proxyRGPE = new RadioGroupPreferenceElement(proxyPE.getElementClass());
            proxyRGPE.setMethod(proxyPE.getMethod());
            proxyRGPE.addItem(PreferencesFrame.I18N.getString("proxy-direct"), "direct", PreferencesFrame.I18N.getString("proxy-direct.mnemonic"));
            proxyRGPE.addItem(PreferencesFrame.I18N.getString("proxy-manual"), "manual", PreferencesFrame.I18N.getString("proxy-manual.mnemonic"));
            proxyRGPE.setValue(proxyPE.getValue());
            preferencesManager.putElement("proxy-set", proxyRGPE);
            preferencesManager.getElement("proxy-auth").setLabel(PreferencesFrame.I18N.getString("proxy-auth"));
            this.addLine(1, new JComponent[]{new JLabel(" ")});
            this.addLine(1, new JComponent[]{new HeaderLabel(PreferencesFrame.I18N.getString("network-proxy"))});
            this.addLine(2, new JComponent[]{proxyRGPE.getComponentAt(0)});
            this.addLine(2, new JComponent[]{proxyRGPE.getComponentAt(1)});
            JComponent proxyHostComponent = preferencesManager.getElement("proxy-host-name").getComponent();
            JLabel proxyHostLabel = new JLabel(PreferencesFrame.I18N.getString("proxy-host"));
            proxyHostLabel.setDisplayedMnemonic(PreferencesFrame.I18N.getString("proxy-host.mnemonic").charAt(0));
            proxyHostLabel.setLabelFor(proxyHostComponent);
            this.addLine(3, new JComponent[]{proxyHostLabel, proxyHostComponent}, true);
            JComponent proxyPortComponent = preferencesManager.getElement("proxy-port-number").getComponent();
            JLabel proxyPortLabel = new JLabel(PreferencesFrame.I18N.getString("proxy-port"));
            proxyPortLabel.setDisplayedMnemonic(PreferencesFrame.I18N.getString("proxy-port.mnemonic").charAt(0));
            proxyPortLabel.setLabelFor(proxyPortComponent);
            this.addLine(3, new JComponent[]{proxyPortLabel, proxyPortComponent}, true);
            this.addLine(3, new JComponent[]{preferencesManager.getElement("proxy-auth").getComponent()});
            JComponent proxyUserComponent = preferencesManager.getElement("proxy-username").getComponent();
            JLabel proxyUserLabel = new JLabel(PreferencesFrame.I18N.getString("proxy-user"));
            proxyUserLabel.setDisplayedMnemonic(PreferencesFrame.I18N.getString("proxy-user.mnemonic").charAt(0));
            proxyUserLabel.setLabelFor(proxyUserComponent);
            this.addLine(4, new JComponent[]{proxyUserLabel, proxyUserComponent}, true);
            JComponent proxyPassComponent = preferencesManager.getElement("proxy-password").getComponent();
            JLabel proxyPassLabel = new JLabel(PreferencesFrame.I18N.getString("proxy-pass"));
            proxyPassLabel.setDisplayedMnemonic(PreferencesFrame.I18N.getString("proxy-pass.mnemonic").charAt(0));
            proxyPassLabel.setLabelFor(proxyPassComponent);
            this.addLine(4, new JComponent[]{proxyPassLabel, proxyPassComponent}, true);
            JRadioButton manualProxyRadioButton = (JRadioButton)proxyRGPE.getComponentAt(1);
            JCheckBox proxyAuthCheckBox = (JCheckBox)preferencesManager.getElement("proxy-auth").getComponent();
            proxyAuthCheckBox.setMnemonic(PreferencesFrame.I18N.getString("proxy-auth.mnemonic").charAt(0));
            JComponent proxyAuthComponent = preferencesManager.getElement("proxy-auth").getComponent();
            boolean isManual = manualProxyRadioButton.isSelected();
            boolean isAuth = proxyAuthCheckBox.isSelected();
            proxyHostComponent.setEnabled(isManual);
            proxyPortComponent.setEnabled(isManual);
            proxyAuthComponent.setEnabled(isManual);
            proxyUserComponent.setEnabled(isManual && isAuth);
            proxyPassComponent.setEnabled(isManual && isAuth);
            manualProxyRadioButton.addItemListener(new ItemListener(this, proxyHostComponent, manualProxyRadioButton, proxyPortComponent, proxyAuthComponent, proxyUserComponent, proxyAuthCheckBox, proxyPassComponent){
                private final /* synthetic */ JComponent val$proxyHostComponent;
                private final /* synthetic */ JRadioButton val$manualProxyRadioButton;
                private final /* synthetic */ JComponent val$proxyPortComponent;
                private final /* synthetic */ JComponent val$proxyAuthComponent;
                private final /* synthetic */ JComponent val$proxyUserComponent;
                private final /* synthetic */ JCheckBox val$proxyAuthCheckBox;
                private final /* synthetic */ JComponent val$proxyPassComponent;
                private final /* synthetic */ UpdateSourcePanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$proxyHostComponent = val$proxyHostComponent;
                    this.val$manualProxyRadioButton = val$manualProxyRadioButton;
                    this.val$proxyPortComponent = val$proxyPortComponent;
                    this.val$proxyAuthComponent = val$proxyAuthComponent;
                    this.val$proxyUserComponent = val$proxyUserComponent;
                    this.val$proxyAuthCheckBox = val$proxyAuthCheckBox;
                    this.val$proxyPassComponent = val$proxyPassComponent;
                }

                public void itemStateChanged(ItemEvent e) {
                    Application.getInstance().getPreferencesFrame().getPreferencesPanel().buttonPanel.enableApplyButton();
                    this.val$proxyHostComponent.setEnabled(this.val$manualProxyRadioButton.isSelected());
                    this.val$proxyPortComponent.setEnabled(this.val$manualProxyRadioButton.isSelected());
                    this.val$proxyAuthComponent.setEnabled(this.val$manualProxyRadioButton.isSelected());
                    this.val$proxyUserComponent.setEnabled(this.val$manualProxyRadioButton.isSelected() && this.val$proxyAuthCheckBox.isSelected());
                    this.val$proxyPassComponent.setEnabled(this.val$manualProxyRadioButton.isSelected() && this.val$proxyAuthCheckBox.isSelected());
                }
            });
            proxyAuthCheckBox.addItemListener(new ItemListener(this, proxyUserComponent, proxyAuthCheckBox, proxyPassComponent){
                private final /* synthetic */ JComponent val$proxyUserComponent;
                private final /* synthetic */ JCheckBox val$proxyAuthCheckBox;
                private final /* synthetic */ JComponent val$proxyPassComponent;
                private final /* synthetic */ UpdateSourcePanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$proxyUserComponent = val$proxyUserComponent;
                    this.val$proxyAuthCheckBox = val$proxyAuthCheckBox;
                    this.val$proxyPassComponent = val$proxyPassComponent;
                }

                public void itemStateChanged(ItemEvent e) {
                    Application.getInstance().getPreferencesFrame().getPreferencesPanel().buttonPanel.enableApplyButton();
                    this.val$proxyUserComponent.setEnabled(this.val$proxyAuthCheckBox.isSelected());
                    this.val$proxyPassComponent.setEnabled(this.val$proxyAuthCheckBox.isSelected());
                }
            });
            proxyHostComponent.addKeyListener(keyListener);
            proxyPortComponent.addKeyListener(keyListener);
            proxyUserComponent.addKeyListener(keyListener);
            proxyPassComponent.addKeyListener(keyListener);
            this.addLine(1, new JComponent[]{new JLabel(" ")});
            this.addLine(1, new JComponent[]{new HeaderLabel(PreferencesFrame.I18N.getString("directory"))});
            this.addLine(2, new JComponent[]{new JLabel(PreferencesFrame.I18N.getString("directory-prompt"))});
            JLabel directoryDownloadLabel = new JLabel(PreferencesFrame.I18N.getString("directory-download"));
            JComponent dComponent = preferencesManager.getElement("download-directory").getComponent();
            directoryDownloadLabel.setDisplayedMnemonic(PreferencesFrame.I18N.getString("directory-download.mnemonic").charAt(0));
            directoryDownloadLabel.setLabelFor(dComponent);
            this.addLine(2, new JComponent[]{directoryDownloadLabel, dComponent}, true);
            this.addLine(3, new JComponent[]{new SmallerLabel(PreferencesFrame.I18N.format("directory-download-default", (Object[])new String[]{"/var/sadm/spool"}))});
            JLabel directoryBackoutLabel = new JLabel(PreferencesFrame.I18N.getString("directory-backout"));
            JComponent bComponent = preferencesManager.getElement("backout-data-directory").getComponent();
            directoryBackoutLabel.setDisplayedMnemonic(PreferencesFrame.I18N.getString("directory-backout.mnemonic").charAt(0));
            directoryBackoutLabel.setLabelFor(bComponent);
            this.addLine(2, new JComponent[]{directoryBackoutLabel, bComponent}, true);
            dComponent.addKeyListener(keyListener);
            bComponent.addKeyListener(keyListener);
        }

        static /* synthetic */ MainPanel access$000(UpdateSourcePanel x0) {
            return x0.MainPanel.this;
        }
    }
}

