/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.GenericEditorPane;
import com.sun.swup.client.ui.InstallSummaryDialog;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.foundation.Utility;
import java.awt.Font;
import java.lang.ref.WeakReference;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class InstallSummaryEditorPane
extends GenericEditorPane {
    private WeakReference installSummaryDialog;

    InstallSummaryEditorPane(InstallSummaryDialog installSummaryDialog) {
        this.setInstallSummaryDialog(installSummaryDialog);
        this.setEditable(false);
        this.setFont(Utility.getReducedFont(this, "small-font-reduction"));
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        this.modifyStyleSheet(htmlEditorKit.getStyleSheet());
        this.setEditorKit(htmlEditorKit);
    }

    void populate() {
        UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
        Update[] aUpdate = ud.getInstallSummaryUpdates();
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<body><table width=\"100%\">");
        try {
            for (int i = 0; i < aUpdate.length; ++i) {
                int updateStatus = aUpdate[i].getUpdateOperateStatus();
                sb.append("<tr>");
                sb.append("<td width=\"5%\">");
                if (updateStatus == 2 || updateStatus == 4) {
                    sb.append("<img src=\"");
                    sb.append(Environment.getImageIcon((String)"restart-required.png"));
                    sb.append("\">");
                    sb.append("</img>");
                } else if (updateStatus == 3) {
                    sb.append("<img src=\"");
                    sb.append(Environment.getImageIcon((String)"download-only.png"));
                    sb.append("\">");
                    sb.append("</img>");
                } else if (updateStatus == 1) {
                    sb.append("<img src=\"");
                    sb.append(Environment.getImageIcon((String)"warning_medium.gif"));
                    sb.append("\">");
                    sb.append("</img>");
                } else {
                    sb.append("");
                }
                sb.append("</td>");
                sb.append("<td width=\"10%\">");
                sb.append(Utility.checkNull(aUpdate[i].getName()));
                sb.append("</td>");
                sb.append("<td>");
                sb.append(Utility.checkNull(aUpdate[i].getDescription()));
                sb.append("</td>");
                if (UMData.getDebug()) {
                    System.out.println("Update: " + aUpdate[i].getName() + " Status: " + updateStatus);
                }
                sb.append("<td width=\"15%\" align=\"left\">");
                switch (updateStatus) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: {
                        sb.append("<img src=\"");
                        sb.append(Environment.getImageIcon((String)"success_task.gif"));
                        sb.append("\">");
                        sb.append("</img>");
                        sb.append(InstallSummaryDialog.I18N.getString("installation-summary-success"));
                        break;
                    }
                    case 1: {
                        sb.append("<img src=\"");
                        sb.append(Environment.getImageIcon((String)"failed_task.gif"));
                        sb.append("\">");
                        sb.append("</img>");
                        sb.append(InstallSummaryDialog.I18N.getString("installation-summary-failed"));
                        break;
                    }
                    case -1: {
                        sb.append(InstallSummaryDialog.I18N.getString("installation-summary-not-set"));
                        break;
                    }
                    case 5: {
                        sb.append("<img src=\"");
                        sb.append(Environment.getImageIcon((String)"cancelled_task.gif"));
                        sb.append("\">");
                        sb.append("</img>");
                        sb.append(InstallSummaryDialog.I18N.getString("installation-summary-canceled"));
                        break;
                    }
                    default: {
                        sb.append(InstallSummaryDialog.I18N.getString("installation-summary-failed"));
                    }
                }
                sb.append("</td>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append("<td></td><td></td>");
                sb.append("<td>");
                sb.append(aUpdate[i].getUpdateOperateMessage());
                sb.append("</td>");
                sb.append("<td></td>");
                sb.append("</tr>");
            }
        }
        catch (Exception e) {
            System.err.println("error populating InstallSummaryEditorPane...");
        }
        sb.append("</table></html>");
        sb.append("</body>");
        if (UMData.getDebug()) {
            System.out.println("Install Summary:" + sb.toString());
        }
        this.setText(sb.toString());
        this.setCaretPosition(0);
    }

    private void modifyStyleSheet(StyleSheet styleSheet) {
        Font font = this.getFont();
        String sFontFamily = font.getFamily();
        int iFontSize = font.getSize();
        styleSheet.addRule("body {font-family:" + sFontFamily + ";font-size:" + iFontSize + "pt;}");
    }

    private void setInstallSummaryDialog(InstallSummaryDialog installSummaryDialog) {
        this.installSummaryDialog = new WeakReference<InstallSummaryDialog>(installSummaryDialog);
    }

    private InstallSummaryDialog getInstallSummaryDialog() {
        return (InstallSummaryDialog)this.installSummaryDialog.get();
    }
}

