/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.ui.AboutFrame;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.PreferencesManager;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

class CommonActionSet
extends GenericActionSet {
    private static final String EDIT_MENU_PLACEHOLDER_ACTION = "edit-menu-placeholder-action";

    CommonActionSet() {
        this.putAction("preferences", new PreferencesAction());
        this.putAction("authenticate", new AuthenticationAction());
        this.putAction("setup-wizard", new SetupWizardAction());
        this.putAction("subscription", new SubscriptionAction());
        this.putAction("enable-portal", new EnablePortalAction());
        this.putAction("quit", new QuitAction());
        this.putAction("cut-to-clipboard", new CutAction());
        this.putAction("copy-to-clipboard", new CopyAction());
        this.putAction("paste-from-clipboard", new PasteAction());
        this.putAction("select-all", new SelectAllAction());
        this.putAction("about", new AboutAction());
        this.putAction("manage-at-portal", new ManageAction());
        this.getAction("preferences").setEnabled(true);
        this.getAction("setup-wizard").setEnabled(true);
        this.getAction("subscription").setEnabled(true);
        this.getAction("enable-portal").setEnabled(true);
        this.getAction("quit").setEnabled(true);
        this.getAction("about").setEnabled(true);
        this.getAction("manage-at-portal").setEnabled(true);
    }

    class AuthenticationAction
    extends GenericAction {
        AuthenticationAction() {
            super("Authenticate", true);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            AuthenticationManager.getInstance().setAction(new AbstractAction(this){
                private final /* synthetic */ AuthenticationAction this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    Utility.alert("Successful Authentication", "Authentication was successful.");
                }
            });
            AuthenticationManager.getInstance().authenticate();
        }
    }

    class AboutAction
    extends GenericAction {
        AboutAction() {
            super(Application.I18N.getString("menu-help-about"));
            String sMnemonic = Application.I18N.getString("menu-help-about.mnemonic");
            this.putValue("MnemonicKey", new Integer(sMnemonic.charAt(0)));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            UpdateFrame updateFrame = Application.getInstance().getUpdateFrame();
            AboutFrame aboutFrame = Application.getInstance().getAboutFrame();
            if (!aboutFrame.isVisible()) {
                Utility.centerOverFrame(aboutFrame, (JFrame)updateFrame);
            }
            aboutFrame.setVisible(true);
        }
    }

    class SelectAllAction
    extends GenericAction {
        SelectAllAction() {
            super(Application.I18N.getString("menu-edit-select-all"));
            String sAccelerator = Application.I18N.getString("menu-edit-select-all.accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            System.err.println(CommonActionSet.EDIT_MENU_PLACEHOLDER_ACTION);
        }
    }

    class PasteAction
    extends GenericAction {
        PasteAction() {
            super(Application.I18N.getString("menu-edit-paste"));
            String sAccelerator = Application.I18N.getString("menu-edit-paste.accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            System.err.println(CommonActionSet.EDIT_MENU_PLACEHOLDER_ACTION);
        }
    }

    class CopyAction
    extends GenericAction {
        CopyAction() {
            super(Application.I18N.getString("menu-edit-copy"));
            String sAccelerator = Application.I18N.getString("menu-edit-copy.accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            System.err.println(CommonActionSet.EDIT_MENU_PLACEHOLDER_ACTION);
        }
    }

    class CutAction
    extends GenericAction {
        CutAction() {
            super(Application.I18N.getString("menu-edit-cut"));
            String sAccelerator = Application.I18N.getString("menu-edit-cut.accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            System.err.println(CommonActionSet.EDIT_MENU_PLACEHOLDER_ACTION);
        }
    }

    class QuitAction
    extends GenericAction {
        QuitAction() {
            super(Application.I18N.getString("menu-file-quit"));
            String sMnemonic = Application.I18N.getString("menu-file-quit.mnemonic");
            this.putValue("MnemonicKey", new Integer(sMnemonic.charAt(0)));
            String sAccelerator = Application.I18N.getString("menu-file-quit.accelerator");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)sAccelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            Application.getInstance().requestToQuit();
        }
    }

    class ManageAction
    extends GenericAction {
        ManageAction() {
            super(UpdateFrame.I18N.getString("available-manage-at-portal"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (CCRUtils.isPortalManagementEnabled()) {
                Utility.openPortalURL();
            } else {
                Application.getInstance().displayRegistration(2);
            }
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    class EnablePortalAction
    extends GenericAction {
        EnablePortalAction() {
            super(Application.I18N.getString("menu-file-enable-portal"));
            String sMnemonic = Application.I18N.getString("menu-file-enable-portal.mnemonic");
            this.putValue("MnemonicKey", new Integer(sMnemonic.charAt(0)));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (CCRUtils.isPortalManagementEnabled()) {
                Utility.openPortalURL();
            } else {
                Application.getInstance().displayRegistration(2);
            }
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    class SubscriptionAction
    extends GenericAction {
        SubscriptionAction() {
            super(Application.I18N.getString("menu-file-subscription"));
            String sMnemonic = Application.I18N.getString("menu-file-subscription.mnemonic");
            this.putValue("MnemonicKey", new Integer(sMnemonic.charAt(0)));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            Application.getInstance().displayRegistration(1);
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    class SetupWizardAction
    extends GenericAction {
        SetupWizardAction() {
            super(Application.I18N.getString("menu-file-setup-wizard"));
            String sMnemonic = Application.I18N.getString("menu-file-setup-wizard.mnemonic");
            this.putValue("MnemonicKey", new Integer(sMnemonic.charAt(0)));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            Application.getInstance().displayRegistration();
        }
    }

    class PreferencesAction
    extends GenericAction {
        PreferencesAction() {
            super(Application.I18N.getString("menu-file-preferences"));
            String sMnemonic = Application.I18N.getString("menu-file-preferences.mnemonic");
            this.putValue("MnemonicKey", new Integer(sMnemonic.charAt(0)));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getPredefinedCursor(3));
            PreferencesManager.getInstance().displayPreferencesFrame();
            Application.getInstance().getUpdateFrame().setCursor(Cursor.getDefaultCursor());
        }
    }
}

