/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AvailableTableModel;
import com.sun.swup.client.ui.DateTableCellRenderer;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.SizeTableCellRenderer;
import com.sun.swup.client.ui.UpdateCategorySorterCompare;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.swing.ComponentTableHeaderRenderer;
import com.sun.swup.client.ui.foundation.swing.GenericTable;
import com.sun.swup.client.ui.foundation.swing.GenericTableCellRenderer;
import com.sun.swup.client.ui.foundation.swing.GenericTableColumnModel;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import com.sun.swup.client.ui.foundation.swing.SorterCompare;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import com.sun.swup.client.ui.foundation.swing.TextAndIcon;
import com.sun.swup.client.ui.foundation.swing.TextIconTableHeaderRenderer;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class AvailableTable
extends GenericTable {
    private WeakReference updateFrame;
    private JPanel checkPanel;
    private TableCellRenderer dashCellRenderer = new DashCellRenderer();

    AvailableTable(UpdateFrame updateFrame, JPanel checkPanel) {
        this.setUpdateFrame(updateFrame);
        this.checkPanel = checkPanel;
        this.setName("available-table");
        this.setSelectionMode(0);
        GenericTableColumnModel columnModel = new GenericTableColumnModel(this.getName());
        columnModel.addColumn(" ", -1, 40);
        columnModel.addColumn(UpdateFrame.I18N.getString("available-table-name"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("available-table-synopsis"), 2);
        columnModel.addColumn(" ", -1, 20);
        columnModel.addColumn(" ", -1, 20);
        columnModel.addColumn(UpdateFrame.I18N.getString("available-table-category"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("available-table-date"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("available-table-installed-revision"), 4, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("available-table-size"), 4, 75);
        columnModel.getColumn(0).setResizable(false);
        columnModel.getColumn(0).setHeaderRenderer(new ComponentTableHeaderRenderer());
        columnModel.getColumn(0).setHeaderValue(checkPanel);
        columnModel.getColumn(4).setResizable(false);
        columnModel.getColumn(4).setHeaderRenderer(new TextIconTableHeaderRenderer());
        columnModel.getColumn(4).setHeaderValue(new TextAndIcon(null, Environment.getImageIcon((String)"restart-required.png")));
        columnModel.getColumn(3).setResizable(false);
        columnModel.getColumn(3).setHeaderRenderer(new TextIconTableHeaderRenderer());
        columnModel.getColumn(3).setHeaderValue(new TextAndIcon(null, Environment.getImageIcon((String)"download-only.png")));
        columnModel.getColumn(6).setCellRenderer(new DateTableCellRenderer());
        columnModel.getColumn(8).setCellRenderer(new SizeTableCellRenderer());
        Application.getInstance().getStateManager().restoreTableColumnWidths(columnModel);
        columnModel.addColumnModelListener(Application.getInstance().getStateManager());
        this.setColumnModel(columnModel);
        AvailableTableModel model = new AvailableTableModel();
        model.setColumnCount(columnModel.getColumnCount());
        this.setModel(model);
        model.getSorter().putSorterCompare(5, (SorterCompare)new UpdateCategorySorterCompare());
        SortedTableHeader sortedTableHeader = new SortedTableHeader(columnModel);
        this.setTableHeader(sortedTableHeader);
        StateManager stateManager = Application.getInstance().getStateManager();
        stateManager.restoreSortedTableColumn(sortedTableHeader, 5, 1);
        this.getTableHeader().addMouseListener(new MouseHandler());
    }

    void autocheckDependencies(Dependency[] aDependency) {
        for (int i = 0; i < aDependency.length; ++i) {
            Dependency dependency = aDependency[i];
            for (int k = 0; k < this.getModel().getRowCount(); ++k) {
                String sName = (String)this.getModel().getValueAt(k, 1);
                for (int l = 0; l < dependency.getDependantsCount(); ++l) {
                    Update aUpdate = dependency.getDependant(l);
                    if (!sName.equals(aUpdate.getName())) continue;
                    this.getModel().setValueAt(new Boolean(true), k, 0);
                }
            }
        }
    }

    public TableCellRenderer getCellRenderer(int iRow, int iColumn) {
        AvailableTableModel model = (AvailableTableModel)this.getModel();
        Update update = model.getUpdateAt(iRow);
        int us = update.getUpdateOperateStatus();
        int us1 = 0;
        if (update.getUpdateStatus() != null) {
            us1 = update.getUpdateStatus();
        }
        if (iColumn == 0 && (us1 == 7 || us == 2 || us == 4)) {
            return this.dashCellRenderer;
        }
        return super.getCellRenderer(iRow, iColumn);
    }

    public boolean isCellEditable(int iRow, int iColumn) {
        AvailableTableModel model = (AvailableTableModel)this.getModel();
        Update update = model.getUpdateAt(iRow);
        int us = update.getUpdateOperateStatus();
        int us1 = 0;
        if (update.getUpdateStatus() != null) {
            us1 = update.getUpdateStatus();
        }
        if (iColumn == 0) {
            if (us1 == 7 || us == 2 || us == 4) {
                return false;
            }
            return super.isCellEditable(iRow, iColumn);
        }
        return super.isCellEditable(iRow, iColumn);
    }

    void removeUpdates(Update[] aUpdate) {
        SortedTableHeader header = (SortedTableHeader)this.getTableHeader();
        AvailableTableModel model = (AvailableTableModel)this.getModel();
        model.removeUpdates(aUpdate);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
    }

    void removeCheckedUpdates() {
        SortedTableHeader header = (SortedTableHeader)this.getTableHeader();
        AvailableTableModel model = (AvailableTableModel)this.getModel();
        Update[] checkedUpdates = model.getCheckedUpdates();
        model.removeUpdates(checkedUpdates);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
    }

    void removeAppliedUpdates(Update[] updates) {
        SortedTableHeader header = (SortedTableHeader)this.getTableHeader();
        AvailableTableModel model = (AvailableTableModel)this.getModel();
        model.removeUpdates(updates);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }

    public void updateTableHeader() {
        JTableHeader tableHeader = this.getTableHeader();
        if (tableHeader != null) {
            tableHeader.invalidate();
            tableHeader.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader tableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel columnModel = tableHeader.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(mouseEvent.getX());
            TableColumn tableColumn = columnModel.getColumn(viewColumn);
            int columnIndex = tableColumn.getModelIndex();
            if (UMData.getDebug()) {
                System.out.println("mouse clicked at column index: " + columnIndex);
            }
            if (columnIndex == 0) {
                if (mouseEvent.getX() <= tableColumn.getWidth() / 2) {
                    ((AvailableTableModel)AvailableTable.this.getModel()).checkAll();
                } else {
                    ((AvailableTableModel)AvailableTable.this.getModel()).uncheckAll();
                }
            }
        }
    }

    class DashCellRenderer
    extends GenericTableCellRenderer {
        DashCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object oValue, boolean bSelected, boolean bHasFocus, int iRow, int iColumn) {
            oValue = new String("    -    ");
            return super.getTableCellRendererComponent(table, oValue, bSelected, bHasFocus, iRow, iColumn);
        }
    }
}

