/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.xml.viperbean;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ViperProperties;
import com.sun.management.viperimpl.xml.ParseException;
import com.sun.management.viperimpl.xml.viperbean.ComponentElement;
import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.ElementFactory;
import com.sun.xml.tree.SimpleElementFactory;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.w3c.dom.Element;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DescriptorManager {
    protected static String viperPublicId = "-//Sun Microsystems, Inc.//Viper Component//EN";
    protected static String viperSystemId = "http://www.sun.com/solaris/management/dtds/viperbean_1_0.dtd";
    private static final String DEFAULT_DTD = "/lib/dtds/viperbean_1_0.dtd";

    public static ComponentInfo createDescriptor(URL url) throws ParseException {
        return DescriptorManager.createDescriptor(url, true, false);
    }

    public static ComponentInfo createDescriptor(URL url, boolean validate) throws ParseException {
        return DescriptorManager.createDescriptor(url, validate, false);
    }

    public static ComponentInfo createDescriptor(URL url, boolean validate, boolean rawtext) throws ParseException {
        Element root;
        try {
            Parser parser;
            XmlDocumentBuilder builder = new XmlDocumentBuilder();
            InputSource input = Resolver.createInputSource((URL)url, (boolean)false);
            Properties props = new Properties();
            SimpleElementFactory factory = new SimpleElementFactory();
            String pkg = "com.sun.management.viperimpl.xml.viperbean";
            if (validate) {
                parser = new ValidatingParser(true);
                props.setProperty("service", pkg + ".ServiceElement");
                props.setProperty("tool", pkg + ".ToolElement");
                props.setProperty("xclient-provider", pkg + ".XCProviderElement");
            } else {
                parser = new Parser();
            }
            props.setProperty("component", pkg + ".ComponentElement");
            factory.addMapping((Dictionary)props, DescriptorManager.class.getClassLoader());
            builder.setElementFactory((ElementFactory)factory);
            parser.setEntityResolver((EntityResolver)((Object)new LocalResolver()));
            parser.setDocumentHandler((DocumentHandler)builder);
            parser.parse(input);
            root = builder.getDocument().getDocumentElement();
        }
        catch (SAXParseException e) {
            String[] fargs = new String[]{"" + e.getLineNumber(), e.getSystemId(), e.getMessage()};
            throw new ParseException("ParseError", fargs, (Exception)e);
        }
        catch (SAXException e) {
            Exception ae = e.getException();
            if (ae != null && ae instanceof ParseException) {
                throw (ParseException)((Object)ae);
            }
            throw new ParseException("UnexpectedException", e);
        }
        catch (IOException e) {
            throw new ParseException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            throw new ParseException("UnexpectedException", e);
        }
        if (root instanceof ComponentElement) {
            return ((ComponentElement)((Object)root)).getComponentInfo();
        }
        throw new ParseException("InvalidRootElement", "component");
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 1) {
            System.err.println("Usage: $0 <XML_file>");
            System.err.println("<XML_file>: path or url to XML file");
            System.exit(1);
        }
        try {
            ComponentInfo conf;
            try {
                conf = DescriptorManager.createDescriptor(new URL(argv[0]));
            }
            catch (MalformedURLException e) {
                conf = DescriptorManager.createDescriptor(new File(argv[0]).toURL());
            }
            System.out.println("\nPrinting parsing result:");
            System.out.println(conf);
            System.out.println("\nParsing succeeded.");
        }
        catch (ParseException e) {
            System.out.println("\n" + e.getMessage());
            System.out.println("\nParsing failed.");
            System.exit(1);
        }
    }

    static class LocalResolver
    extends Resolver {
        private String defaultSystemId = "file:" + ViperProperties.getViperHome() + "/lib/dtds/viperbean_1_0.dtd";

        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (!publicId.equals(viperPublicId)) {
                Debug.trace((String)"Descriptor Parser", (int)Debug.ERROR, (String)"Descriptor XML file has different public id. Use default DTD anyway.", null);
            }
            return super.resolveEntity(publicId, this.defaultSystemId);
        }
    }
}

