/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.servlet;

import com.sun.management.viperimpl.ViperImplVersion;
import com.sun.management.viperimpl.server.Registry;
import com.sun.management.viperimpl.server.RegistryProgress;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InfoServlet
extends HttpServlet {
    protected Properties serverInfo;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Properties sysProp = System.getProperties();
        this.serverInfo = new Properties();
        this.serverInfo.setProperty("viper.api.version", "1.1");
        this.serverInfo.setProperty("viper.impl.version", ViperImplVersion.getVersion());
        this.serverInfo.setProperty("viper.impl.fullversion", ViperImplVersion.getFullVersion());
        this.serverInfo.setProperty("os.name", sysProp.getProperty("os.name"));
        this.serverInfo.setProperty("os.arch", sysProp.getProperty("os.arch"));
        this.serverInfo.setProperty("os.version", sysProp.getProperty("os.version"));
        this.serverInfo.setProperty("rolesupport", "true");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null || path.length() <= 1) {
            this.sendInternalError(res, path);
            return;
        }
        ServletOutputStream sos = res.getOutputStream();
        if ((path = path.substring(1).trim()).equals("startupProgress")) {
            this.sendStartupProgress(sos);
        } else if (path.equals("serverInfo")) {
            this.sendServerInfo(sos);
        } else {
            this.sendInternalError(res, path);
        }
        sos.close();
    }

    protected void sendServerInfo(ServletOutputStream sos) throws IOException {
        this.serverInfo.store((OutputStream)sos, null);
    }

    protected void sendStartupProgress(ServletOutputStream sos) throws IOException {
        RegistryProgress rp = Registry.getProgress();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)sos));
        bw.write("completed: " + rp.completed);
        bw.newLine();
        bw.write("total: " + rp.total);
        bw.newLine();
        bw.write("task: " + rp.task);
        bw.newLine();
        bw.flush();
        bw.close();
    }

    private void sendInternalError(HttpServletResponse res, String file) throws IOException {
        res.sendError(404, "File not found.");
    }

    public void log(String message) {
    }

    public void log(String message, Throwable t) {
    }
}

