/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.audit.AuditEvent_admin_authenticate;
import com.sun.audit.AuditEvent_role_login;
import com.sun.audit.AuditSession;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.Log;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.VAuditSession;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.SecurityContext;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;

public abstract class ServerSecurityContext
extends SecurityContext {
    private boolean msgVerify = false;
    private long clientVers = 0L;
    private String clientHost = null;
    private String clientVMID = null;
    private String userPswd = null;
    private Log logsvc = null;
    private int maxRetries;
    private int uid = -1;
    private int gid = -1;
    private String home = null;
    private String shell = null;
    private long htbtTime;
    protected static final String AUTH_SERVICE_RESOURCES = "com.sun.management.viperimpl.services.authentication.server.AuthenticationServiceResources";
    private VAuditSession auditSession = null;

    public ServerSecurityContext(AuthenticationFlavor authFlavor) throws AuthenticationException {
        super(authFlavor);
        try {
            this.maxRetries = Integer.parseInt("5");
        }
        catch (NumberFormatException e) {
            this.maxRetries = 5;
        }
        this.setHeartbeatTime();
        this.auditSession = AuthenticationLibrary.getAuditSession();
        if (this.auditSession == null) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Could not get audit session", null);
        }
        this.setAuthState(0);
    }

    public abstract ServerSecurityContext newCopy() throws AuthenticationException;

    public abstract boolean verifyAuthFlavor(AuthenticationFlavor var1) throws AuthenticationException;

    public abstract ResponseSecurityToken verifyRequestToken(RequestSecurityToken var1) throws AuthenticationException;

    public abstract ConfirmSecurityToken verifyAuthenticatorToken(AuthenticatorSecurityToken var1) throws AuthenticationException;

    public abstract void verifyMessageToken(MessageSecurityToken var1, Object[] var2) throws AuthenticationException;

    public abstract String decryptPassword(byte[] var1) throws AuthenticationException;

    public long getClientVersion() {
        return this.clientVers;
    }

    public void setClientVersion(long version) {
        this.clientVers = version;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String hostname) {
        this.clientHost = hostname;
    }

    public String getClientVMID() {
        return this.clientVMID;
    }

    public void setClientVMID(String vmid) {
        this.clientVMID = vmid;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int times) {
        this.maxRetries = times;
    }

    public String getUserPassword() {
        return AuthenticationUtil.unhashPassword(this.userPswd);
    }

    public void setUserPassword(String userPassword) {
        this.userPswd = AuthenticationUtil.hashPassword(userPassword);
    }

    public boolean isVerify() {
        return this.msgVerify;
    }

    public void setVerify(boolean state) {
        this.msgVerify = state;
    }

    public void disableVerify() {
        this.msgVerify = false;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public String getShell() {
        return this.shell;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public long getHeartbeatTime() {
        return this.htbtTime;
    }

    public void setHeartbeatTime() {
        this.htbtTime = System.currentTimeMillis();
    }

    public void setLogService(Log logService) {
        this.logsvc = logService;
    }

    protected void writeLog(int severity, String sumMsg, String detMsg) {
        this.writeLog(severity, sumMsg, detMsg, (String[])null);
    }

    protected void writeLog(int severity, String sumMsg, String detMsg, String arg1) {
        this.writeLog(severity, sumMsg, detMsg, new String[]{arg1});
    }

    protected void writeLog(int severity, String sumMsg, String detMsg, String arg1, String arg2) {
        this.writeLog(severity, sumMsg, detMsg, new String[]{arg1, arg2});
    }

    protected void writeLog(int severity, String sumMsg, String detMsg, String arg1, String arg2, String arg3) {
        this.writeLog(severity, sumMsg, detMsg, new String[]{arg1, arg2, arg3});
    }

    protected void writeLog(int severity, String sumMsg, String detMsg, String[] args) {
        if (this.logsvc != null) {
            try {
                this.logsvc.writeLog("LMS_AuthSvcName", "security", severity, sumMsg, detMsg, args, AUTH_SERVICE_RESOURCES, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void auditBadUser(String clientHost, VIdentity id, String label) {
        if (this.auditSession == null || !this.auditSession.auditOn()) {
            return;
        }
        try {
            AuditSession as = (AuditSession)this.auditSession.getPlatformAuditSession();
            if (as == null) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Could not get platform audit session", null);
                return;
            }
            this.auditSession.setIdentity(id, clientHost);
            this.auditSession.setLabel(label);
            if (id.isInRole()) {
                AuditEvent_role_login loginEvent = new AuditEvent_role_login(as);
                loginEvent.message(3);
                loginEvent.putEvent(-1, 0);
            } else {
                AuditEvent_admin_authenticate loginEvent = new AuditEvent_admin_authenticate(as);
                loginEvent.message(3);
                loginEvent.putEvent(-1, 0);
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"exception caught in auditBadUser", (Throwable)e);
        }
    }

    protected void auditBadPasswd(String clientHost, VIdentity id, String label) {
        if (this.auditSession == null || !this.auditSession.auditOn()) {
            return;
        }
        try {
            AuditSession as = (AuditSession)this.auditSession.getPlatformAuditSession();
            if (as == null) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Could not get platform audit session", null);
                return;
            }
            this.auditSession.setIdentity(id, clientHost);
            this.auditSession.setLabel(label);
            if (id.isInRole()) {
                AuditEvent_role_login loginEvent = new AuditEvent_role_login(as);
                loginEvent.message(4);
                loginEvent.putEvent(-1, 0);
            } else {
                AuditEvent_admin_authenticate loginEvent = new AuditEvent_admin_authenticate(as);
                loginEvent.message(4);
                loginEvent.putEvent(-1, 0);
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"exception caught in auditBadPasswd", (Throwable)e);
        }
    }

    protected void auditAuthSuccess(String clientHost, VIdentity id, String label) {
        if (this.auditSession == null || !this.auditSession.auditOn()) {
            return;
        }
        try {
            AuditSession as = (AuditSession)this.auditSession.getPlatformAuditSession();
            if (as == null) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Could not get platform audit session", null);
                return;
            }
            this.auditSession.setIdentity(id, clientHost);
            this.auditSession.setLabel(label);
            if (id.isInRole()) {
                AuditEvent_role_login loginEvent = new AuditEvent_role_login(as);
                loginEvent.message(0);
                loginEvent.putEvent(0, 0);
            } else {
                AuditEvent_admin_authenticate loginEvent = new AuditEvent_admin_authenticate(as);
                loginEvent.message(0);
                loginEvent.putEvent(0, 0);
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"exception caught in auditAuthSuccess", (Throwable)e);
        }
    }

    protected void copyAttrs(ServerSecurityContext sctx) throws AuthenticationException {
        super.copyAttrs(sctx);
        sctx.setVerify(this.msgVerify);
        sctx.setClientVersion(this.clientVers);
        if (this.clientHost != null) {
            sctx.setClientHost(new String(this.clientHost));
        }
        if (this.clientVMID != null) {
            sctx.setClientVMID(new String(this.clientVMID));
        }
        if (this.userPswd != null) {
            sctx.setUserPassword(this.getUserPassword());
        }
        sctx.setLogService(this.logsvc);
        sctx.setMaxRetries(this.maxRetries);
    }

    public VAuditSession getAuditSession() {
        return this.auditSession;
    }

    public void auditRetryLimitExceeded(String clientHost, VIdentity id, String label) {
        if (this.auditSession == null || !this.auditSession.auditOn()) {
            return;
        }
        try {
            AuditSession as = (AuditSession)this.auditSession.getPlatformAuditSession();
            if (as == null) {
                Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Could not get platform audit session", null);
                return;
            }
            this.auditSession.setIdentity(id, clientHost);
            this.auditSession.setLabel(label);
            if (id.isInRole()) {
                AuditEvent_role_login loginEvent = new AuditEvent_role_login(as);
                loginEvent.message(6);
                loginEvent.putEvent(-1, 0);
            } else {
                AuditEvent_admin_authenticate loginEvent = new AuditEvent_admin_authenticate(as);
                loginEvent.message(6);
                loginEvent.putEvent(-1, 0);
            }
        }
        catch (Exception e) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"exception caught in auditRetryLimitExceeded", (Throwable)e);
        }
    }
}

