/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.services.AuthenticationMessageException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationLoginException;
import com.sun.management.viperimpl.services.authentication.AuthenticationPrincipal;
import com.sun.management.viperimpl.services.authentication.AuthenticationUtil;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestAuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestMessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.MessageSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import java.net.InetAddress;

public class DigestServerSecurityContext
extends ServerSecurityContext {
    private boolean signing;
    private boolean integrity = false;
    private byte[] clientkey = null;
    private byte[] serverchg = null;
    private byte[] clientchg = null;
    private byte[] sessionkey = null;
    private byte[] hashpswd = null;
    private byte[] salt = null;
    private String username = null;
    private String userpswd = null;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestServerSecurityContext(DigestAuthFlavor flavor) throws AuthenticationException {
        super(flavor);
    }

    public boolean verifyAuthFlavor(AuthenticationFlavor clientFlavor) throws AuthenticationException {
        boolean sw = true;
        boolean bool = false;
        DigestAuthFlavor cflavor = null;
        try {
            cflavor = (DigestAuthFlavor)clientFlavor;
        }
        catch (Exception ex) {
            this.writeLog(400, "LMS_SecurityError", "LMD_AuthTypeMismatch", clientFlavor.getAuthTypeName(), "Digest");
            sw = false;
        }
        DigestAuthFlavor sflavor = (DigestAuthFlavor)this.getAuthFlavor();
        while (sw) {
            if (cflavor.getAuthType() != 0) {
                this.writeLog(400, "LMS_SecurityError", "LMD_AuthTypeMismatch", cflavor.getAuthTypeName(), "Digest");
                break;
            }
            if (!sflavor.getDigestAlgorithm().equals(cflavor.getDigestAlgorithm())) {
                this.writeLog(400, "LMS_SecurityError", "LMD_DigestAlgoMismatch", cflavor.getDigestAlgorithm(), sflavor.getDigestAlgorithm());
                break;
            }
            if (!sflavor.getSignatureAlgorithm().equals(cflavor.getSignatureAlgorithm())) {
                this.writeLog(400, "LMS_SecurityError", "LMD_SignAlgoMismatch", cflavor.getSignatureAlgorithm(), sflavor.getSignatureAlgorithm());
                break;
            }
            if (!sflavor.getKeyGenerationAlgorithm().equals(cflavor.getKeyGenerationAlgorithm())) {
                this.writeLog(400, "LMS_SecurityError", "LMD_KeyAlgoMismatch", cflavor.getKeyGenerationAlgorithm(), sflavor.getKeyGenerationAlgorithm());
                break;
            }
            if (sflavor.getKeyStrength() != cflavor.getKeyStrength()) {
                this.writeLog(400, "LMS_SecurityError", "LMD_KeySizeMismatch", new Integer(cflavor.getKeyStrength()).toString(), new Integer(sflavor.getKeyStrength()).toString());
                break;
            }
            bool = true;
            sw = false;
        }
        if (!bool) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication flavor mismatch", null);
        }
        return bool;
    }

    public ResponseSecurityToken verifyRequestToken(RequestSecurityToken requestToken) throws AuthenticationException {
        this.clientkey = null;
        this.serverchg = null;
        this.clientchg = null;
        this.sessionkey = null;
        this.hashpswd = null;
        this.username = null;
        this.userpswd = null;
        this.salt = null;
        RequestSecurityToken dtok = requestToken;
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying authentication request...", null);
        String hash_str = null;
        int uid = -1;
        int gid = -1;
        String home = null;
        String shell = null;
        String salt_str = null;
        AuthenticationPrincipal ap = dtok.getAuthPrincipal();
        if (ap != (AuthenticationPrincipal)null) {
            this.username = ap.getName();
            if (this.username != (String)null) {
                try {
                    hash_str = AuthenticationLibrary.getPassword(this.username);
                    if (hash_str == null) {
                        throw new AuthenticationLoginException();
                    }
                    uid = Integer.parseInt(AuthenticationLibrary.getUid(this.username));
                    gid = Integer.parseInt(AuthenticationLibrary.getGid(this.username));
                    home = AuthenticationLibrary.getHomedir(this.username);
                    shell = AuthenticationLibrary.getShell(this.username);
                }
                catch (Exception ex) {
                    Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("cannot get user \"" + this.username + "\" account info"), (Throwable)ex);
                }
                if (hash_str == null || hash_str.trim().length() == 0) {
                    Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)("Cannot access user password for " + this.username), null);
                    this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadUser", this.username, dtok.getClientHost());
                    this.auditBadUser(dtok.getClientHost(), this.convertToVId(ap), null);
                    throw new AuthenticationLoginException();
                }
                salt_str = hash_str.substring(0, 2);
            } else {
                ap = null;
            }
        }
        if (ap == (AuthenticationPrincipal)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)"Null or invalid admin principal identity", null);
            throw new AuthenticationException("EXSS_BUI");
        }
        this.hashpswd = hash_str.getBytes();
        this.salt = salt_str.getBytes();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   Client user identity=" + this.username), null);
        this.serverchg = new byte[16];
        DigestSecurityUtil.getRandomBytes(this.serverchg);
        byte[] key = new byte[32];
        DigestSecurityUtil.getRandomBytes(key);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   challenge=" + this.toHex(this.serverchg)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   salt=" + salt_str), null);
        DigestResponseSecurityToken rtok = new DigestResponseSecurityToken(this.getSecurityId());
        rtok.setChallenge(this.serverchg);
        rtok.setPasswordSalt(this.salt);
        rtok.setServerKey(key);
        this.setAuthPrincipal(ap);
        this.setUid(uid);
        this.setGid(gid);
        this.setHome(home);
        this.setShell(shell);
        this.setClientHost(dtok.getClientHost());
        this.setAuthState(2);
        return rtok;
    }

    public ConfirmSecurityToken verifyAuthenticatorToken(AuthenticatorSecurityToken authToken) throws AuthenticationException {
        String remoteuser;
        byte[] pwb;
        DigestAuthenticatorSecurityToken dtok = null;
        try {
            dtok = (DigestAuthenticatorSecurityToken)authToken;
        }
        catch (Exception ex) {
            this.writeLog(400, "LMS_SecurityError", "LMD_BadAuthToken");
            throw new AuthenticationException("EXSS_BAT");
        }
        byte[] msg_digest = dtok.getMessageDigest();
        byte[] authenticator = dtok.getAuthenticatorDigest();
        byte[] ses_digest = dtok.getSessionDigest();
        this.clientchg = dtok.getChallenge();
        this.clientkey = dtok.getClientKey();
        AuthenticationPrincipal ap = this.getAuthPrincipal();
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying authenticator...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   msg digest=" + this.toHex(msg_digest)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   auth digest=" + this.toHex(authenticator)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   sess digest=" + this.toHex(ses_digest)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   client chal=" + this.toHex(this.clientchg)), null);
        byte[] testdigest = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        try {
            pwb = DigestSecurityUtil.decryptPassword(testdigest, msg_digest);
        }
        catch (VException ex) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (1)", (Throwable)ex);
            this.clientkey = null;
            String user = ap.getUserName();
            if (ap.getRoleName() != null) {
                user = user + " (in role " + ap.getRoleName() + ")";
            }
            this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadPwd", user, this.getClientHost());
            this.auditBadPasswd(this.getClientHost(), this.convertToVId(ap), null);
            throw new AuthenticationLoginException();
        }
        this.userpswd = AuthenticationUtil.hashPassword(new String(pwb));
        try {
            this.sessionkey = DigestSecurityUtil.encryptDigest(ses_digest, testdigest);
        }
        catch (VException ex) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (2)", (Throwable)ex);
            this.clientkey = null;
            this.username = null;
            this.userpswd = null;
            String user = ap.getUserName();
            if (ap.getRoleName() != null) {
                user = user + " (in role " + ap.getRoleName() + ")";
            }
            this.writeLog(100, "LMS_LoginFailed", "LMD_DecryptSKeyFailed", user);
            throw new AuthenticationLoginException();
        }
        byte[] kb = this.clientkey;
        testdigest = DigestSecurityUtil.generateDigest(msg_digest, kb, pwb);
        for (int i = 0; i < pwb.length; ++i) {
            pwb[i] = 0;
        }
        if (!DigestSecurityUtil.compareDigests(authenticator, testdigest)) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (3)", null);
            this.clientkey = null;
            this.username = null;
            this.userpswd = null;
            this.sessionkey = null;
            String user = ap.getUserName();
            if (ap.getRoleName() != null) {
                user = user + " (in role " + ap.getRoleName() + ")";
            }
            this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadPwd", user, this.getClientHost());
            this.auditBadPasswd(this.getClientHost(), this.convertToVId(ap), null);
            throw new AuthenticationLoginException();
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Authenticator digest is verified!", null);
        String string = remoteuser = this.username.equals(ap.getUserName()) ? null : ap.getUserName();
        if (AuthenticationLibrary.doPamAuthentication(this.username, remoteuser, AuthenticationUtil.unhashPassword(this.userpswd)) != 0) {
            Debug.trace((String)"Authentication Service", (int)Debug.WARNING, (String)"Authentication Failed! (4)", null);
            this.clientkey = null;
            this.username = null;
            this.userpswd = null;
            this.sessionkey = null;
            String user = ap.getUserName();
            if (ap.getRoleName() != null) {
                user = user + " (in role " + ap.getRoleName() + ")";
            }
            this.writeLog(100, "LMS_LoginFailed", "LMD_LoginBadOthers", user, this.getClientHost());
            throw new AuthenticationLoginException();
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"User authenticated to Solaris", null);
        byte[] rb = "success".getBytes();
        byte[] digest = DigestSecurityUtil.generateDigest(this.clientchg, this.hashpswd, rb);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   result digest=" + this.toHex(digest)), null);
        AuthenticationPrincipal[] rolelist = null;
        String[] roles = AuthenticationLibrary.getRoleNames(this.username);
        if (roles != null) {
            rolelist = new AuthenticationPrincipal[roles.length];
            String myIP = null;
            try {
                myIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < roles.length; ++i) {
                rolelist[i] = new AuthenticationPrincipal(0, this.username, roles[i]);
                rolelist[i].setUserDesc(AuthenticationLibrary.getDesc(this.username));
                rolelist[i].setRoleDesc(AuthenticationLibrary.getDesc(roles[i]));
                if (myIP != null) {
                    rolelist[i].setHostName(myIP);
                }
                Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("role[" + i + "]=" + rolelist[i]), null);
            }
        }
        DigestConfirmSecurityToken rtok = new DigestConfirmSecurityToken(this.getSecurityId(), rolelist);
        rtok.setHeartbeatPeriod(this.getHeartbeatPeriod());
        rtok.setResultMessage("success");
        rtok.setMessageDigest(digest);
        if (this.isIntegrityRequired()) {
            rtok.setIntegrity();
        }
        this.setAuthState(4);
        try {
            this.auditAuthSuccess(this.getClientHost(), this.convertToVId(ap), null);
        }
        catch (Exception ex) {
            throw new AuthenticationLoginException(ex.getLocalizedMessage());
        }
        return rtok;
    }

    public void verifyMessageToken(MessageSecurityToken messageToken, Object[] objs) throws AuthenticationException {
        byte[] e_digest;
        byte[] c_digest;
        DigestMessageSecurityToken dtok;
        try {
            dtok = (DigestMessageSecurityToken)messageToken;
        }
        catch (Exception ex) {
            throw new AuthenticationException("EXSS_BVT");
        }
        byte[] s_digest = this.serverchg;
        if (this.isIntegrityRequired() && objs != null && objs.length > 0) {
            s_digest = DigestSecurityUtil.generateDigest(objs);
        }
        if ((c_digest = DigestSecurityUtil.encryptDigest(e_digest = dtok.getDigest(), this.sessionkey)) == null) {
            throw new AuthenticationException("EXSS_BVD");
        }
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)"Verifying message...", null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   server digest=" + this.toHex(s_digest)), null);
        Debug.trace((String)"Authentication Service", (int)Debug.INFORMATION, (String)("   client digest=" + this.toHex(c_digest)), null);
        if (!DigestSecurityUtil.compareDigests(s_digest, c_digest)) {
            throw new AuthenticationMessageException();
        }
    }

    public String decryptPassword(byte[] passwordHash) throws AuthenticationException {
        byte[] pwb;
        if (this.getAuthState() != 4) {
            throw new AuthenticationException("EXSS_NAX", (Object)"encryptPassword");
        }
        byte[] digest = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        try {
            pwb = DigestSecurityUtil.decryptPassword(digest, passwordHash);
        }
        catch (VException ex) {
            throw new AuthenticationException("EXSS_BEP");
        }
        String str = new String(pwb);
        return str;
    }

    public ServerSecurityContext newCopy() throws AuthenticationException {
        DigestServerSecurityContext nctx = new DigestServerSecurityContext((DigestAuthFlavor)this.getAuthFlavor());
        super.copyAttrs(nctx);
        nctx.setClientKey(this.clientkey);
        nctx.setServerChallenge(this.serverchg);
        nctx.setClientChallenge(this.clientchg);
        nctx.setPasswordHash(this.hashpswd);
        nctx.setPasswordSalt(this.salt);
        nctx.setUserPassword(this.userpswd);
        if (this.integrity) {
            nctx.setIntegrity();
        }
        return nctx;
    }

    public byte[] getClientKey() {
        return this.clientkey;
    }

    public void setClientKey(byte[] clientKey) {
        this.clientkey = clientKey;
    }

    public void setServerChallenge(byte[] value) {
        if (value != null) {
            this.serverchg = new byte[value.length];
            System.arraycopy(value, 0, this.serverchg, 0, value.length);
        } else {
            this.serverchg = null;
        }
    }

    public void setClientChallenge(byte[] value) {
        if (value != null) {
            this.clientchg = new byte[value.length];
            System.arraycopy(value, 0, this.clientchg, 0, value.length);
        } else {
            this.clientchg = null;
        }
    }

    public void setPasswordHash(byte[] pswdHash) {
        if (pswdHash != null) {
            this.hashpswd = new byte[pswdHash.length];
            System.arraycopy(pswdHash, 0, this.hashpswd, 0, pswdHash.length);
        } else {
            this.hashpswd = null;
        }
    }

    public void setPasswordSalt(byte[] pswdSalt) {
        if (pswdSalt != null) {
            this.salt = new byte[pswdSalt.length];
            System.arraycopy(pswdSalt, 0, this.salt, 0, pswdSalt.length);
        } else {
            this.salt = null;
        }
    }

    public void setUserPassword(String userPswd) {
        this.userpswd = userPswd != null ? new String(userPswd) : null;
    }

    public boolean isIntegrityRequired() {
        return this.integrity & this.isVerify();
    }

    public void setIntegrity() {
        this.integrity = true;
    }

    private String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        if (data == null) {
            return "(null)";
        }
        if (data.length == 0) {
            return "(empty)";
        }
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    private VIdentity convertToVId(AuthenticationPrincipal ap) {
        VIdentity id = ap.getRoleName() == null ? new VIdentity(ap.getUserName(), ap.getUserDesc(), ap.getUserName(), ap.getUserDesc(), ap.getHostName()) : new VIdentity(ap.getRoleName(), ap.getRoleDesc(), ap.getUserName(), ap.getUserDesc(), ap.getHostName());
        return id;
    }
}

