/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.VAuditSession;
import com.sun.management.viperimpl.VAuditSessionImpl;

public class AuthenticationLibrary {
    public static final String AUTHENTICATION_LIBRARY = "passauthen";
    private static boolean library_loaded = false;

    private static native int loginauthen(String var0, String var1, String var2);

    private static native String[] getrolenames(String var0);

    private static native String[] userinfo(String var0);

    private static native String processowner();

    public static synchronized int doPamAuthentication(String user, String remoteuser, String password) throws AuthenticationException {
        int authcode = -1;
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        if (user == null || user.trim().length() == 0) {
            return authcode;
        }
        if (password == null) {
            return authcode;
        }
        authcode = AuthenticationLibrary.loginauthen(user, remoteuser, password);
        return authcode;
    }

    public static synchronized String getName(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 0);
    }

    public static synchronized String getPassword(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 1);
    }

    public static synchronized String getUid(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 2);
    }

    public static synchronized String getGid(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 3);
    }

    public static synchronized String getDesc(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 4);
    }

    public static synchronized String getHomedir(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 5);
    }

    public static synchronized String getShell(String user) throws AuthenticationException {
        return AuthenticationLibrary.getUserData(user, 6);
    }

    public static synchronized String getProcessOwnerName() throws AuthenticationException {
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        try {
            return AuthenticationLibrary.processowner();
        }
        catch (Exception e) {
            throw new AuthenticationException("Cannot retrieve current process euid.", e);
        }
    }

    public static String[] getRoleNames(String user) throws AuthenticationException {
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        try {
            return AuthenticationLibrary.getrolenames(user);
        }
        catch (Exception e) {
            throw new AuthenticationException("Cannot retrieve role list.", e);
        }
    }

    private static String getUserData(String user, int index) throws AuthenticationException {
        String data = null;
        String[] userdata = null;
        if (!library_loaded) {
            throw new AuthenticationException("LibraryNotLoaded", (Object)AUTHENTICATION_LIBRARY);
        }
        try {
            userdata = AuthenticationLibrary.userinfo(user);
        }
        catch (Exception ex) {
            userdata = null;
        }
        if (userdata != null && userdata.length > 6) {
            data = userdata[index];
        }
        return data;
    }

    public static VAuditSession getAuditSession() {
        VAuditSessionImpl as = new VAuditSessionImpl();
        return as;
    }

    static {
        try {
            System.loadLibrary(AUTHENTICATION_LIBRARY);
            library_loaded = true;
        }
        catch (Throwable t) {
            Debug.trace((String)"AuthenticationLibrary:Authentication Service", (int)Debug.ERROR, (String)("Unable to load shared library: " + t.getMessage()), null);
        }
    }
}

